/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.messages;

import java.io.IOException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputStreamPlus;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.messages.StreamMessage;

public class ReceivedMessage
extends StreamMessage {
    public static StreamMessage.Serializer<ReceivedMessage> serializer = new StreamMessage.Serializer<ReceivedMessage>(){

        @Override
        public ReceivedMessage deserialize(DataInputPlus input, int version) throws IOException {
            return new ReceivedMessage(TableId.deserialize(input), input.readInt());
        }

        @Override
        public void serialize(ReceivedMessage message, DataOutputStreamPlus out, int version, StreamSession session) throws IOException {
            message.tableId.serialize(out);
            out.writeInt(message.sequenceNumber);
        }

        @Override
        public long serializedSize(ReceivedMessage message, int version) {
            return message.tableId.serializedSize() + 4;
        }
    };
    public final TableId tableId;
    public final int sequenceNumber;

    public ReceivedMessage(TableId tableId, int sequenceNumber) {
        super(StreamMessage.Type.RECEIVED);
        this.tableId = tableId;
        this.sequenceNumber = sequenceNumber;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Received (");
        sb.append(this.tableId).append(", #").append(this.sequenceNumber).append(')');
        return sb.toString();
    }
}

