/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.exceptions.ReadFailureException;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.locator.AbstractReplicaCollection;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.service.reads.ResponseResolver;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.concurrent.SimpleCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCallback<E extends Endpoints<E>, P extends ReplicaPlan.ForRead<E>>
implements RequestCallback<ReadResponse> {
    protected static final Logger logger = LoggerFactory.getLogger(ReadCallback.class);
    public final ResponseResolver resolver;
    final SimpleCondition condition = new SimpleCondition();
    private final long queryStartNanoTime;
    final int blockFor;
    final ReplicaPlan.Shared<E, P> replicaPlan;
    private final ReadCommand command;
    private static final AtomicIntegerFieldUpdater<ReadCallback> recievedUpdater = AtomicIntegerFieldUpdater.newUpdater(ReadCallback.class, "received");
    private volatile int received = 0;
    private static final AtomicIntegerFieldUpdater<ReadCallback> failuresUpdater = AtomicIntegerFieldUpdater.newUpdater(ReadCallback.class, "failures");
    private volatile int failures = 0;
    private final Map<InetAddressAndPort, RequestFailureReason> failureReasonByEndpoint;

    public ReadCallback(ResponseResolver resolver, ReadCommand command, ReplicaPlan.Shared<E, P> replicaPlan, long queryStartNanoTime) {
        this.command = command;
        this.resolver = resolver;
        this.queryStartNanoTime = queryStartNanoTime;
        this.replicaPlan = replicaPlan;
        this.blockFor = ((ReplicaPlan.ForRead)replicaPlan.get()).blockFor();
        this.failureReasonByEndpoint = new ConcurrentHashMap<InetAddressAndPort, RequestFailureReason>();
        assert (!(command instanceof PartitionRangeReadCommand) || this.blockFor >= ((AbstractReplicaCollection)((ReplicaPlan)this.replicaPlan()).contacts()).size());
        if (logger.isTraceEnabled()) {
            logger.trace("Blockfor is {}; setting up requests to {}", (Object)this.blockFor, this.replicaPlan);
        }
    }

    protected P replicaPlan() {
        return (P)((ReplicaPlan.ForRead)this.replicaPlan.get());
    }

    public boolean await(long timePastStart, TimeUnit unit) {
        long time = unit.toNanos(timePastStart) - (System.nanoTime() - this.queryStartNanoTime);
        try {
            return this.condition.await(time, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public void awaitResults() throws ReadFailureException, ReadTimeoutException {
        boolean failed;
        boolean signaled = this.await(this.command.getTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        boolean bl = failed = this.failures > 0 && (this.blockFor > this.resolver.responses.size() || !this.resolver.isDataPresent());
        if (signaled && !failed) {
            return;
        }
        if (Tracing.isTracing()) {
            String gotData = this.received > 0 ? (this.resolver.isDataPresent() ? " (including data)" : " (only digests)") : "";
            Tracing.trace("{}; received {} of {} responses{}", failed ? "Failed" : "Timed out", this.received, this.blockFor, gotData);
        } else if (logger.isDebugEnabled()) {
            String gotData = this.received > 0 ? (this.resolver.isDataPresent() ? " (including data)" : " (only digests)") : "";
            logger.debug("{}; received {} of {} responses{}", new Object[]{failed ? "Failed" : "Timed out", this.received, this.blockFor, gotData});
        }
        throw failed ? new ReadFailureException(((ReplicaPlan)this.replicaPlan()).consistencyLevel(), this.received, this.blockFor, this.resolver.isDataPresent(), this.failureReasonByEndpoint) : new ReadTimeoutException(((ReplicaPlan)this.replicaPlan()).consistencyLevel(), this.received, this.blockFor, this.resolver.isDataPresent());
    }

    public int blockFor() {
        return this.blockFor;
    }

    @Override
    public void onResponse(Message<ReadResponse> message) {
        int n;
        this.resolver.preprocess(message);
        int n2 = n = this.waitingFor(message.from()) ? recievedUpdater.incrementAndGet(this) : this.received;
        if (n >= this.blockFor && this.resolver.isDataPresent()) {
            this.condition.signalAll();
        }
    }

    private boolean waitingFor(InetAddressAndPort from) {
        return !((ReplicaPlan)this.replicaPlan()).consistencyLevel().isDatacenterLocal() || DatabaseDescriptor.getLocalDataCenter().equals(DatabaseDescriptor.getEndpointSnitch().getDatacenter(from));
    }

    public void response(ReadResponse result) {
        Verb kind = this.command.isRangeRequest() ? Verb.RANGE_RSP : Verb.READ_RSP;
        Message<ReadResponse> message = Message.internalResponse(kind, result);
        this.onResponse(message);
    }

    @Override
    public boolean trackLatencyForSnitch() {
        return true;
    }

    @Override
    public void onFailure(InetAddressAndPort from, RequestFailureReason failureReason) {
        int n = this.waitingFor(from) ? failuresUpdater.incrementAndGet(this) : this.failures;
        this.failureReasonByEndpoint.put(from, failureReason);
        if (this.blockFor + n > ((AbstractReplicaCollection)((ReplicaPlan)this.replicaPlan()).contacts()).size()) {
            this.condition.signalAll();
        }
    }

    @Override
    public boolean invokeOnFailure() {
        return true;
    }
}

