/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.IMetadataSerializer;
import org.apache.cassandra.io.sstable.metadata.MetadataSerializer;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;

public class Descriptor {
    private static final String LEGACY_TMP_REGEX_STR = "^((.*)\\-(.*)\\-)?tmp(link)?\\-((?:l|k).)\\-(\\d)*\\-(.*)$";
    private static final Pattern LEGACY_TMP_REGEX = Pattern.compile("^((.*)\\-(.*)\\-)?tmp(link)?\\-((?:l|k).)\\-(\\d)*\\-(.*)$");
    public static String TMP_EXT = ".tmp";
    private static final Splitter filenameSplitter = Splitter.on((char)'-');
    public final File directory;
    public final Version version;
    public final String ksname;
    public final String cfname;
    public final int generation;
    public final SSTableFormat.Type formatType;
    private final int hashCode;

    @VisibleForTesting
    public Descriptor(File directory, String ksname, String cfname, int generation) {
        this(SSTableFormat.Type.current().info.getLatestVersion(), directory, ksname, cfname, generation, SSTableFormat.Type.current());
    }

    public Descriptor(File directory, String ksname, String cfname, int generation, SSTableFormat.Type formatType) {
        this(formatType.info.getLatestVersion(), directory, ksname, cfname, generation, formatType);
    }

    @VisibleForTesting
    public Descriptor(String version, File directory, String ksname, String cfname, int generation, SSTableFormat.Type formatType) {
        this(formatType.info.getVersion(version), directory, ksname, cfname, generation, formatType);
    }

    public Descriptor(Version version, File directory, String ksname, String cfname, int generation, SSTableFormat.Type formatType) {
        assert (version != null && directory != null && ksname != null && cfname != null && formatType.info.getLatestVersion().getClass().equals(version.getClass()));
        this.version = version;
        try {
            this.directory = directory.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        this.ksname = ksname;
        this.cfname = cfname;
        this.generation = generation;
        this.formatType = formatType;
        this.hashCode = Objects.hashCode((Object[])new Object[]{version, this.directory, generation, ksname, cfname, formatType});
    }

    public Descriptor withGeneration(int newGeneration) {
        return new Descriptor(this.version, this.directory, this.ksname, this.cfname, newGeneration, this.formatType);
    }

    public Descriptor withFormatType(SSTableFormat.Type newType) {
        return new Descriptor(newType.info.getLatestVersion(), this.directory, this.ksname, this.cfname, this.generation, newType);
    }

    public String tmpFilenameFor(Component component) {
        return this.filenameFor(component) + TMP_EXT;
    }

    public String tmpFilenameForStreaming(Component component) {
        return String.format("%s.%s%s", this.filenameFor(component), UUIDGen.getTimeUUID(), TMP_EXT);
    }

    public String filenameFor(Component component) {
        return this.baseFilename() + '-' + component.name();
    }

    public String baseFilename() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.directory).append(File.separatorChar);
        this.appendFileName(buff);
        return buff.toString();
    }

    private void appendFileName(StringBuilder buff) {
        buff.append(this.version).append('-');
        buff.append(this.generation);
        buff.append('-').append(this.formatType.name);
    }

    public String relativeFilenameFor(Component component) {
        StringBuilder buff = new StringBuilder();
        if (Directories.isSecondaryIndexFolder(this.directory)) {
            buff.append(this.directory.getName()).append(File.separator);
        }
        this.appendFileName(buff);
        buff.append('-').append(component.name());
        return buff.toString();
    }

    public SSTableFormat getFormat() {
        return this.formatType.info;
    }

    public List<File> getTemporaryFiles() {
        File[] tmpFiles = this.directory.listFiles((dir, name) -> name.endsWith(TMP_EXT));
        ArrayList<File> ret = new ArrayList<File>(tmpFiles.length);
        for (File tmpFile : tmpFiles) {
            ret.add(tmpFile);
        }
        return ret;
    }

    public static boolean isValidFile(File file) {
        String filename = file.getName();
        return filename.endsWith(".db") && !LEGACY_TMP_REGEX.matcher(filename).matches();
    }

    public static Descriptor fromFilename(String filename) {
        return Descriptor.fromFilename(new File(filename));
    }

    public static Descriptor fromFilename(File file) {
        return (Descriptor)Descriptor.fromFilenameWithComponent((File)file).left;
    }

    public static Pair<Descriptor, Component> fromFilenameWithComponent(File file) {
        File directory;
        SSTableFormat.Type format;
        int generation;
        String name;
        List tokens;
        int size;
        if (!file.isAbsolute()) {
            file = file.getAbsoluteFile();
        }
        if ((size = (tokens = filenameSplitter.splitToList((CharSequence)(name = file.getName()))).size()) != 4) {
            if (size == 5 || size == 6) {
                throw new IllegalArgumentException(String.format("%s is of version %s which is now unsupported and cannot be read.", name, tokens.get(size - 3)));
            }
            throw new IllegalArgumentException(String.format("Invalid sstable file %s: the name doesn't look like a supported sstable file name", name));
        }
        String versionString = (String)tokens.get(0);
        if (!Version.validate(versionString)) {
            throw Descriptor.invalidSSTable(name, "invalid version %s", versionString);
        }
        try {
            generation = Integer.parseInt((String)tokens.get(1));
        }
        catch (NumberFormatException e) {
            throw Descriptor.invalidSSTable(name, "the 'generation' part of the name doesn't parse as a number", new Object[0]);
        }
        String formatString = (String)tokens.get(2);
        try {
            format = SSTableFormat.Type.validate(formatString);
        }
        catch (IllegalArgumentException e) {
            throw Descriptor.invalidSSTable(name, "unknown 'format' part (%s)", formatString);
        }
        Component component = Component.parse((String)tokens.get(3));
        Version version = format.info.getVersion(versionString);
        if (!version.isCompatible()) {
            throw Descriptor.invalidSSTable(name, "incompatible sstable version (%s); you should have run upgradesstables before upgrading", versionString);
        }
        File tableDir = directory = Descriptor.parentOf(name, file);
        String indexName = "";
        if (Directories.isSecondaryIndexFolder(tableDir)) {
            indexName = tableDir.getName();
            tableDir = Descriptor.parentOf(name, tableDir);
        }
        if (tableDir.getName().equals("backups")) {
            tableDir = tableDir.getParentFile();
        } else if (Descriptor.parentOf(name, tableDir).getName().equals("snapshots")) {
            tableDir = Descriptor.parentOf(name, Descriptor.parentOf(name, tableDir));
        }
        String table = tableDir.getName().split("-")[0] + indexName;
        String keyspace = Descriptor.parentOf(name, tableDir).getName();
        return Pair.create(new Descriptor(version, directory, keyspace, table, generation, format), component);
    }

    private static File parentOf(String name, File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            throw Descriptor.invalidSSTable(name, "cannot extract keyspace and table name; make sure the sstable is in the proper sub-directories", new Object[0]);
        }
        return parent;
    }

    private static IllegalArgumentException invalidSSTable(String name, String msgFormat, Object ... parameters) {
        throw new IllegalArgumentException(String.format("Invalid sstable file " + name + ": " + msgFormat, parameters));
    }

    public IMetadataSerializer getMetadataSerializer() {
        return new MetadataSerializer();
    }

    public boolean isCompatible() {
        return this.version.isCompatible();
    }

    public String toString() {
        return this.baseFilename();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Descriptor)) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        return that.directory.equals(this.directory) && that.generation == this.generation && that.ksname.equals(this.ksname) && that.cfname.equals(this.cfname) && that.version.equals(this.version) && that.formatType == this.formatType;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

