/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.concurrent.CompletableFuture;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.ForwardingInfo;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.ParamType;
import org.apache.cassandra.tracing.Tracing;

public class MutationVerbHandler
implements IVerbHandler<Mutation> {
    public static final MutationVerbHandler instance = new MutationVerbHandler();

    private void respond(Message<?> respondTo, InetAddressAndPort respondToAddress) {
        Tracing.trace("Enqueuing response to {}", (Object)respondToAddress);
        MessagingService.instance().send(respondTo.emptyResponse(), respondToAddress);
    }

    private void failed() {
        Tracing.trace("Payload application resulted in WriteTimeout, not replying");
    }

    @Override
    public void doVerb(Message<Mutation> message) {
        InetAddressAndPort respondToAddress;
        InetAddressAndPort from = message.respondTo();
        if (from == null) {
            respondToAddress = message.from();
            ForwardingInfo forwardTo = message.forwardTo();
            if (forwardTo != null) {
                MutationVerbHandler.forwardToLocalNodes(message, forwardTo);
            }
        } else {
            respondToAddress = from;
        }
        try {
            ((CompletableFuture)((Mutation)message.payload).applyFuture().thenAccept(o -> this.respond(message, respondToAddress))).exceptionally(wto -> {
                this.failed();
                return null;
            });
        }
        catch (WriteTimeoutException wto2) {
            this.failed();
        }
    }

    private static void forwardToLocalNodes(Message<Mutation> originalMessage, ForwardingInfo forwardTo) {
        Message.Builder<Mutation> builder = Message.builder(originalMessage).withParam(ParamType.RESPOND_TO, originalMessage.from()).withoutParam(ParamType.FORWARD_TO);
        boolean useSameMessageID = forwardTo.useSameMessageID();
        Message<Mutation> message = useSameMessageID ? builder.build() : null;
        forwardTo.forEach((id, target) -> {
            Tracing.trace("Enqueuing forwarded write to {}", target);
            MessagingService.instance().send(useSameMessageID ? message : builder.withId((long)id).build(), (InetAddressAndPort)target);
        });
    }
}

