/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.MurmurHash;

public abstract class DecoratedKey
implements PartitionPosition,
IFilter.FilterKey {
    public static final Comparator<DecoratedKey> comparator = new Comparator<DecoratedKey>(){

        @Override
        public int compare(DecoratedKey o1, DecoratedKey o2) {
            return o1.compareTo(o2);
        }
    };
    private final Token token;

    public DecoratedKey(Token token) {
        assert (token != null);
        this.token = token;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DecoratedKey)) {
            return false;
        }
        DecoratedKey other = (DecoratedKey)obj;
        return ByteBufferUtil.compareUnsigned(this.getKey(), other.getKey()) == 0;
    }

    @Override
    public int compareTo(PartitionPosition pos) {
        if (this == pos) {
            return 0;
        }
        if (!(pos instanceof DecoratedKey)) {
            return -pos.compareTo(this);
        }
        DecoratedKey otherKey = (DecoratedKey)pos;
        int cmp = this.getToken().compareTo(otherKey.getToken());
        return cmp == 0 ? ByteBufferUtil.compareUnsigned(this.getKey(), otherKey.getKey()) : cmp;
    }

    public static int compareTo(IPartitioner partitioner, ByteBuffer key, PartitionPosition position) {
        if (!(position instanceof DecoratedKey)) {
            return -position.compareTo(partitioner.decorateKey(key));
        }
        DecoratedKey otherKey = (DecoratedKey)position;
        int cmp = partitioner.getToken(key).compareTo(otherKey.getToken());
        return cmp == 0 ? ByteBufferUtil.compareUnsigned(key, otherKey.getKey()) : cmp;
    }

    @Override
    public IPartitioner getPartitioner() {
        return this.getToken().getPartitioner();
    }

    @Override
    public Token.KeyBound minValue() {
        return this.getPartitioner().getMinimumToken().minKeyBound();
    }

    @Override
    public boolean isMinimum() {
        return false;
    }

    @Override
    public PartitionPosition.Kind kind() {
        return PartitionPosition.Kind.ROW_KEY;
    }

    public String toString() {
        String keystring = this.getKey() == null ? "null" : ByteBufferUtil.bytesToHex(this.getKey());
        return "DecoratedKey(" + this.getToken() + ", " + keystring + ")";
    }

    @Override
    public Token getToken() {
        return this.token;
    }

    public abstract ByteBuffer getKey();

    @Override
    public void filterHash(long[] dest) {
        ByteBuffer key = this.getKey();
        MurmurHash.hash3_x64_128(key, key.position(), key.remaining(), 0L, dest);
    }
}

