/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.cql3.statements.schema.TableAttributes;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.schema.ViewMetadata;
import org.apache.cassandra.schema.Views;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.reads.repair.ReadRepairStrategy;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AlterTableStatement
extends AlterSchemaStatement {
    protected final String tableName;

    public AlterTableStatement(String keyspaceName, String tableName) {
        super(keyspaceName);
        this.tableName = tableName;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) throws UnknownHostException {
        TableMetadata table;
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        TableMetadata tableMetadata = table = null == keyspace ? null : keyspace.getTableOrViewNullable(this.tableName);
        if (null == table) {
            throw AlterTableStatement.ire("Table '%s.%s' doesn't exist", this.keyspaceName, this.tableName);
        }
        if (table.isView()) {
            throw AlterTableStatement.ire("Cannot use ALTER TABLE on a materialized view; use ALTER MATERIALIZED VIEW instead", new Object[0]);
        }
        return schema.withAddedOrUpdated(this.apply(keyspace, table));
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspaceName, this.tableName);
    }

    @Override
    public void authorize(ClientState client) {
        client.ensureTablePermission(this.keyspaceName, this.tableName, Permission.ALTER);
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.ALTER_TABLE, this.keyspaceName, this.tableName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.tableName);
    }

    abstract KeyspaceMetadata apply(KeyspaceMetadata var1, TableMetadata var2) throws UnknownHostException;

    public static final class Raw
    extends CQLStatement.Raw {
        private final QualifiedName name;
        private Kind kind;
        private final List<AddColumns.Column> addedColumns = new ArrayList<AddColumns.Column>();
        private final Set<ColumnIdentifier> droppedColumns = new HashSet<ColumnIdentifier>();
        private Long timestamp = null;
        private final Map<ColumnIdentifier, ColumnIdentifier> renamedColumns = new HashMap<ColumnIdentifier, ColumnIdentifier>();
        public final TableAttributes attrs = new TableAttributes();

        public Raw(QualifiedName name) {
            this.name = name;
        }

        @Override
        public AlterTableStatement prepare(ClientState state) {
            String keyspaceName = this.name.hasKeyspace() ? this.name.getKeyspace() : state.getKeyspace();
            String tableName = this.name.getName();
            switch (this.kind) {
                case ALTER_COLUMN: {
                    return new AlterColumn(keyspaceName, tableName);
                }
                case ADD_COLUMNS: {
                    return new AddColumns(keyspaceName, tableName, this.addedColumns);
                }
                case DROP_COLUMNS: {
                    return new DropColumns(keyspaceName, tableName, this.droppedColumns, this.timestamp);
                }
                case RENAME_COLUMNS: {
                    return new RenameColumns(keyspaceName, tableName, this.renamedColumns);
                }
                case ALTER_OPTIONS: {
                    return new AlterOptions(keyspaceName, tableName, this.attrs);
                }
                case DROP_COMPACT_STORAGE: {
                    return new DropCompactStorage(keyspaceName, tableName);
                }
            }
            throw new AssertionError();
        }

        public void alter(ColumnIdentifier name, CQL3Type.Raw type) {
            this.kind = Kind.ALTER_COLUMN;
        }

        public void add(ColumnIdentifier name, CQL3Type.Raw type, boolean isStatic) {
            this.kind = Kind.ADD_COLUMNS;
            this.addedColumns.add(new AddColumns.Column(name, type, isStatic));
        }

        public void drop(ColumnIdentifier name) {
            this.kind = Kind.DROP_COLUMNS;
            this.droppedColumns.add(name);
        }

        public void dropCompactStorage() {
            this.kind = Kind.DROP_COMPACT_STORAGE;
        }

        public void timestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public void rename(ColumnIdentifier from, ColumnIdentifier to) {
            this.kind = Kind.RENAME_COLUMNS;
            this.renamedColumns.put(from, to);
        }

        public void attrs() {
            this.kind = Kind.ALTER_OPTIONS;
        }

        private static enum Kind {
            ALTER_COLUMN,
            ADD_COLUMNS,
            DROP_COLUMNS,
            RENAME_COLUMNS,
            ALTER_OPTIONS,
            DROP_COMPACT_STORAGE;

        }
    }

    private static class DropCompactStorage
    extends AlterTableStatement {
        private static final Logger logger = LoggerFactory.getLogger(AlterTableStatement.class);
        private static final NoSpamLogger noSpamLogger = NoSpamLogger.getLogger(logger, 5L, TimeUnit.MINUTES);

        private DropCompactStorage(String keyspaceName, String tableName) {
            super(keyspaceName, tableName);
        }

        @Override
        public KeyspaceMetadata apply(KeyspaceMetadata keyspace, TableMetadata table) {
            if (!DatabaseDescriptor.enableDropCompactStorage()) {
                throw new InvalidRequestException("DROP COMPACT STORAGE is disabled. Enable in cassandra.yaml to use.");
            }
            if (!table.isCompactTable()) {
                throw AlterTableStatement.ire("Cannot DROP COMPACT STORAGE on table without COMPACT STORAGE", new Object[0]);
            }
            this.validateCanDropCompactStorage();
            ImmutableSet flags = table.isCounter() ? ImmutableSet.of((Object)((Object)TableMetadata.Flag.COMPOUND), (Object)((Object)TableMetadata.Flag.COUNTER)) : ImmutableSet.of((Object)((Object)TableMetadata.Flag.COMPOUND));
            return keyspace.withSwapped(keyspace.tables.withSwapped(table.withSwapped((Set<TableMetadata.Flag>)flags)));
        }

        private void validateCanDropCompactStorage() {
            HashSet<InetAddressAndPort> before4 = new HashSet<InetAddressAndPort>();
            HashSet<InetAddressAndPort> preC15897nodes = new HashSet<InetAddressAndPort>();
            HashSet<InetAddressAndPort> with2xSStables = new HashSet<InetAddressAndPort>();
            Splitter onComma = Splitter.on((char)',').omitEmptyStrings().trimResults();
            for (InetAddressAndPort node : StorageService.instance.getTokenMetadata().getAllEndpoints()) {
                if (MessagingService.instance().versions.knows(node) && MessagingService.instance().versions.getRaw(node) < 12) {
                    before4.add(node);
                    continue;
                }
                String sstableVersionsString = Gossiper.instance.getApplicationState(node, ApplicationState.SSTABLE_VERSIONS);
                if (sstableVersionsString == null) {
                    preC15897nodes.add(node);
                    continue;
                }
                try {
                    boolean has2xSStables = onComma.splitToList((CharSequence)sstableVersionsString).stream().anyMatch(v -> v.compareTo("big-ma") <= 0);
                    if (!has2xSStables) continue;
                    with2xSStables.add(node);
                }
                catch (IllegalArgumentException e) {
                    noSpamLogger.error("Unexpected error parsing sstable versions from gossip for {} (gossiped value is '{}'). This is a bug and should be reported. Cannot ensure that {} has no non-upgraded 2.x sstables anymore. If after this DROP COMPACT STORAGE some old sstables cannot be read anymore, please use `upgradesstables` with the `--force-compact-storage-on` option.", node, sstableVersionsString, node);
                }
            }
            if (!before4.isEmpty()) {
                throw new InvalidRequestException(String.format("Cannot DROP COMPACT STORAGE as some nodes in the cluster (%s) are not on 4.0+ yet. Please upgrade those nodes and run `upgradesstables` before retrying.", before4));
            }
            if (!preC15897nodes.isEmpty()) {
                throw new InvalidRequestException(String.format("Cannot guarantee that DROP COMPACT STORAGE is safe as some nodes in the cluster (%s) do not have https://issues.apache.org/jira/browse/CASSANDRA-15897. Please upgrade those nodes and retry.", preC15897nodes));
            }
            if (!with2xSStables.isEmpty()) {
                throw new InvalidRequestException(String.format("Cannot DROP COMPACT STORAGE as some nodes in the cluster (%s) has some non-upgraded 2.x sstables. Please run `upgradesstables` on those nodes before retrying", with2xSStables));
            }
        }
    }

    private static class AlterOptions
    extends AlterTableStatement {
        private final TableAttributes attrs;

        private AlterOptions(String keyspaceName, String tableName, TableAttributes attrs) {
            super(keyspaceName, tableName);
            this.attrs = attrs;
        }

        @Override
        public KeyspaceMetadata apply(KeyspaceMetadata keyspace, TableMetadata table) {
            this.attrs.validate();
            TableParams params = this.attrs.asAlteredTableParams(table.params);
            if (table.isCounter() && params.defaultTimeToLive > 0) {
                throw AlterOptions.ire("Cannot set default_time_to_live on a table with counters", new Object[0]);
            }
            if (!Iterables.isEmpty(keyspace.views.forTable(table.id)) && params.gcGraceSeconds == 0) {
                throw AlterOptions.ire("Cannot alter gc_grace_seconds of the base table of a materialized view to 0, since this value is used to TTL undelivered updates. Setting gc_grace_seconds too low might cause undelivered updates to expire before being replayed.", new Object[0]);
            }
            if (keyspace.createReplicationStrategy().hasTransientReplicas() && params.readRepair != ReadRepairStrategy.NONE) {
                throw AlterOptions.ire("read_repair must be set to 'NONE' for transiently replicated keyspaces", new Object[0]);
            }
            return keyspace.withSwapped(keyspace.tables.withSwapped(table.withSwapped(params)));
        }
    }

    private static class RenameColumns
    extends AlterTableStatement {
        private final Map<ColumnIdentifier, ColumnIdentifier> renamedColumns;

        private RenameColumns(String keyspaceName, String tableName, Map<ColumnIdentifier, ColumnIdentifier> renamedColumns) {
            super(keyspaceName, tableName);
            this.renamedColumns = renamedColumns;
        }

        @Override
        public KeyspaceMetadata apply(KeyspaceMetadata keyspace, TableMetadata table) {
            TableMetadata.Builder tableBuilder = table.unbuild();
            Views.Builder viewsBuilder = keyspace.views.unbuild();
            this.renamedColumns.forEach((o, n) -> this.renameColumn(keyspace, table, (ColumnIdentifier)o, (ColumnIdentifier)n, tableBuilder, viewsBuilder));
            return keyspace.withSwapped(keyspace.tables.withSwapped(tableBuilder.build())).withSwapped(viewsBuilder.build());
        }

        private void renameColumn(KeyspaceMetadata keyspace, TableMetadata table, ColumnIdentifier oldName, ColumnIdentifier newName, TableMetadata.Builder tableBuilder, Views.Builder viewsBuilder) {
            ColumnMetadata column = table.getExistingColumn(oldName);
            if (null == column) {
                throw RenameColumns.ire("Column %s was not found in table %s", oldName, table);
            }
            if (!column.isPrimaryKeyColumn()) {
                throw RenameColumns.ire("Cannot rename non PRIMARY KEY column %s", oldName);
            }
            if (null != table.getColumn(newName)) {
                throw RenameColumns.ire("Cannot rename column %s to %s in table '%s'; another column with that name already exists", oldName, newName, table);
            }
            Set<IndexMetadata> dependentIndexes = Keyspace.openAndGetStore((TableMetadata)table).indexManager.getDependentIndexes(column);
            if (!dependentIndexes.isEmpty()) {
                throw RenameColumns.ire("Can't rename column %s because it has dependent secondary indexes (%s)", oldName, String.join((CharSequence)", ", Iterables.transform(dependentIndexes, i -> i.name)));
            }
            for (ViewMetadata view : keyspace.views.forTable(table.id)) {
                if (!view.includes(oldName)) continue;
                viewsBuilder.put(viewsBuilder.get(view.name()).withRenamedPrimaryKeyColumn(oldName, newName));
            }
            tableBuilder.renamePrimaryKeyColumn(oldName, newName);
        }
    }

    private static class DropColumns
    extends AlterTableStatement {
        private final Set<ColumnIdentifier> removedColumns;
        private final Long timestamp;

        private DropColumns(String keyspaceName, String tableName, Set<ColumnIdentifier> removedColumns, Long timestamp) {
            super(keyspaceName, tableName);
            this.removedColumns = removedColumns;
            this.timestamp = timestamp;
        }

        @Override
        public KeyspaceMetadata apply(KeyspaceMetadata keyspace, TableMetadata table) {
            TableMetadata.Builder builder = table.unbuild();
            this.removedColumns.forEach(c -> this.dropColumn(keyspace, table, (ColumnIdentifier)c, builder));
            return keyspace.withSwapped(keyspace.tables.withSwapped(builder.build()));
        }

        private void dropColumn(KeyspaceMetadata keyspace, TableMetadata table, ColumnIdentifier column, TableMetadata.Builder builder) {
            ColumnMetadata currentColumn = table.getColumn(column);
            if (null == currentColumn) {
                throw DropColumns.ire("Column %s was not found in table '%s'", column, table);
            }
            if (currentColumn.isPrimaryKeyColumn()) {
                throw DropColumns.ire("Cannot drop PRIMARY KEY column %s", column);
            }
            if (currentColumn.type.isUDT() && currentColumn.type.isMultiCell()) {
                throw DropColumns.ire("Cannot drop non-frozen column %s of user type %s", column, currentColumn.type.asCQL3Type());
            }
            Set<IndexMetadata> dependentIndexes = Keyspace.openAndGetStore((TableMetadata)table).indexManager.getDependentIndexes(currentColumn);
            if (!dependentIndexes.isEmpty()) {
                throw DropColumns.ire("Cannot drop column %s because it has dependent secondary indexes (%s)", currentColumn, String.join((CharSequence)", ", Iterables.transform(dependentIndexes, i -> i.name)));
            }
            if (!Iterables.isEmpty(keyspace.views.forTable(table.id))) {
                throw DropColumns.ire("Cannot drop column %s on base table %s with materialized views", currentColumn, table.name);
            }
            builder.removeRegularOrStaticColumn(column);
            builder.recordColumnDrop(currentColumn, this.getTimestamp());
        }

        private long getTimestamp() {
            return this.timestamp == null ? ClientState.getTimestamp() : this.timestamp;
        }
    }

    private static class AddColumns
    extends AlterTableStatement {
        private final Collection<Column> newColumns;

        private AddColumns(String keyspaceName, String tableName, Collection<Column> newColumns) {
            super(keyspaceName, tableName);
            this.newColumns = newColumns;
        }

        @Override
        public KeyspaceMetadata apply(KeyspaceMetadata keyspace, TableMetadata table) {
            TableMetadata.Builder tableBuilder = table.unbuild();
            Views.Builder viewsBuilder = keyspace.views.unbuild();
            this.newColumns.forEach(c -> this.addColumn(keyspace, table, (Column)c, tableBuilder, viewsBuilder));
            TableMetadata tableMetadata = tableBuilder.build();
            tableMetadata.validate();
            return keyspace.withSwapped(keyspace.tables.withSwapped(tableMetadata)).withSwapped(viewsBuilder.build());
        }

        private void addColumn(KeyspaceMetadata keyspace, TableMetadata table, Column column, TableMetadata.Builder tableBuilder, Views.Builder viewsBuilder) {
            ColumnIdentifier name = column.name;
            AbstractType<?> type = column.type.prepare(this.keyspaceName, keyspace.types).getType();
            boolean isStatic = column.isStatic;
            if (null != tableBuilder.getColumn(name)) {
                throw AddColumns.ire("Column with name '%s' already exists", name);
            }
            if (isStatic && table.clusteringColumns().isEmpty()) {
                throw AddColumns.ire("Static columns are only useful (and thus allowed) if the table has at least one clustering column", new Object[0]);
            }
            ColumnMetadata droppedColumn = table.getDroppedColumn(name.bytes);
            if (null != droppedColumn) {
                if (!type.isValueCompatibleWith(droppedColumn.type)) {
                    throw AddColumns.ire("Cannot re-add previously dropped column '%s' of type %s, incompatible with previous type %s", name, type.asCQL3Type(), droppedColumn.type.asCQL3Type());
                }
                if (droppedColumn.isStatic() != isStatic) {
                    throw AddColumns.ire("Cannot re-add previously dropped column '%s' of kind %s, incompatible with previous kind %s", new Object[]{name, isStatic ? ColumnMetadata.Kind.STATIC : ColumnMetadata.Kind.REGULAR, droppedColumn.kind});
                }
                if (table.isCounter()) {
                    throw AddColumns.ire("Cannot re-add previously dropped counter column %s", name);
                }
            }
            if (isStatic) {
                tableBuilder.addStaticColumn(name, type);
            } else {
                tableBuilder.addRegularColumn(name, type);
            }
            if (!isStatic) {
                for (ViewMetadata view : keyspace.views.forTable(table.id)) {
                    if (!view.includeAllColumns) continue;
                    ColumnMetadata viewColumn = ColumnMetadata.regularColumn(view.metadata, name.bytes, type);
                    viewsBuilder.put(viewsBuilder.get(view.name()).withAddedRegularColumn(viewColumn));
                }
            }
        }

        private static class Column {
            private final ColumnIdentifier name;
            private final CQL3Type.Raw type;
            private final boolean isStatic;

            Column(ColumnIdentifier name, CQL3Type.Raw type, boolean isStatic) {
                this.name = name;
                this.type = type;
                this.isStatic = isStatic;
            }
        }
    }

    public static class AlterColumn
    extends AlterTableStatement {
        AlterColumn(String keyspaceName, String tableName) {
            super(keyspaceName, tableName);
        }

        @Override
        public KeyspaceMetadata apply(KeyspaceMetadata keyspace, TableMetadata table) {
            throw AlterColumn.ire("Altering column types is no longer supported", new Object[0]);
        }
    }
}

