/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.cassandra.audit.AuditLogOptions;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.config.ReplicaFilteringProtectionOptions;
import org.apache.cassandra.config.TransparentDataEncryptionOptions;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.fql.FullQueryLoggerOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    public static final String PROPERTY_PREFIX = "cassandra.";
    public String cluster_name = "Test Cluster";
    public String authenticator;
    public String authorizer;
    public String role_manager;
    public String network_authorizer;
    public volatile int permissions_validity_in_ms = 2000;
    public volatile int permissions_cache_max_entries = 1000;
    public volatile int permissions_update_interval_in_ms = -1;
    public volatile int roles_validity_in_ms = 2000;
    public volatile int roles_cache_max_entries = 1000;
    public volatile int roles_update_interval_in_ms = -1;
    public volatile int credentials_validity_in_ms = 2000;
    public volatile int credentials_cache_max_entries = 1000;
    public volatile int credentials_update_interval_in_ms = -1;
    public String partitioner;
    public boolean auto_bootstrap = true;
    public volatile boolean hinted_handoff_enabled = true;
    public Set<String> hinted_handoff_disabled_datacenters = Sets.newConcurrentHashSet();
    public volatile int max_hint_window_in_ms = 10800000;
    public String hints_directory;
    public ParameterizedClass seed_provider;
    public DiskAccessMode disk_access_mode = DiskAccessMode.auto;
    public DiskFailurePolicy disk_failure_policy = DiskFailurePolicy.ignore;
    public CommitFailurePolicy commit_failure_policy = CommitFailurePolicy.stop;
    public String initial_token;
    public Integer num_tokens;
    public String allocate_tokens_for_keyspace = null;
    public Integer allocate_tokens_for_local_replication_factor = null;
    public long native_transport_idle_timeout_in_ms = 0L;
    public volatile long request_timeout_in_ms = 10000L;
    public volatile long read_request_timeout_in_ms = 5000L;
    public volatile long range_request_timeout_in_ms = 10000L;
    public volatile long write_request_timeout_in_ms = 2000L;
    public volatile long counter_write_request_timeout_in_ms = 5000L;
    public volatile long cas_contention_timeout_in_ms = 1000L;
    public volatile long truncate_request_timeout_in_ms = 60000L;
    public Integer streaming_connections_per_host = 1;
    public Integer streaming_keep_alive_period_in_secs = 300;
    public boolean cross_node_timeout = true;
    public volatile long slow_query_log_timeout_in_ms = 500L;
    public volatile double phi_convict_threshold = 8.0;
    public int concurrent_reads = 32;
    public int concurrent_writes = 32;
    public int concurrent_counter_writes = 32;
    public int concurrent_materialized_view_writes = 32;
    @Deprecated
    public Integer concurrent_replicates = null;
    public int memtable_flush_writers = 0;
    public Integer memtable_heap_space_in_mb;
    public Integer memtable_offheap_space_in_mb;
    public Float memtable_cleanup_threshold = null;
    @Deprecated
    public volatile Integer repair_session_max_tree_depth = null;
    public volatile Integer repair_session_space_in_mb = null;
    public volatile boolean use_offheap_merkle_trees = true;
    public int storage_port = 7000;
    public int ssl_storage_port = 7001;
    public String listen_address;
    public String listen_interface;
    public boolean listen_interface_prefer_ipv6 = false;
    public String broadcast_address;
    public boolean listen_on_broadcast_address = false;
    public String internode_authenticator;
    public String rpc_address;
    public String rpc_interface;
    public boolean rpc_interface_prefer_ipv6 = false;
    public String broadcast_rpc_address;
    public boolean rpc_keepalive = true;
    public Integer internode_max_message_size_in_bytes;
    public int internode_socket_send_buffer_size_in_bytes = 0;
    public int internode_socket_receive_buffer_size_in_bytes = 0;
    public int internode_application_send_queue_capacity_in_bytes = 0x400000;
    public int internode_application_send_queue_reserve_endpoint_capacity_in_bytes = 0x8000000;
    public int internode_application_send_queue_reserve_global_capacity_in_bytes = 0x20000000;
    public int internode_application_receive_queue_capacity_in_bytes = 0x400000;
    public int internode_application_receive_queue_reserve_endpoint_capacity_in_bytes = 0x8000000;
    public int internode_application_receive_queue_reserve_global_capacity_in_bytes = 0x20000000;
    public volatile int internode_tcp_connect_timeout_in_ms = 2000;
    public volatile int internode_tcp_user_timeout_in_ms = 30000;
    public volatile int internode_streaming_tcp_user_timeout_in_ms = 300000;
    public boolean start_native_transport = true;
    public int native_transport_port = 9042;
    public Integer native_transport_port_ssl = null;
    public int native_transport_max_threads = 128;
    public int native_transport_max_frame_size_in_mb = 256;
    public volatile long native_transport_max_concurrent_connections = -1L;
    public volatile long native_transport_max_concurrent_connections_per_ip = -1L;
    public boolean native_transport_flush_in_batches_legacy = false;
    public volatile boolean native_transport_allow_older_protocols = true;
    public volatile long native_transport_max_concurrent_requests_in_bytes_per_ip = -1L;
    public volatile long native_transport_max_concurrent_requests_in_bytes = -1L;
    public int native_transport_receive_queue_capacity_in_bytes = 0x100000;
    @Deprecated
    public Integer native_transport_max_negotiable_protocol_version = null;
    public int max_value_size_in_mb = 256;
    public boolean snapshot_before_compaction = false;
    public boolean auto_snapshot = true;
    public volatile long snapshot_links_per_second = 0L;
    public int column_index_size_in_kb = 64;
    public volatile int column_index_cache_size_in_kb = 2;
    public volatile int batch_size_warn_threshold_in_kb = 5;
    public volatile int batch_size_fail_threshold_in_kb = 50;
    public Integer unlogged_batch_across_partitions_warn_threshold = 10;
    public volatile Integer concurrent_compactors;
    public volatile int compaction_throughput_mb_per_sec = 16;
    public volatile int compaction_large_partition_warning_threshold_mb = 100;
    public int min_free_space_per_drive_in_mb = 50;
    public volatile int concurrent_materialized_view_builders = 1;
    public volatile int reject_repair_compaction_threshold = Integer.MAX_VALUE;
    @Deprecated
    public int max_streaming_retries = 3;
    public volatile int stream_throughput_outbound_megabits_per_sec = 200;
    public volatile int inter_dc_stream_throughput_outbound_megabits_per_sec = 200;
    public String[] data_file_directories = new String[0];
    public String local_system_data_file_directory;
    public String saved_caches_directory;
    public String commitlog_directory;
    public Integer commitlog_total_space_in_mb;
    public CommitLogSync commitlog_sync;
    public double commitlog_sync_batch_window_in_ms = Double.NaN;
    public double commitlog_sync_group_window_in_ms = Double.NaN;
    public int commitlog_sync_period_in_ms;
    public int commitlog_segment_size_in_mb = 32;
    public ParameterizedClass commitlog_compression;
    public FlushCompression flush_compression = FlushCompression.fast;
    public int commitlog_max_compression_buffers_in_pool = 3;
    public Integer periodic_commitlog_sync_lag_block_in_ms;
    public TransparentDataEncryptionOptions transparent_data_encryption_options = new TransparentDataEncryptionOptions();
    public Integer max_mutation_size_in_kb;
    public boolean cdc_enabled = false;
    public String cdc_raw_directory;
    public int cdc_total_space_in_mb = 0;
    public int cdc_free_space_check_interval_ms = 250;
    @Deprecated
    public int commitlog_periodic_queue_size = -1;
    public String endpoint_snitch;
    public boolean dynamic_snitch = true;
    public int dynamic_snitch_update_interval_in_ms = 100;
    public int dynamic_snitch_reset_interval_in_ms = 600000;
    public double dynamic_snitch_badness_threshold = 1.0;
    public EncryptionOptions.ServerEncryptionOptions server_encryption_options = new EncryptionOptions.ServerEncryptionOptions();
    public EncryptionOptions client_encryption_options = new EncryptionOptions();
    public InternodeCompression internode_compression = InternodeCompression.none;
    public int hinted_handoff_throttle_in_kb = 1024;
    public int batchlog_replay_throttle_in_kb = 1024;
    public int max_hints_delivery_threads = 2;
    public int hints_flush_period_in_ms = 10000;
    public int max_hints_file_size_in_mb = 128;
    public ParameterizedClass hints_compression;
    public volatile boolean incremental_backups = false;
    public boolean trickle_fsync = false;
    public int trickle_fsync_interval_in_kb = 10240;
    public volatile int sstable_preemptive_open_interval_in_mb = 50;
    public volatile boolean key_cache_migrate_during_compaction = true;
    public Long key_cache_size_in_mb = null;
    public volatile int key_cache_save_period = 14400;
    public volatile int key_cache_keys_to_save = Integer.MAX_VALUE;
    public String row_cache_class_name = "org.apache.cassandra.cache.OHCProvider";
    public long row_cache_size_in_mb = 0L;
    public volatile int row_cache_save_period = 0;
    public volatile int row_cache_keys_to_save = Integer.MAX_VALUE;
    public Long counter_cache_size_in_mb = null;
    public volatile int counter_cache_save_period = 7200;
    public volatile int counter_cache_keys_to_save = Integer.MAX_VALUE;
    private static boolean isClientMode = false;
    private static Supplier<Config> overrideLoadConfig = null;
    public Integer networking_cache_size_in_mb;
    public Integer file_cache_size_in_mb;
    public boolean file_cache_enabled = Boolean.getBoolean("cassandra.file_cache_enabled");
    public Boolean file_cache_round_up;
    @Deprecated
    public boolean buffer_pool_use_heap_if_exhausted;
    public DiskOptimizationStrategy disk_optimization_strategy = DiskOptimizationStrategy.ssd;
    public double disk_optimization_estimate_percentile = 0.95;
    public double disk_optimization_page_cross_chance = 0.1;
    public boolean inter_dc_tcp_nodelay = true;
    public MemtableAllocationType memtable_allocation_type = MemtableAllocationType.heap_buffers;
    public volatile int tombstone_warn_threshold = 1000;
    public volatile int tombstone_failure_threshold = 100000;
    public final ReplicaFilteringProtectionOptions replica_filtering_protection = new ReplicaFilteringProtectionOptions();
    public volatile Long index_summary_capacity_in_mb;
    public volatile int index_summary_resize_interval_in_minutes = 60;
    public int gc_log_threshold_in_ms = 200;
    public int gc_warn_threshold_in_ms = 1000;
    public int tracetype_query_ttl = (int)TimeUnit.DAYS.toSeconds(1L);
    public int tracetype_repair_ttl = (int)TimeUnit.DAYS.toSeconds(7L);
    public volatile ConsistencyLevel ideal_consistency_level = null;
    public String otc_coalescing_strategy = "DISABLED";
    public static final int otc_coalescing_window_us_default = 200;
    public int otc_coalescing_window_us = 200;
    public int otc_coalescing_enough_coalesced_messages = 8;
    public int windows_timer_interval = 0;
    public Long prepared_statements_cache_size_mb = null;
    public boolean enable_user_defined_functions = false;
    public boolean enable_scripted_user_defined_functions = false;
    public boolean enable_materialized_views = false;
    public boolean enable_transient_replication = false;
    public boolean enable_sasi_indexes = false;
    public volatile boolean enable_drop_compact_storage = false;
    public boolean enable_user_defined_functions_threads = true;
    public long user_defined_function_warn_timeout = 500L;
    public long user_defined_function_fail_timeout = 1500L;
    public UserFunctionTimeoutPolicy user_function_timeout_policy = UserFunctionTimeoutPolicy.die;
    @Deprecated
    public volatile boolean back_pressure_enabled = false;
    @Deprecated
    public volatile ParameterizedClass back_pressure_strategy;
    public volatile int concurrent_validations;
    public RepairCommandPoolFullStrategy repair_command_pool_full_strategy = RepairCommandPoolFullStrategy.queue;
    public int repair_command_pool_size = this.concurrent_validations;
    public int block_for_peers_timeout_in_secs = 10;
    public boolean block_for_peers_in_remote_dcs = false;
    public volatile boolean automatic_sstable_upgrade = false;
    public volatile int max_concurrent_automatic_sstable_upgrades = 1;
    public boolean stream_entire_sstables = true;
    public volatile AuditLogOptions audit_logging_options = new AuditLogOptions();
    public volatile FullQueryLoggerOptions full_query_logging_options = new FullQueryLoggerOptions();
    public CorruptedTombstoneStrategy corrupted_tombstone_strategy = CorruptedTombstoneStrategy.disabled;
    public volatile boolean diagnostic_events_enabled = false;
    public volatile boolean repaired_data_tracking_for_range_reads_enabled = false;
    public volatile boolean repaired_data_tracking_for_partition_reads_enabled = false;
    public volatile boolean report_unconfirmed_repaired_data_mismatches = false;
    public volatile boolean snapshot_on_repaired_data_mismatch = false;
    public volatile int validation_preview_purge_head_start_in_sec = 3600;
    public volatile int initial_range_tombstone_list_allocation_size = 1;
    public volatile double range_tombstone_list_growth_factor = 1.5;
    public volatile boolean snapshot_on_duplicate_row_detection = false;
    public volatile boolean check_for_duplicate_rows_during_reads = true;
    public volatile boolean check_for_duplicate_rows_during_compaction = true;
    public boolean autocompaction_on_startup_enabled = Boolean.parseBoolean(System.getProperty("cassandra.autocompaction_on_startup_enabled", "true"));
    public volatile boolean auto_optimise_inc_repair_streams = false;
    public volatile boolean auto_optimise_full_repair_streams = false;
    public volatile boolean auto_optimise_preview_repair_streams = false;
    public volatile int table_count_warn_threshold = 150;
    public volatile int keyspace_count_warn_threshold = 40;
    public volatile int consecutive_message_errors_threshold = 1;
    private static final List<String> SENSITIVE_KEYS = new ArrayList<String>(){
        {
            this.add("client_encryption_options");
            this.add("server_encryption_options");
        }
    };

    @Deprecated
    public static boolean isClientMode() {
        return isClientMode;
    }

    @Deprecated
    public static void setClientMode(boolean clientMode) {
        isClientMode = clientMode;
    }

    public static Supplier<Config> getOverrideLoadConfig() {
        return overrideLoadConfig;
    }

    public static void setOverrideLoadConfig(Supplier<Config> loadConfig) {
        overrideLoadConfig = loadConfig;
    }

    public static void log(Config config) {
        TreeMap<String, String> configMap = new TreeMap<String, String>();
        for (Field field : Config.class.getFields()) {
            String value;
            if (Modifier.isFinal(field.getModifiers())) continue;
            String name = field.getName();
            if (SENSITIVE_KEYS.contains(name)) {
                configMap.put(name, "<REDACTED>");
                continue;
            }
            try {
                value = field.get(config).toString();
            }
            catch (IllegalAccessException | NullPointerException npe) {
                value = "null";
            }
            configMap.put(name, value);
        }
        logger.info("Node configuration:[{}]", (Object)Joiner.on((String)"; ").join(configMap.entrySet()));
    }

    public static enum CorruptedTombstoneStrategy {
        disabled,
        warn,
        exception;

    }

    public static enum RepairCommandPoolFullStrategy {
        queue,
        reject;

    }

    public static enum DiskOptimizationStrategy {
        ssd,
        spinning;

    }

    public static enum UserFunctionTimeoutPolicy {
        ignore,
        die,
        die_immediate;

    }

    public static enum CommitFailurePolicy {
        stop,
        stop_commit,
        ignore,
        die;

    }

    public static enum DiskFailurePolicy {
        best_effort,
        stop,
        ignore,
        stop_paranoid,
        die;

    }

    public static enum MemtableAllocationType {
        unslabbed_heap_buffers,
        heap_buffers,
        offheap_buffers,
        offheap_objects;

    }

    public static enum DiskAccessMode {
        auto,
        mmap,
        mmap_index_only,
        standard;

    }

    public static enum InternodeCompression {
        all,
        none,
        dc;

    }

    public static enum FlushCompression {
        none,
        fast,
        table;

    }

    public static enum CommitLogSync {
        periodic,
        batch,
        group;

    }
}

