/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface OutputHandler {
    public void output(String var1);

    public void debug(String var1);

    public void warn(String var1);

    public void warn(String var1, Throwable var2);

    public static class SystemOutput
    implements OutputHandler {
        public final boolean debug;
        public final boolean printStack;
        public final PrintStream warnOut;

        public SystemOutput(boolean debug, boolean printStack) {
            this(debug, printStack, false);
        }

        public SystemOutput(boolean debug, boolean printStack, boolean logWarnToStdErr) {
            this.debug = debug;
            this.printStack = printStack;
            this.warnOut = logWarnToStdErr ? System.err : System.out;
        }

        @Override
        public void output(String msg) {
            System.out.println(msg);
        }

        @Override
        public void debug(String msg) {
            if (this.debug) {
                System.out.println(msg);
            }
        }

        @Override
        public void warn(String msg) {
            this.warn(msg, null);
        }

        @Override
        public void warn(String msg, Throwable th) {
            this.warnOut.println("WARNING: " + msg);
            if (this.printStack && th != null) {
                th.printStackTrace(this.warnOut);
            }
        }
    }

    public static class LogOutput
    implements OutputHandler {
        private static Logger logger = LoggerFactory.getLogger(LogOutput.class);

        @Override
        public void output(String msg) {
            logger.info(msg);
        }

        @Override
        public void debug(String msg) {
            logger.trace(msg);
        }

        @Override
        public void warn(String msg) {
            logger.warn(msg);
        }

        @Override
        public void warn(String msg, Throwable th) {
            logger.warn(msg, th);
        }
    }
}

