/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import org.apache.cassandra.exceptions.OverloadedException;
import org.apache.cassandra.metrics.ClientMetrics;
import org.apache.cassandra.net.ResourceLimits;
import org.apache.cassandra.transport.ClientResourceLimits;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.transport.Envelope;
import org.apache.cassandra.transport.ExceptionHandlers;
import org.apache.cassandra.transport.Flusher;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreV5Handlers {

    @ChannelHandler.Sharable
    public static final class ExceptionHandler
    extends ChannelInboundHandlerAdapter {
        public static final ExceptionHandler instance = new ExceptionHandler();

        private ExceptionHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ExceptionHandlers.UnexpectedChannelExceptionHandler handler = new ExceptionHandlers.UnexpectedChannelExceptionHandler(ctx.channel(), false);
            ErrorMessage errorMessage = ErrorMessage.fromException(cause, handler);
            if (ctx.channel().isOpen()) {
                ChannelFuture future = ctx.writeAndFlush((Object)errorMessage.encode(ProtocolVersion.CURRENT));
                if (cause instanceof ProtocolException) {
                    future.addListener((GenericFutureListener)((ChannelFutureListener)f -> ctx.close()));
                }
            }
            JVMStabilityInspector.inspectThrowable(cause);
        }
    }

    @ChannelHandler.Sharable
    public static class ProtocolEncoder
    extends MessageToMessageEncoder<Message> {
        public static final ProtocolEncoder instance = new ProtocolEncoder();

        private ProtocolEncoder() {
        }

        public void encode(ChannelHandlerContext ctx, Message source, List results) {
            Connection connection = (Connection)ctx.channel().attr(Connection.attributeKey).get();
            ProtocolVersion version = connection == null ? ProtocolVersion.CURRENT : connection.getVersion();
            results.add(source.encode(version));
        }
    }

    @ChannelHandler.Sharable
    public static class ProtocolDecoder
    extends MessageToMessageDecoder<Envelope> {
        public static final ProtocolDecoder instance = new ProtocolDecoder();

        private ProtocolDecoder() {
        }

        public void decode(ChannelHandlerContext ctx, Envelope source, List results) {
            try {
                results.add(Message.Decoder.decodeMessage(ctx.channel(), source));
            }
            catch (Throwable ex) {
                source.release();
                throw ErrorMessage.wrap(ex, source.header.streamId);
            }
        }
    }

    public static class LegacyDispatchHandler
    extends SimpleChannelInboundHandler<Message.Request> {
        private static final Logger logger = LoggerFactory.getLogger(LegacyDispatchHandler.class);
        private final Dispatcher dispatcher;
        private final ClientResourceLimits.Allocator endpointPayloadTracker;
        private long channelPayloadBytesInFlight;
        private boolean paused;

        LegacyDispatchHandler(Dispatcher dispatcher, ClientResourceLimits.Allocator endpointPayloadTracker) {
            this.dispatcher = dispatcher;
            this.endpointPayloadTracker = endpointPayloadTracker;
        }

        protected void channelRead0(ChannelHandlerContext ctx, Message.Request request) throws Exception {
            if (this.shouldHandleRequest(ctx, request)) {
                this.dispatcher.dispatch(ctx.channel(), request, this::toFlushItem);
            }
        }

        private Flusher.FlushItem.Unframed toFlushItem(Channel channel, Message.Request request, Message.Response response) {
            return new Flusher.FlushItem.Unframed(channel, response, request.getSource(), this::releaseItem);
        }

        private void releaseItem(Flusher.FlushItem<Message.Response> item) {
            long itemSize = item.request.header.bodySizeInBytes;
            item.request.release();
            this.channelPayloadBytesInFlight -= itemSize;
            ResourceLimits.Outcome endpointGlobalReleaseOutcome = this.endpointPayloadTracker.release(itemSize);
            ChannelConfig config = item.channel.config();
            if (this.paused && (this.channelPayloadBytesInFlight == 0L || endpointGlobalReleaseOutcome == ResourceLimits.Outcome.BELOW_LIMIT)) {
                this.paused = false;
                ClientMetrics.instance.unpauseConnection();
                config.setAutoRead(true);
            }
        }

        private boolean shouldHandleRequest(ChannelHandlerContext ctx, Message.Request request) {
            long requestSize = request.getSource().header.bodySizeInBytes;
            if (this.endpointPayloadTracker.tryAllocate(requestSize) != ResourceLimits.Outcome.SUCCESS) {
                if (request.connection.isThrowOnOverload()) {
                    ClientMetrics.instance.markRequestDiscarded();
                    logger.trace("Discarded request of size: {}. InflightChannelRequestPayload: {}, {}, Request: {}", new Object[]{requestSize, this.channelPayloadBytesInFlight, this.endpointPayloadTracker.toString(), request});
                    throw ErrorMessage.wrap(new OverloadedException("Server is in overloaded state. Cannot accept more requests at this point"), request.getSource().header.streamId);
                }
                this.endpointPayloadTracker.allocate(requestSize);
                ctx.channel().config().setAutoRead(false);
                ClientMetrics.instance.pauseConnection();
                this.paused = true;
            }
            this.channelPayloadBytesInFlight += requestSize;
            return true;
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            this.endpointPayloadTracker.release();
            if (this.paused) {
                this.paused = false;
                ClientMetrics.instance.unpauseConnection();
            }
            ctx.fireChannelInactive();
        }
    }
}

