/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.DataPosition;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.io.util.RebufferingInputStream;
import org.apache.cassandra.io.util.SimpleChunkReader;

public class RandomAccessReader
extends RebufferingInputStream
implements FileDataInput {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private long markedPointer;
    final Rebufferer rebufferer;
    private Rebufferer.BufferHolder bufferHolder = Rebufferer.EMPTY;

    RandomAccessReader(Rebufferer rebufferer) {
        super(Rebufferer.EMPTY.buffer());
        this.rebufferer = rebufferer;
    }

    @Override
    public void reBuffer() {
        if (this.isEOF()) {
            return;
        }
        this.reBufferAt(this.current());
    }

    private void reBufferAt(long position) {
        this.bufferHolder.release();
        this.bufferHolder = this.rebufferer.rebuffer(position);
        this.buffer = this.bufferHolder.buffer();
        this.buffer.position(Ints.checkedCast((long)(position - this.bufferHolder.offset())));
        assert (this.buffer.order() == ByteOrder.BIG_ENDIAN) : "Buffer must have BIG ENDIAN byte ordering";
    }

    @Override
    public long getFilePointer() {
        if (this.buffer == null) {
            return this.rebufferer.fileLength();
        }
        return this.current();
    }

    protected long current() {
        return this.bufferHolder.offset() + (long)this.buffer.position();
    }

    @Override
    public String getPath() {
        return this.getChannel().filePath();
    }

    public ChannelProxy getChannel() {
        return this.rebufferer.channel();
    }

    @Override
    public void reset() throws IOException {
        this.seek(this.markedPointer);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public long bytesPastMark() {
        long bytes = this.current() - this.markedPointer;
        assert (bytes >= 0L);
        return bytes;
    }

    @Override
    public DataPosition mark() {
        this.markedPointer = this.current();
        return new BufferedRandomAccessFileMark(this.markedPointer);
    }

    @Override
    public void reset(DataPosition mark) {
        assert (mark instanceof BufferedRandomAccessFileMark);
        this.seek(((BufferedRandomAccessFileMark)mark).pointer);
    }

    @Override
    public long bytesPastMark(DataPosition mark) {
        assert (mark instanceof BufferedRandomAccessFileMark);
        long bytes = this.current() - ((BufferedRandomAccessFileMark)mark).pointer;
        assert (bytes >= 0L);
        return bytes;
    }

    @Override
    public boolean isEOF() {
        return this.current() == this.length();
    }

    @Override
    public long bytesRemaining() {
        return this.length() - this.getFilePointer();
    }

    @Override
    public int available() throws IOException {
        return Ints.saturatedCast((long)this.bytesRemaining());
    }

    @Override
    public void close() {
        if (this.buffer == null) {
            return;
        }
        this.bufferHolder.release();
        this.rebufferer.closeReader();
        this.buffer = null;
        this.bufferHolder = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ':' + this.rebufferer;
    }

    @Override
    public void seek(long newPosition) {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("new position should not be negative");
        }
        if (this.buffer == null) {
            throw new IllegalStateException("Attempted to seek in a closed RAR");
        }
        long bufferOffset = this.bufferHolder.offset();
        if (newPosition >= bufferOffset && newPosition < bufferOffset + (long)this.buffer.limit()) {
            this.buffer.position((int)(newPosition - bufferOffset));
            return;
        }
        if (newPosition > this.length()) {
            throw new IllegalArgumentException(String.format("Unable to seek to position %d in %s (%d bytes) in read-only mode", newPosition, this.getPath(), this.length()));
        }
        this.reBufferAt(newPosition);
    }

    @Override
    public final String readLine() throws IOException {
        StringBuilder line = new StringBuilder(80);
        boolean foundTerminator = false;
        long unreadPosition = -1L;
        block5: while (true) {
            int nextByte = this.read();
            switch (nextByte) {
                case -1: {
                    return line.length() != 0 ? line.toString() : null;
                }
                case 13: {
                    if (foundTerminator) {
                        this.seek(unreadPosition);
                        return line.toString();
                    }
                    foundTerminator = true;
                    unreadPosition = this.getPosition();
                    continue block5;
                }
                case 10: {
                    return line.toString();
                }
            }
            if (foundTerminator) {
                this.seek(unreadPosition);
                return line.toString();
            }
            line.append((char)nextByte);
        }
    }

    public long length() {
        return this.rebufferer.fileLength();
    }

    public long getPosition() {
        return this.current();
    }

    public double getCrcCheckChance() {
        return this.rebufferer.getCrcCheckChance();
    }

    public static RandomAccessReader open(File file) {
        ChannelProxy channel = new ChannelProxy(file);
        try {
            SimpleChunkReader reader = new SimpleChunkReader(channel, -1L, BufferType.OFF_HEAP, 4096);
            Rebufferer rebufferer = reader.instantiateRebufferer();
            return new RandomAccessReaderWithOwnChannel(rebufferer);
        }
        catch (Throwable t) {
            channel.close();
            throw t;
        }
    }

    static class RandomAccessReaderWithOwnChannel
    extends RandomAccessReader {
        RandomAccessReaderWithOwnChannel(Rebufferer rebufferer) {
            super(rebufferer);
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            finally {
                try {
                    this.rebufferer.close();
                }
                finally {
                    this.getChannel().close();
                }
            }
        }
    }

    private static class BufferedRandomAccessFileMark
    implements DataPosition {
        final long pointer;

        private BufferedRandomAccessFileMark(long pointer) {
            this.pointer = pointer;
        }
    }
}

