/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.stats.StatsPrinter;
import org.apache.cassandra.tools.nodetool.stats.StatsTableComparator;
import org.apache.cassandra.tools.nodetool.stats.TableStatsHolder;
import org.apache.cassandra.tools.nodetool.stats.TableStatsPrinter;

@Command(name="tablestats", description="Print statistics on tables")
public class TableStats
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<keyspace.table>...]", description="List of tables (or keyspace) names")
    private List<String> tableNames = new ArrayList<String>();
    @Option(name={"-i"}, description="Ignore the list of tables and display the remaining tables")
    private boolean ignore = false;
    @Option(title="human_readable", name={"-H", "--human-readable"}, description="Display bytes in human readable form, i.e. KiB, MiB, GiB, TiB")
    private boolean humanReadable = false;
    @Option(title="format", name={"-F", "--format"}, description="Output format (json, yaml)")
    private String outputFormat = "";
    @Option(title="sort_key", name={"-s", "--sort"}, description="Sort tables by specified sort key (average_live_cells_per_slice_last_five_minutes, average_tombstones_per_slice_last_five_minutes, bloom_filter_false_positives, bloom_filter_false_ratio, bloom_filter_off_heap_memory_used, bloom_filter_space_used, compacted_partition_maximum_bytes, compacted_partition_mean_bytes, compacted_partition_minimum_bytes, compression_metadata_off_heap_memory_used, dropped_mutations, full_name, index_summary_off_heap_memory_used, local_read_count, local_read_latency_ms, local_write_latency_ms, maximum_live_cells_per_slice_last_five_minutes, maximum_tombstones_per_slice_last_five_minutes, memtable_cell_count, memtable_data_size, memtable_off_heap_memory_used, memtable_switch_count, number_of_partitions_estimate, off_heap_memory_used_total, pending_flushes, percent_repaired, read_latency, reads, space_used_by_snapshots_total, space_used_live, space_used_total, sstable_compression_ratio, sstable_count, table_name, write_latency, writes)")
    private String sortKey = "";
    @Option(title="top", name={"-t", "--top"}, description="Show only the top K tables for the sort key (specify the number K of tables to be shown")
    private int top = 0;

    @Override
    public void execute(NodeProbe probe) {
        if (!(this.outputFormat.isEmpty() || "json".equals(this.outputFormat) || "yaml".equals(this.outputFormat))) {
            throw new IllegalArgumentException("arguments for -F are json,yaml only.");
        }
        if (!this.sortKey.isEmpty() && !Arrays.asList(StatsTableComparator.supportedSortKeys).contains(this.sortKey)) {
            throw new IllegalArgumentException(String.format("argument for sort must be one of: %s", String.join((CharSequence)", ", StatsTableComparator.supportedSortKeys)));
        }
        if (this.top > 0 && this.sortKey.isEmpty()) {
            throw new IllegalArgumentException("cannot filter top K tables without specifying a sort key.");
        }
        if (this.top < 0) {
            throw new IllegalArgumentException("argument for top must be a positive integer.");
        }
        TableStatsHolder holder = new TableStatsHolder(probe, this.humanReadable, this.ignore, this.tableNames, this.sortKey, this.top);
        StatsPrinter printer = TableStatsPrinter.from(this.outputFormat, !this.sortKey.isEmpty());
        printer.print(holder, probe.output().out);
    }
}

