/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.TruncateResponse;
import org.apache.cassandra.exceptions.TruncateException;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.utils.concurrent.SimpleCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TruncateResponseHandler
implements RequestCallback<TruncateResponse> {
    protected static final Logger logger = LoggerFactory.getLogger(TruncateResponseHandler.class);
    protected final SimpleCondition condition = new SimpleCondition();
    private final int responseCount;
    protected final AtomicInteger responses = new AtomicInteger(0);
    private final long start;
    private volatile InetAddress truncateFailingReplica;

    public TruncateResponseHandler(int responseCount) {
        assert (1 <= responseCount) : "invalid response count " + responseCount;
        this.responseCount = responseCount;
        this.start = System.nanoTime();
    }

    public void get() throws TimeoutException {
        boolean completedInTime;
        long timeoutNanos = DatabaseDescriptor.getTruncateRpcTimeout(TimeUnit.NANOSECONDS) - (System.nanoTime() - this.start);
        try {
            completedInTime = this.condition.await(timeoutNanos, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
        if (!completedInTime) {
            throw new TimeoutException("Truncate timed out - received only " + this.responses.get() + " responses");
        }
        if (this.truncateFailingReplica != null) {
            throw new TruncateException("Truncate failed on replica " + this.truncateFailingReplica);
        }
    }

    @Override
    public void onResponse(Message<TruncateResponse> message) {
        if (!((TruncateResponse)message.payload).success) {
            this.truncateFailingReplica = message.from().address;
            this.condition.signalAll();
            return;
        }
        this.responses.incrementAndGet();
        if (this.responses.get() >= this.responseCount) {
            this.condition.signalAll();
        }
    }
}

