/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.utils.memory.BufferPool;
import org.apache.cassandra.utils.memory.BufferPools;

abstract class FrameEncoder
extends ChannelOutboundHandlerAdapter {
    protected static final BufferPool bufferPool = BufferPools.forNetworking();

    FrameEncoder() {
    }

    PayloadAllocator allocator() {
        return PayloadAllocator.simple;
    }

    abstract ByteBuf encode(boolean var1, ByteBuffer var2);

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof Payload)) {
            throw new IllegalStateException("Unexpected type: " + msg);
        }
        Payload payload = (Payload)msg;
        ByteBuf write = this.encode(payload.isSelfContained, payload.buffer);
        ctx.write((Object)write, promise);
    }

    static interface PayloadAllocator {
        public static final PayloadAllocator simple = Payload::new;

        public Payload allocate(boolean var1, int var2);
    }

    static class Payload {
        private boolean isSelfContained;
        final ByteBuffer buffer;
        final int headerLength;
        final int trailerLength;
        private boolean isFinished = false;

        Payload(boolean isSelfContained, int payloadCapacity) {
            this(isSelfContained, payloadCapacity, 0, 0);
        }

        Payload(boolean isSelfContained, int payloadCapacity, int headerLength, int trailerLength) {
            this.isSelfContained = isSelfContained;
            this.headerLength = headerLength;
            this.trailerLength = trailerLength;
            this.buffer = bufferPool.getAtLeast(payloadCapacity + headerLength + trailerLength, BufferType.OFF_HEAP);
            assert (this.buffer.capacity() >= payloadCapacity + headerLength + trailerLength);
            this.buffer.position(headerLength);
            this.buffer.limit(this.buffer.capacity() - trailerLength);
        }

        void setSelfContained(boolean isSelfContained) {
            this.isSelfContained = isSelfContained;
        }

        boolean isEmpty() {
            assert (!this.isFinished);
            return this.buffer.position() == this.headerLength;
        }

        int length() {
            assert (!this.isFinished);
            return this.buffer.position() - this.headerLength;
        }

        int remaining() {
            assert (!this.isFinished);
            return this.buffer.remaining();
        }

        void trim(int length) {
            assert (!this.isFinished);
            this.buffer.position(this.headerLength + length);
        }

        void finish() {
            assert (!this.isFinished);
            this.isFinished = true;
            this.buffer.limit(this.buffer.position() + this.trailerLength);
            this.buffer.position(0);
            bufferPool.putUnusedPortion(this.buffer);
        }

        void release() {
            bufferPool.put(this.buffer);
        }
    }
}

