/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.metadata;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.commitlog.IntervalSet;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.IMetadataComponentSerializer;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.UUIDSerializer;
import org.apache.cassandra.utils.streamhist.TombstoneHistogram;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsMetadata
extends MetadataComponent {
    public static final IMetadataComponentSerializer serializer = new StatsMetadataSerializer();
    public static final ISerializer<IntervalSet<CommitLogPosition>> commitLogPositionSetSerializer = IntervalSet.serializer(CommitLogPosition.serializer);
    public final EstimatedHistogram estimatedPartitionSize;
    public final EstimatedHistogram estimatedCellPerPartitionCount;
    public final IntervalSet<CommitLogPosition> commitLogIntervals;
    public final long minTimestamp;
    public final long maxTimestamp;
    public final int minLocalDeletionTime;
    public final int maxLocalDeletionTime;
    public final int minTTL;
    public final int maxTTL;
    public final double compressionRatio;
    public final TombstoneHistogram estimatedTombstoneDropTime;
    public final int sstableLevel;
    public final List<ByteBuffer> minClusteringValues;
    public final List<ByteBuffer> maxClusteringValues;
    public final boolean hasLegacyCounterShards;
    public final long repairedAt;
    public final long totalColumnsSet;
    public final long totalRows;
    public final UUID pendingRepair;
    public final boolean isTransient;
    public final EncodingStats encodingStats;

    public StatsMetadata(EstimatedHistogram estimatedPartitionSize, EstimatedHistogram estimatedCellPerPartitionCount, IntervalSet<CommitLogPosition> commitLogIntervals, long minTimestamp, long maxTimestamp, int minLocalDeletionTime, int maxLocalDeletionTime, int minTTL, int maxTTL, double compressionRatio, TombstoneHistogram estimatedTombstoneDropTime, int sstableLevel, List<ByteBuffer> minClusteringValues, List<ByteBuffer> maxClusteringValues, boolean hasLegacyCounterShards, long repairedAt, long totalColumnsSet, long totalRows, UUID pendingRepair, boolean isTransient) {
        this.estimatedPartitionSize = estimatedPartitionSize;
        this.estimatedCellPerPartitionCount = estimatedCellPerPartitionCount;
        this.commitLogIntervals = commitLogIntervals;
        this.minTimestamp = minTimestamp;
        this.maxTimestamp = maxTimestamp;
        this.minLocalDeletionTime = minLocalDeletionTime;
        this.maxLocalDeletionTime = maxLocalDeletionTime;
        this.minTTL = minTTL;
        this.maxTTL = maxTTL;
        this.compressionRatio = compressionRatio;
        this.estimatedTombstoneDropTime = estimatedTombstoneDropTime;
        this.sstableLevel = sstableLevel;
        this.minClusteringValues = minClusteringValues;
        this.maxClusteringValues = maxClusteringValues;
        this.hasLegacyCounterShards = hasLegacyCounterShards;
        this.repairedAt = repairedAt;
        this.totalColumnsSet = totalColumnsSet;
        this.totalRows = totalRows;
        this.pendingRepair = pendingRepair;
        this.isTransient = isTransient;
        this.encodingStats = new EncodingStats(minTimestamp, minLocalDeletionTime, minTTL);
    }

    @Override
    public MetadataType getType() {
        return MetadataType.STATS;
    }

    public double getEstimatedDroppableTombstoneRatio(int gcBefore) {
        long estimatedColumnCount = this.estimatedCellPerPartitionCount.mean() * this.estimatedCellPerPartitionCount.count();
        if (estimatedColumnCount > 0L) {
            double droppable = this.getDroppableTombstonesBefore(gcBefore);
            return droppable / (double)estimatedColumnCount;
        }
        return 0.0;
    }

    public double getDroppableTombstonesBefore(int gcBefore) {
        return this.estimatedTombstoneDropTime.sum(gcBefore);
    }

    public StatsMetadata mutateLevel(int newLevel) {
        return new StatsMetadata(this.estimatedPartitionSize, this.estimatedCellPerPartitionCount, this.commitLogIntervals, this.minTimestamp, this.maxTimestamp, this.minLocalDeletionTime, this.maxLocalDeletionTime, this.minTTL, this.maxTTL, this.compressionRatio, this.estimatedTombstoneDropTime, newLevel, this.minClusteringValues, this.maxClusteringValues, this.hasLegacyCounterShards, this.repairedAt, this.totalColumnsSet, this.totalRows, this.pendingRepair, this.isTransient);
    }

    public StatsMetadata mutateRepairedMetadata(long newRepairedAt, UUID newPendingRepair, boolean newIsTransient) {
        return new StatsMetadata(this.estimatedPartitionSize, this.estimatedCellPerPartitionCount, this.commitLogIntervals, this.minTimestamp, this.maxTimestamp, this.minLocalDeletionTime, this.maxLocalDeletionTime, this.minTTL, this.maxTTL, this.compressionRatio, this.estimatedTombstoneDropTime, this.sstableLevel, this.minClusteringValues, this.maxClusteringValues, this.hasLegacyCounterShards, newRepairedAt, this.totalColumnsSet, this.totalRows, newPendingRepair, newIsTransient);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatsMetadata that = (StatsMetadata)o;
        return new EqualsBuilder().append((Object)this.estimatedPartitionSize, (Object)that.estimatedPartitionSize).append((Object)this.estimatedCellPerPartitionCount, (Object)that.estimatedCellPerPartitionCount).append(this.commitLogIntervals, that.commitLogIntervals).append(this.minTimestamp, that.minTimestamp).append(this.maxTimestamp, that.maxTimestamp).append(this.minLocalDeletionTime, that.minLocalDeletionTime).append(this.maxLocalDeletionTime, that.maxLocalDeletionTime).append(this.minTTL, that.minTTL).append(this.maxTTL, that.maxTTL).append(this.compressionRatio, that.compressionRatio).append((Object)this.estimatedTombstoneDropTime, (Object)that.estimatedTombstoneDropTime).append(this.sstableLevel, that.sstableLevel).append(this.repairedAt, that.repairedAt).append(this.maxClusteringValues, that.maxClusteringValues).append(this.minClusteringValues, that.minClusteringValues).append(this.hasLegacyCounterShards, that.hasLegacyCounterShards).append(this.totalColumnsSet, that.totalColumnsSet).append(this.totalRows, that.totalRows).append((Object)this.pendingRepair, (Object)that.pendingRepair).build();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.estimatedPartitionSize).append((Object)this.estimatedCellPerPartitionCount).append(this.commitLogIntervals).append(this.minTimestamp).append(this.maxTimestamp).append(this.minLocalDeletionTime).append(this.maxLocalDeletionTime).append(this.minTTL).append(this.maxTTL).append(this.compressionRatio).append((Object)this.estimatedTombstoneDropTime).append(this.sstableLevel).append(this.repairedAt).append(this.maxClusteringValues).append(this.minClusteringValues).append(this.hasLegacyCounterShards).append(this.totalColumnsSet).append(this.totalRows).append((Object)this.pendingRepair).build();
    }

    public static class StatsMetadataSerializer
    implements IMetadataComponentSerializer<StatsMetadata> {
        private static final Logger logger = LoggerFactory.getLogger(StatsMetadataSerializer.class);

        @Override
        public int serializedSize(Version version, StatsMetadata component) throws IOException {
            int size = 0;
            size = (int)((long)size + EstimatedHistogram.serializer.serializedSize(component.estimatedPartitionSize));
            size = (int)((long)size + EstimatedHistogram.serializer.serializedSize(component.estimatedCellPerPartitionCount));
            size = (int)((long)size + CommitLogPosition.serializer.serializedSize(component.commitLogIntervals.upperBound().orElse(CommitLogPosition.NONE)));
            size += 48;
            size = (int)((long)size + TombstoneHistogram.serializer.serializedSize(component.estimatedTombstoneDropTime));
            size += TypeSizes.sizeof(component.sstableLevel);
            size += 4;
            for (ByteBuffer value : component.minClusteringValues) {
                size += 2 + value.remaining();
            }
            size += 4;
            for (ByteBuffer value : component.maxClusteringValues) {
                size += 2 + value.remaining();
            }
            size += TypeSizes.sizeof(component.hasLegacyCounterShards);
            size += 16;
            if (version.hasCommitLogLowerBound()) {
                size = (int)((long)size + CommitLogPosition.serializer.serializedSize(component.commitLogIntervals.lowerBound().orElse(CommitLogPosition.NONE)));
            }
            if (version.hasCommitLogIntervals()) {
                size = (int)((long)size + commitLogPositionSetSerializer.serializedSize(component.commitLogIntervals));
            }
            if (version.hasPendingRepair()) {
                ++size;
                if (component.pendingRepair != null) {
                    size = (int)((long)size + UUIDSerializer.serializer.serializedSize(component.pendingRepair, 0));
                }
            }
            if (version.hasIsTransient()) {
                size += TypeSizes.sizeof(component.isTransient);
            }
            return size;
        }

        @Override
        public void serialize(Version version, StatsMetadata component, DataOutputPlus out) throws IOException {
            EstimatedHistogram.serializer.serialize(component.estimatedPartitionSize, out);
            EstimatedHistogram.serializer.serialize(component.estimatedCellPerPartitionCount, out);
            CommitLogPosition.serializer.serialize(component.commitLogIntervals.upperBound().orElse(CommitLogPosition.NONE), out);
            out.writeLong(component.minTimestamp);
            out.writeLong(component.maxTimestamp);
            out.writeInt(component.minLocalDeletionTime);
            out.writeInt(component.maxLocalDeletionTime);
            out.writeInt(component.minTTL);
            out.writeInt(component.maxTTL);
            out.writeDouble(component.compressionRatio);
            TombstoneHistogram.serializer.serialize(component.estimatedTombstoneDropTime, out);
            out.writeInt(component.sstableLevel);
            out.writeLong(component.repairedAt);
            out.writeInt(component.minClusteringValues.size());
            for (ByteBuffer value : component.minClusteringValues) {
                ByteBufferUtil.writeWithShortLength(value, out);
            }
            out.writeInt(component.maxClusteringValues.size());
            for (ByteBuffer value : component.maxClusteringValues) {
                ByteBufferUtil.writeWithShortLength(value, out);
            }
            out.writeBoolean(component.hasLegacyCounterShards);
            out.writeLong(component.totalColumnsSet);
            out.writeLong(component.totalRows);
            if (version.hasCommitLogLowerBound()) {
                CommitLogPosition.serializer.serialize(component.commitLogIntervals.lowerBound().orElse(CommitLogPosition.NONE), out);
            }
            if (version.hasCommitLogIntervals()) {
                commitLogPositionSetSerializer.serialize(component.commitLogIntervals, out);
            }
            if (version.hasPendingRepair()) {
                if (component.pendingRepair != null) {
                    out.writeByte(1);
                    UUIDSerializer.serializer.serialize(component.pendingRepair, out, 0);
                } else {
                    out.writeByte(0);
                }
            }
            if (version.hasIsTransient()) {
                out.writeBoolean(component.isTransient);
            }
        }

        @Override
        public StatsMetadata deserialize(Version version, DataInputPlus in) throws IOException {
            EstimatedHistogram columnCounts;
            EstimatedHistogram partitionSizes = EstimatedHistogram.serializer.deserialize(in);
            if (partitionSizes.isOverflowed()) {
                logger.warn("Deserialized partition size histogram with {} values greater than the maximum of {}. Clearing the overflow bucket to allow for degraded mean and percentile calculations...", (Object)partitionSizes.overflowCount(), (Object)partitionSizes.getLargestBucketOffset());
                partitionSizes.clearOverflow();
            }
            if ((columnCounts = EstimatedHistogram.serializer.deserialize(in)).isOverflowed()) {
                logger.warn("Deserialized partition cell count histogram with {} values greater than the maximum of {}. Clearing the overflow bucket to allow for degraded mean and percentile calculations...", (Object)columnCounts.overflowCount(), (Object)columnCounts.getLargestBucketOffset());
                columnCounts.clearOverflow();
            }
            CommitLogPosition commitLogLowerBound = CommitLogPosition.NONE;
            CommitLogPosition commitLogUpperBound = CommitLogPosition.serializer.deserialize(in);
            long minTimestamp = in.readLong();
            long maxTimestamp = in.readLong();
            int minLocalDeletionTime = in.readInt();
            int maxLocalDeletionTime = in.readInt();
            int minTTL = in.readInt();
            int maxTTL = in.readInt();
            double compressionRatio = in.readDouble();
            TombstoneHistogram tombstoneHistogram = TombstoneHistogram.serializer.deserialize(in);
            int sstableLevel = in.readInt();
            long repairedAt = in.readLong();
            int colCount = in.readInt();
            ArrayList<ByteBuffer> minClusteringValues = new ArrayList<ByteBuffer>(colCount);
            for (int i = 0; i < colCount; ++i) {
                ByteBuffer val = ByteBufferUtil.readWithShortLength(in);
                if (!version.hasAccurateMinMax()) continue;
                minClusteringValues.add(val);
            }
            colCount = in.readInt();
            ArrayList<ByteBuffer> maxClusteringValues = new ArrayList<ByteBuffer>(colCount);
            for (int i = 0; i < colCount; ++i) {
                ByteBuffer val = ByteBufferUtil.readWithShortLength(in);
                if (!version.hasAccurateMinMax()) continue;
                maxClusteringValues.add(val);
            }
            boolean hasLegacyCounterShards = in.readBoolean();
            long totalColumnsSet = in.readLong();
            long totalRows = in.readLong();
            if (version.hasCommitLogLowerBound()) {
                commitLogLowerBound = CommitLogPosition.serializer.deserialize(in);
            }
            IntervalSet<CommitLogPosition> commitLogIntervals = version.hasCommitLogIntervals() ? commitLogPositionSetSerializer.deserialize(in) : new IntervalSet<CommitLogPosition>(commitLogLowerBound, commitLogUpperBound);
            UUID pendingRepair = null;
            if (version.hasPendingRepair() && in.readByte() != 0) {
                pendingRepair = UUIDSerializer.serializer.deserialize(in, 0);
            }
            boolean isTransient = version.hasIsTransient() && in.readBoolean();
            return new StatsMetadata(partitionSizes, columnCounts, commitLogIntervals, minTimestamp, maxTimestamp, minLocalDeletionTime, maxLocalDeletionTime, minTTL, maxTTL, compressionRatio, tombstoneHistogram, sstableLevel, minClusteringValues, maxClusteringValues, hasLegacyCounterShards, repairedAt, totalColumnsSet, totalRows, pendingRepair, isTransient);
        }
    }
}

