/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.WriteContext;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.IndexRegistry;
import org.apache.cassandra.index.SecondaryIndexBuilder;
import org.apache.cassandra.index.internal.CollatedViewIndexBuilder;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.io.sstable.format.SSTableFlushObserver;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.IndexMetadata;

public interface Index {
    public static final CollatedViewIndexBuildingSupport INDEX_BUILDER_SUPPORT = new CollatedViewIndexBuildingSupport();

    default public IndexBuildingSupport getBuildTaskSupport() {
        return INDEX_BUILDER_SUPPORT;
    }

    default public IndexBuildingSupport getRecoveryTaskSupport() {
        return this.getBuildTaskSupport();
    }

    default public LoadType getSupportedLoadTypeOnFailure(boolean isInitialBuild) {
        return isInitialBuild ? LoadType.WRITE : LoadType.ALL;
    }

    public Callable<?> getInitializationTask();

    public IndexMetadata getIndexMetadata();

    public Callable<?> getMetadataReloadTask(IndexMetadata var1);

    public void register(IndexRegistry var1);

    public Optional<ColumnFamilyStore> getBackingTable();

    public Callable<?> getBlockingFlushTask();

    public Callable<?> getInvalidateTask();

    public Callable<?> getTruncateTask(long var1);

    default public Callable<?> getPreJoinTask(boolean hadBootstrap) {
        return null;
    }

    public boolean shouldBuildBlocking();

    default public SSTableFlushObserver getFlushObserver(Descriptor descriptor, OperationType opType) {
        return null;
    }

    public boolean dependsOn(ColumnMetadata var1);

    public boolean supportsExpression(ColumnMetadata var1, Operator var2);

    public AbstractType<?> customExpressionValueType();

    public RowFilter getPostIndexQueryFilter(RowFilter var1);

    public long getEstimatedResultRows();

    public void validate(PartitionUpdate var1) throws InvalidRequestException;

    public Indexer indexerFor(DecoratedKey var1, RegularAndStaticColumns var2, int var3, WriteContext var4, IndexTransaction.Type var5);

    default public void validate(ReadCommand command) throws InvalidRequestException {
    }

    public BiFunction<PartitionIterator, ReadCommand, PartitionIterator> postProcessorFor(ReadCommand var1);

    public Searcher searcherFor(ReadCommand var1);

    public static interface Searcher {
        public UnfilteredPartitionIterator search(ReadExecutionController var1);
    }

    public static interface Indexer {
        public void begin();

        public void partitionDelete(DeletionTime var1);

        public void rangeTombstone(RangeTombstone var1);

        public void insertRow(Row var1);

        public void updateRow(Row var1, Row var2);

        public void removeRow(Row var1);

        public void finish();
    }

    public static class CollatedViewIndexBuildingSupport
    implements IndexBuildingSupport {
        @Override
        public SecondaryIndexBuilder getIndexBuildTask(ColumnFamilyStore cfs, Set<Index> indexes, Collection<SSTableReader> sstables) {
            return new CollatedViewIndexBuilder(cfs, indexes, new ReducingKeyIterator(sstables), sstables);
        }
    }

    public static interface IndexBuildingSupport {
        public SecondaryIndexBuilder getIndexBuildTask(ColumnFamilyStore var1, Set<Index> var2, Collection<SSTableReader> var3);
    }

    public static enum LoadType {
        READ,
        WRITE,
        ALL,
        NOOP;


        public boolean supportsWrites() {
            return this == ALL || this == WRITE;
        }

        public boolean supportsReads() {
            return this == ALL || this == READ;
        }
    }
}

