/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

public class ByteArrayUtil {
    private ByteArrayUtil() {
    }

    public static boolean getBoolean(byte[] b) {
        return ByteArrayUtil.getBoolean(b, 0);
    }

    public static boolean getBoolean(byte[] b, int off) {
        return b[off] != 0;
    }

    public static short getShort(byte[] b) {
        return ByteArrayUtil.getShort(b, 0);
    }

    public static short getShort(byte[] b, int off) {
        return (short)(b[off] << 8 | b[off + 1] & 0xFF);
    }

    public static int getInt(byte[] b) {
        return ByteArrayUtil.getInt(b, 0);
    }

    public static int getInt(byte[] b, int off) {
        return (b[off] & 0xFF) << 24 | (b[off + 1] & 0xFF) << 16 | (b[off + 2] & 0xFF) << 8 | b[off + 3] & 0xFF;
    }

    public static float getFloat(byte[] b) {
        return ByteArrayUtil.getFloat(b, 0);
    }

    public static float getFloat(byte[] b, int off) {
        return Float.intBitsToFloat(ByteArrayUtil.getInt(b, off));
    }

    public static long getLong(byte[] b) {
        return ByteArrayUtil.getLong(b, 0);
    }

    public static long getLong(byte[] b, int off) {
        return ((long)b[off] & 0xFFL) << 56 | ((long)b[off + 1] & 0xFFL) << 48 | ((long)b[off + 2] & 0xFFL) << 40 | ((long)b[off + 3] & 0xFFL) << 32 | ((long)b[off + 4] & 0xFFL) << 24 | ((long)b[off + 5] & 0xFFL) << 16 | ((long)b[off + 6] & 0xFFL) << 8 | (long)b[off + 7] & 0xFFL;
    }

    public static double getDouble(byte[] b) {
        return ByteArrayUtil.getDouble(b, 0);
    }

    public static double getDouble(byte[] b, int off) {
        return Double.longBitsToDouble(ByteArrayUtil.getLong(b, off));
    }

    public static void putBoolean(byte[] b, int off, boolean val) {
        ByteArrayUtil.ensureCapacity(b, off, 1);
        b[off] = (byte)(val ? 1 : 0);
    }

    public static void putShort(byte[] b, int off, short val) {
        ByteArrayUtil.ensureCapacity(b, off, 2);
        b[off + 1] = (byte)val;
        b[off] = (byte)(val >>> 8);
    }

    public static void putInt(byte[] b, int off, int val) {
        ByteArrayUtil.ensureCapacity(b, off, 4);
        b[off + 3] = (byte)val;
        b[off + 2] = (byte)(val >>> 8);
        b[off + 1] = (byte)(val >>> 16);
        b[off] = (byte)(val >>> 24);
    }

    public static void putFloat(byte[] b, int off, float val) {
        ByteArrayUtil.putInt(b, off, Float.floatToIntBits(val));
    }

    public static void putLong(byte[] b, int off, long val) {
        ByteArrayUtil.ensureCapacity(b, off, 8);
        b[off + 7] = (byte)val;
        b[off + 6] = (byte)(val >>> 8);
        b[off + 5] = (byte)(val >>> 16);
        b[off + 4] = (byte)(val >>> 24);
        b[off + 3] = (byte)(val >>> 32);
        b[off + 2] = (byte)(val >>> 40);
        b[off + 1] = (byte)(val >>> 48);
        b[off] = (byte)(val >>> 56);
    }

    public static void putDouble(byte[] b, int off, double val) {
        ByteArrayUtil.putLong(b, off, Double.doubleToLongBits(val));
    }

    private static void ensureCapacity(byte[] b, int off, int len) {
        int writable = b.length - off;
        if (writable < len) {
            if (writable < 0) {
                throw new IndexOutOfBoundsException("Attempted to write to offset " + off + " but array length is " + b.length);
            }
            throw new IndexOutOfBoundsException("Attempted to write " + len + " bytes to array with remaining capacity of " + writable);
        }
    }
}

