/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.base.Preconditions;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="setconcurrency", description="Set maximum concurrency for processing stage")
public class SetConcurrency
extends NodeTool.NodeToolCmd {
    @Arguments(title="<pool-name> <maximum-concurrency> | <stage-name> <core-pool> <maximum-concurrency>", usage="<stage-name> <maximum-concurrency> | <stage-name> <core-pool> <maximum-concurrency>", description="Set concurrency for processing stage", required=true)
    private List<String> args = new ArrayList<String>();

    @Override
    public void execute(NodeProbe probe) {
        Preconditions.checkArgument((this.args.size() >= 2 && this.args.size() <= 3 ? 1 : 0) != 0, (Object)"setconcurrency requires stage name, optional core pool size and maximum concurrency");
        int corePoolSize = this.args.size() == 2 ? -1 : Integer.valueOf(this.args.get(1));
        int maximumPoolSize = this.args.size() == 2 ? Integer.valueOf(this.args.get(1)) : Integer.valueOf(this.args.get(2));
        Preconditions.checkArgument((this.args.size() == 2 || corePoolSize >= 0 ? 1 : 0) != 0, (Object)"Core pool size must be non-negative");
        Preconditions.checkArgument((maximumPoolSize >= 0 ? 1 : 0) != 0, (Object)"Maximum pool size must be non-negative");
        try {
            probe.setConcurrency(this.args.get(0), corePoolSize, maximumPoolSize);
        }
        catch (IllegalArgumentException e) {
            String message = e.getMessage() != null ? e.getMessage() : "invalid pool size";
            System.out.println("Unable to set concurrency: " + message);
            System.exit(1);
        }
    }
}

