/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.CqlBuilder;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.schema.CachingParams;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.service.reads.PercentileSpeculativeRetryPolicy;
import org.apache.cassandra.service.reads.SpeculativeRetryPolicy;
import org.apache.cassandra.service.reads.repair.ReadRepairStrategy;
import org.apache.cassandra.utils.BloomCalculations;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class TableParams {
    public static final TableParams DEFAULT = TableParams.builder().build();
    public final String comment;
    public final double bloomFilterFpChance;
    public final double crcCheckChance;
    public final int gcGraceSeconds;
    public final int defaultTimeToLive;
    public final int memtableFlushPeriodInMs;
    public final int minIndexInterval;
    public final int maxIndexInterval;
    public final SpeculativeRetryPolicy speculativeRetry;
    public final SpeculativeRetryPolicy additionalWritePolicy;
    public final CachingParams caching;
    public final CompactionParams compaction;
    public final CompressionParams compression;
    public final ImmutableMap<String, ByteBuffer> extensions;
    public final boolean cdc;
    public final ReadRepairStrategy readRepair;

    private TableParams(Builder builder) {
        this.comment = builder.comment;
        this.bloomFilterFpChance = builder.bloomFilterFpChance == null ? builder.compaction.defaultBloomFilterFbChance() : builder.bloomFilterFpChance.doubleValue();
        this.crcCheckChance = builder.crcCheckChance;
        this.gcGraceSeconds = builder.gcGraceSeconds;
        this.defaultTimeToLive = builder.defaultTimeToLive;
        this.memtableFlushPeriodInMs = builder.memtableFlushPeriodInMs;
        this.minIndexInterval = builder.minIndexInterval;
        this.maxIndexInterval = builder.maxIndexInterval;
        this.speculativeRetry = builder.speculativeRetry;
        this.additionalWritePolicy = builder.additionalWritePolicy;
        this.caching = builder.caching;
        this.compaction = builder.compaction;
        this.compression = builder.compression;
        this.extensions = builder.extensions;
        this.cdc = builder.cdc;
        this.readRepair = builder.readRepair;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TableParams params) {
        return new Builder().bloomFilterFpChance(params.bloomFilterFpChance).caching(params.caching).comment(params.comment).compaction(params.compaction).compression(params.compression).crcCheckChance(params.crcCheckChance).defaultTimeToLive(params.defaultTimeToLive).gcGraceSeconds(params.gcGraceSeconds).maxIndexInterval(params.maxIndexInterval).memtableFlushPeriodInMs(params.memtableFlushPeriodInMs).minIndexInterval(params.minIndexInterval).speculativeRetry(params.speculativeRetry).additionalWritePolicy(params.additionalWritePolicy).extensions((Map<String, ByteBuffer>)params.extensions).cdc(params.cdc).readRepair(params.readRepair);
    }

    public Builder unbuild() {
        return TableParams.builder(this);
    }

    public void validate() {
        this.compaction.validate();
        this.compression.validate();
        double minBloomFilterFpChanceValue = BloomCalculations.minSupportedBloomFilterFpChance();
        if (this.bloomFilterFpChance <= minBloomFilterFpChanceValue || this.bloomFilterFpChance > 1.0) {
            TableParams.fail("%s must be larger than %s and less than or equal to 1.0 (got %s)", new Object[]{Option.BLOOM_FILTER_FP_CHANCE, minBloomFilterFpChanceValue, this.bloomFilterFpChance});
        }
        if (this.crcCheckChance < 0.0 || this.crcCheckChance > 1.0) {
            TableParams.fail("%s must be larger than or equal to 0 and smaller than or equal to 1.0 (got %s)", new Object[]{Option.CRC_CHECK_CHANCE, this.crcCheckChance});
        }
        if (this.defaultTimeToLive < 0) {
            TableParams.fail("%s must be greater than or equal to 0 (got %s)", new Object[]{Option.DEFAULT_TIME_TO_LIVE, this.defaultTimeToLive});
        }
        if (this.defaultTimeToLive > 630720000) {
            TableParams.fail("%s must be less than or equal to %d (got %s)", new Object[]{Option.DEFAULT_TIME_TO_LIVE, 630720000, this.defaultTimeToLive});
        }
        if (this.gcGraceSeconds < 0) {
            TableParams.fail("%s must be greater than or equal to 0 (got %s)", new Object[]{Option.GC_GRACE_SECONDS, this.gcGraceSeconds});
        }
        if (this.minIndexInterval < 1) {
            TableParams.fail("%s must be greater than or equal to 1 (got %s)", new Object[]{Option.MIN_INDEX_INTERVAL, this.minIndexInterval});
        }
        if (this.maxIndexInterval < this.minIndexInterval) {
            TableParams.fail("%s must be greater than or equal to %s (%s) (got %s)", new Object[]{Option.MAX_INDEX_INTERVAL, Option.MIN_INDEX_INTERVAL, this.minIndexInterval, this.maxIndexInterval});
        }
        if (this.memtableFlushPeriodInMs < 0) {
            TableParams.fail("%s must be greater than or equal to 0 (got %s)", new Object[]{Option.MEMTABLE_FLUSH_PERIOD_IN_MS, this.memtableFlushPeriodInMs});
        }
    }

    private static void fail(String format, Object ... args) {
        throw new ConfigurationException(String.format(format, args));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableParams)) {
            return false;
        }
        TableParams p = (TableParams)o;
        return this.comment.equals(p.comment) && this.bloomFilterFpChance == p.bloomFilterFpChance && this.crcCheckChance == p.crcCheckChance && this.gcGraceSeconds == p.gcGraceSeconds && this.defaultTimeToLive == p.defaultTimeToLive && this.memtableFlushPeriodInMs == p.memtableFlushPeriodInMs && this.minIndexInterval == p.minIndexInterval && this.maxIndexInterval == p.maxIndexInterval && this.speculativeRetry.equals(p.speculativeRetry) && this.caching.equals(p.caching) && this.compaction.equals(p.compaction) && this.compression.equals(p.compression) && this.extensions.equals(p.extensions) && this.cdc == p.cdc && this.readRepair == p.readRepair;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.comment, this.bloomFilterFpChance, this.crcCheckChance, this.gcGraceSeconds, this.defaultTimeToLive, this.memtableFlushPeriodInMs, this.minIndexInterval, this.maxIndexInterval, this.speculativeRetry, this.caching, this.compaction, this.compression, this.extensions, this.cdc, this.readRepair});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(Option.COMMENT.toString(), (Object)this.comment).add(Option.BLOOM_FILTER_FP_CHANCE.toString(), this.bloomFilterFpChance).add(Option.CRC_CHECK_CHANCE.toString(), this.crcCheckChance).add(Option.GC_GRACE_SECONDS.toString(), this.gcGraceSeconds).add(Option.DEFAULT_TIME_TO_LIVE.toString(), this.defaultTimeToLive).add(Option.MEMTABLE_FLUSH_PERIOD_IN_MS.toString(), this.memtableFlushPeriodInMs).add(Option.MIN_INDEX_INTERVAL.toString(), this.minIndexInterval).add(Option.MAX_INDEX_INTERVAL.toString(), this.maxIndexInterval).add(Option.SPECULATIVE_RETRY.toString(), (Object)this.speculativeRetry).add(Option.CACHING.toString(), (Object)this.caching).add(Option.COMPACTION.toString(), (Object)this.compaction).add(Option.COMPRESSION.toString(), (Object)this.compression).add(Option.EXTENSIONS.toString(), this.extensions).add(Option.CDC.toString(), this.cdc).add(Option.READ_REPAIR.toString(), (Object)this.readRepair).toString();
    }

    public void appendCqlTo(CqlBuilder builder) {
        builder.append("additional_write_policy = ").appendWithSingleQuotes(this.additionalWritePolicy.toString()).newLine().append("AND bloom_filter_fp_chance = ").append(this.bloomFilterFpChance).newLine().append("AND caching = ").append(this.caching.asMap()).newLine().append("AND cdc = ").append(this.cdc).newLine().append("AND comment = ").appendWithSingleQuotes(this.comment).newLine().append("AND compaction = ").append(this.compaction.asMap()).newLine().append("AND compression = ").append(this.compression.asMap()).newLine().append("AND crc_check_chance = ").append(this.crcCheckChance).newLine().append("AND default_time_to_live = ").append(this.defaultTimeToLive).newLine().append("AND extensions = ").append(this.extensions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> "0x" + ByteBufferUtil.bytesToHex((ByteBuffer)e.getValue()))), false).newLine().append("AND gc_grace_seconds = ").append(this.gcGraceSeconds).newLine().append("AND max_index_interval = ").append(this.maxIndexInterval).newLine().append("AND memtable_flush_period_in_ms = ").append(this.memtableFlushPeriodInMs).newLine().append("AND min_index_interval = ").append(this.minIndexInterval).newLine().append("AND read_repair = ").appendWithSingleQuotes(this.readRepair.toString()).newLine().append("AND speculative_retry = ").appendWithSingleQuotes(this.speculativeRetry.toString());
    }

    public static final class Builder {
        private String comment = "";
        private Double bloomFilterFpChance;
        private double crcCheckChance = 1.0;
        private int gcGraceSeconds = 864000;
        private int defaultTimeToLive = 0;
        private int memtableFlushPeriodInMs = 0;
        private int minIndexInterval = 128;
        private int maxIndexInterval = 2048;
        private SpeculativeRetryPolicy speculativeRetry = PercentileSpeculativeRetryPolicy.NINETY_NINE_P;
        private SpeculativeRetryPolicy additionalWritePolicy = PercentileSpeculativeRetryPolicy.NINETY_NINE_P;
        private CachingParams caching = CachingParams.DEFAULT;
        private CompactionParams compaction = CompactionParams.DEFAULT;
        private CompressionParams compression = CompressionParams.DEFAULT;
        private ImmutableMap<String, ByteBuffer> extensions = ImmutableMap.of();
        private boolean cdc;
        private ReadRepairStrategy readRepair = ReadRepairStrategy.BLOCKING;

        public TableParams build() {
            return new TableParams(this);
        }

        public Builder comment(String val) {
            this.comment = val;
            return this;
        }

        public Builder bloomFilterFpChance(double val) {
            this.bloomFilterFpChance = val;
            return this;
        }

        public Builder crcCheckChance(double val) {
            this.crcCheckChance = val;
            return this;
        }

        public Builder gcGraceSeconds(int val) {
            this.gcGraceSeconds = val;
            return this;
        }

        public Builder defaultTimeToLive(int val) {
            this.defaultTimeToLive = val;
            return this;
        }

        public Builder memtableFlushPeriodInMs(int val) {
            this.memtableFlushPeriodInMs = val;
            return this;
        }

        public Builder minIndexInterval(int val) {
            this.minIndexInterval = val;
            return this;
        }

        public Builder maxIndexInterval(int val) {
            this.maxIndexInterval = val;
            return this;
        }

        public Builder speculativeRetry(SpeculativeRetryPolicy val) {
            this.speculativeRetry = val;
            return this;
        }

        public Builder additionalWritePolicy(SpeculativeRetryPolicy val) {
            this.additionalWritePolicy = val;
            return this;
        }

        public Builder caching(CachingParams val) {
            this.caching = val;
            return this;
        }

        public Builder compaction(CompactionParams val) {
            this.compaction = val;
            return this;
        }

        public Builder compression(CompressionParams val) {
            this.compression = val;
            return this;
        }

        public Builder cdc(boolean val) {
            this.cdc = val;
            return this;
        }

        public Builder readRepair(ReadRepairStrategy val) {
            this.readRepair = val;
            return this;
        }

        public Builder extensions(Map<String, ByteBuffer> val) {
            this.extensions = ImmutableMap.copyOf(val);
            return this;
        }
    }

    public static enum Option {
        BLOOM_FILTER_FP_CHANCE,
        CACHING,
        COMMENT,
        COMPACTION,
        COMPRESSION,
        DEFAULT_TIME_TO_LIVE,
        EXTENSIONS,
        GC_GRACE_SECONDS,
        MAX_INDEX_INTERVAL,
        MEMTABLE_FLUSH_PERIOD_IN_MS,
        MIN_INDEX_INTERVAL,
        SPECULATIVE_RETRY,
        ADDITIONAL_WRITE_POLICY,
        CRC_CHECK_CHANCE,
        CDC,
        READ_REPAIR;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

