/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.CqlBuilder;
import org.apache.cassandra.cql3.SchemaElement;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.schema.Functions;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.schema.ViewMetadata;
import org.apache.cassandra.schema.Views;
import org.apache.cassandra.service.StorageService;

public final class KeyspaceMetadata
implements SchemaElement {
    public final String name;
    public final Kind kind;
    public final KeyspaceParams params;
    public final Tables tables;
    public final Views views;
    public final Types types;
    public final Functions functions;

    private KeyspaceMetadata(String name, Kind kind, KeyspaceParams params, Tables tables, Views views, Types types, Functions functions) {
        this.name = name;
        this.kind = kind;
        this.params = params;
        this.tables = tables;
        this.views = views;
        this.types = types;
        this.functions = functions;
    }

    public static KeyspaceMetadata create(String name, KeyspaceParams params) {
        return new KeyspaceMetadata(name, Kind.REGULAR, params, Tables.none(), Views.none(), Types.none(), Functions.none());
    }

    public static KeyspaceMetadata create(String name, KeyspaceParams params, Tables tables) {
        return new KeyspaceMetadata(name, Kind.REGULAR, params, tables, Views.none(), Types.none(), Functions.none());
    }

    public static KeyspaceMetadata create(String name, KeyspaceParams params, Tables tables, Views views, Types types, Functions functions) {
        return new KeyspaceMetadata(name, Kind.REGULAR, params, tables, views, types, functions);
    }

    public static KeyspaceMetadata virtual(String name, Tables tables) {
        return new KeyspaceMetadata(name, Kind.VIRTUAL, KeyspaceParams.local(), tables, Views.none(), Types.none(), Functions.none());
    }

    public KeyspaceMetadata withSwapped(KeyspaceParams params) {
        return new KeyspaceMetadata(this.name, this.kind, params, this.tables, this.views, this.types, this.functions);
    }

    public KeyspaceMetadata withSwapped(Tables regular) {
        return new KeyspaceMetadata(this.name, this.kind, this.params, regular, this.views, this.types, this.functions);
    }

    public KeyspaceMetadata withSwapped(Views views) {
        return new KeyspaceMetadata(this.name, this.kind, this.params, this.tables, views, this.types, this.functions);
    }

    public KeyspaceMetadata withSwapped(Types types) {
        return new KeyspaceMetadata(this.name, this.kind, this.params, this.tables, this.views, types, this.functions);
    }

    public KeyspaceMetadata withSwapped(Functions functions) {
        return new KeyspaceMetadata(this.name, this.kind, this.params, this.tables, this.views, this.types, functions);
    }

    public boolean isVirtual() {
        return this.kind == Kind.VIRTUAL;
    }

    public KeyspaceMetadata withUpdatedUserType(UserType udt) {
        return new KeyspaceMetadata(this.name, this.kind, this.params, this.tables.withUpdatedUserType(udt), this.views.withUpdatedUserTypes(udt), this.types.withUpdatedUserType(udt), this.functions.withUpdatedUserType(udt));
    }

    public Iterable<TableMetadata> tablesAndViews() {
        return Iterables.concat((Iterable)this.tables, this.views.allTableMetadata());
    }

    @Nullable
    public TableMetadata getTableOrViewNullable(String tableOrViewName) {
        ViewMetadata view = this.views.getNullable(tableOrViewName);
        return view == null ? this.tables.getNullable(tableOrViewName) : view.metadata;
    }

    public boolean hasTable(String tableName) {
        return this.tables.get(tableName).isPresent();
    }

    public boolean hasView(String viewName) {
        return this.views.get(viewName).isPresent();
    }

    public boolean hasIndex(String indexName) {
        return Iterables.any((Iterable)this.tables, t -> t.indexes.has(indexName));
    }

    public String findAvailableIndexName(String baseName) {
        String name;
        if (!this.hasIndex(baseName)) {
            return baseName;
        }
        int i = 1;
        while (this.hasIndex(name = baseName + '_' + i++)) {
        }
        return name;
    }

    public Optional<TableMetadata> findIndexedTable(String indexName) {
        for (TableMetadata table : this.tablesAndViews()) {
            if (!table.indexes.has(indexName)) continue;
            return Optional.of(table);
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.kind, this.params, this.tables, this.views, this.functions, this.types});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyspaceMetadata)) {
            return false;
        }
        KeyspaceMetadata other = (KeyspaceMetadata)o;
        return this.name.equals(other.name) && this.kind == other.kind && this.params.equals(other.params) && this.tables.equals(other.tables) && this.views.equals(other.views) && this.functions.equals(other.functions) && this.types.equals(other.types);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("kind", (Object)this.kind).add("params", (Object)this.params).add("tables", (Object)this.tables).add("views", (Object)this.views).add("functions", (Object)this.functions).add("types", (Object)this.types).toString();
    }

    @Override
    public SchemaElement.SchemaElementType elementType() {
        return SchemaElement.SchemaElementType.KEYSPACE;
    }

    @Override
    public String elementKeyspace() {
        return this.name;
    }

    @Override
    public String elementName() {
        return this.name;
    }

    @Override
    public String toCqlString(boolean withInternals) {
        CqlBuilder builder = new CqlBuilder();
        if (this.isVirtual()) {
            builder.append("/*").newLine().append("Warning: Keyspace ").appendQuotingIfNeeded(this.name).append(" is a virtual keyspace and cannot be recreated with CQL.").newLine().append("Structure, for reference:").newLine().append("VIRTUAL KEYSPACE ").appendQuotingIfNeeded(this.name).append(';').newLine().append("*/").toString();
        } else {
            builder.append("CREATE KEYSPACE ").appendQuotingIfNeeded(this.name).append(" WITH replication = ");
            this.params.replication.appendCqlTo(builder);
            builder.append("  AND durable_writes = ").append(this.params.durableWrites).append(';').toString();
        }
        return builder.toString();
    }

    public void validate() {
        if (!SchemaConstants.isValidName(this.name)) {
            throw new ConfigurationException(String.format("Keyspace name must not be empty, more than %s characters long, or contain non-alphanumeric-underscore characters (got \"%s\")", 48, this.name));
        }
        this.params.validate(this.name);
        this.tablesAndViews().forEach(TableMetadata::validate);
        HashSet<String> indexNames = new HashSet<String>();
        for (TableMetadata table : this.tables) {
            for (IndexMetadata index : table.indexes) {
                if (indexNames.contains(index.name)) {
                    throw new ConfigurationException(String.format("Duplicate index name %s in keyspace %s", index.name, this.name));
                }
                indexNames.add(index.name);
            }
        }
    }

    public AbstractReplicationStrategy createReplicationStrategy() {
        return AbstractReplicationStrategy.createReplicationStrategy(this.name, this.params.replication.klass, StorageService.instance.getTokenMetadata(), DatabaseDescriptor.getEndpointSnitch(), this.params.replication.options);
    }

    static Optional<KeyspaceDiff> diff(KeyspaceMetadata before, KeyspaceMetadata after) {
        return KeyspaceDiff.diff(before, after);
    }

    public static final class KeyspaceDiff {
        public final KeyspaceMetadata before;
        public final KeyspaceMetadata after;
        public final Tables.TablesDiff tables;
        public final Views.ViewsDiff views;
        public final Types.TypesDiff types;
        public final Functions.FunctionsDiff<UDFunction> udfs;
        public final Functions.FunctionsDiff<UDAggregate> udas;

        private KeyspaceDiff(KeyspaceMetadata before, KeyspaceMetadata after, Tables.TablesDiff tables, Views.ViewsDiff views, Types.TypesDiff types, Functions.FunctionsDiff<UDFunction> udfs, Functions.FunctionsDiff<UDAggregate> udas) {
            this.before = before;
            this.after = after;
            this.tables = tables;
            this.views = views;
            this.types = types;
            this.udfs = udfs;
            this.udas = udas;
        }

        private static Optional<KeyspaceDiff> diff(KeyspaceMetadata before, KeyspaceMetadata after) {
            if (before == after) {
                return Optional.empty();
            }
            if (!before.name.equals(after.name)) {
                String msg = String.format("Attempting to diff two keyspaces with different names ('%s' and '%s')", before.name, after.name);
                throw new IllegalArgumentException(msg);
            }
            Tables.TablesDiff tables = Tables.diff(before.tables, after.tables);
            Views.ViewsDiff views = Views.diff(before.views, after.views);
            Types.TypesDiff types = Types.diff(before.types, after.types);
            Functions.FunctionsDiff<UDFunction> udfs = Functions.FunctionsDiff.NONE;
            Functions.FunctionsDiff<UDAggregate> udas = Functions.FunctionsDiff.NONE;
            if (before.functions != after.functions) {
                udfs = Functions.udfsDiff(before.functions, after.functions);
                udas = Functions.udasDiff(before.functions, after.functions);
            }
            if (before.params.equals(after.params) && tables.isEmpty() && views.isEmpty() && types.isEmpty() && udfs.isEmpty() && udas.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new KeyspaceDiff(before, after, tables, views, types, udfs, udas));
        }
    }

    public static enum Kind {
        REGULAR,
        VIRTUAL;

    }
}

