/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.ForwardingInfo;
import org.apache.cassandra.net.LegacyFlag;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.UUIDSerializer;

public enum ParamType {
    FORWARD_TO(0, "FORWARD_TO", ForwardingInfo.serializer),
    RESPOND_TO(1, "FORWARD_FROM", InetAddressAndPort.Serializer.inetAddressAndPortSerializer),
    FAILURE_RESPONSE(2, "FAIL", LegacyFlag.serializer),
    FAILURE_REASON(3, "FAIL_REASON", RequestFailureReason.serializer),
    FAILURE_CALLBACK(4, "CAL_BAC", LegacyFlag.serializer),
    TRACE_SESSION(5, "TraceSession", UUIDSerializer.serializer),
    TRACE_TYPE(6, "TraceType", Tracing.traceTypeSerializer),
    TRACK_REPAIRED_DATA(7, "TrackRepaired", LegacyFlag.serializer);

    final int id;
    @Deprecated
    final String legacyAlias;
    final IVersionedSerializer serializer;
    private static final ParamType[] idToTypeMap;
    private static final Map<String, ParamType> aliasToTypeMap;

    private ParamType(int id, String legacyAlias, IVersionedSerializer serializer) {
        if (id < 0) {
            throw new IllegalArgumentException("ParamType id must be non-negative");
        }
        this.id = id;
        this.legacyAlias = legacyAlias;
        this.serializer = serializer;
    }

    @Nullable
    static ParamType lookUpById(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("ParamType id must be non-negative (got " + id + ')');
        }
        return id < idToTypeMap.length ? idToTypeMap[id] : null;
    }

    @Nullable
    static ParamType lookUpByAlias(String alias) {
        return aliasToTypeMap.get(alias);
    }

    static {
        ParamType[] types = ParamType.values();
        int max = -1;
        for (ParamType t : types) {
            max = Math.max(t.id, max);
        }
        ParamType[] idMap = new ParamType[max + 1];
        HashMap<String, ParamType> aliasMap = new HashMap<String, ParamType>();
        for (ParamType type : types) {
            if (idMap[type.id] != null) {
                throw new RuntimeException("Two ParamType-s that map to the same id: " + type.id);
            }
            idMap[type.id] = type;
            if (aliasMap.put(type.legacyAlias, type) == null) continue;
            throw new RuntimeException("Two ParamType-s that map to the same legacy alias: " + type.legacyAlias);
        }
        idToTypeMap = idMap;
        aliasToTypeMap = aliasMap;
    }
}

