/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.net.Crc;
import org.apache.cassandra.net.FrameEncoder;
import org.apache.cassandra.net.GlobalBufferPoolAllocator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.memory.BufferPool;

@ChannelHandler.Sharable
class FrameEncoderLZ4
extends FrameEncoder {
    static final FrameEncoderLZ4 fastInstance = new FrameEncoderLZ4(LZ4Factory.fastestInstance().fastCompressor());
    private final LZ4Compressor compressor;
    private static final int HEADER_LENGTH = 8;
    static final int HEADER_AND_TRAILER_LENGTH = 12;

    private FrameEncoderLZ4(LZ4Compressor compressor) {
        this.compressor = compressor;
    }

    private static void writeHeader(ByteBuffer frame, boolean isSelfContained, long compressedLength, long uncompressedLength) {
        long header5b = compressedLength | uncompressedLength << 17;
        if (isSelfContained) {
            header5b |= 0x400000000L;
        }
        long crc = Crc.crc24(header5b, 5);
        long header8b = header5b | crc << 40;
        if (frame.order() == ByteOrder.BIG_ENDIAN) {
            header8b = Long.reverseBytes(header8b);
        }
        frame.putLong(0, header8b);
    }

    @Override
    public ByteBuf encode(boolean isSelfContained, ByteBuffer in) {
        ByteBuffer frame = null;
        try {
            int uncompressedLength = in.remaining();
            if (uncompressedLength >= 131072) {
                throw new IllegalArgumentException("Maximum uncompressed payload size is 128KiB");
            }
            int maxOutputLength = this.compressor.maxCompressedLength(uncompressedLength);
            frame = BufferPool.getAtLeast(12 + maxOutputLength, BufferType.OFF_HEAP);
            int compressedLength = this.compressor.compress(in, in.position(), uncompressedLength, frame, 8, maxOutputLength);
            if (compressedLength >= uncompressedLength) {
                ByteBufferUtil.copyBytes(in, in.position(), frame, 8, uncompressedLength);
                compressedLength = uncompressedLength;
                uncompressedLength = 0;
            }
            FrameEncoderLZ4.writeHeader(frame, isSelfContained, compressedLength, uncompressedLength);
            CRC32 crc = Crc.crc32();
            frame.position(8);
            frame.limit(compressedLength + 8);
            crc.update(frame);
            int frameCrc = (int)crc.getValue();
            if (frame.order() == ByteOrder.BIG_ENDIAN) {
                frameCrc = Integer.reverseBytes(frameCrc);
            }
            int frameLength = compressedLength + 12;
            frame.limit(frameLength);
            frame.putInt(frameCrc);
            frame.position(0);
            BufferPool.putUnusedPortion(frame);
            ByteBuf byteBuf = GlobalBufferPoolAllocator.wrap(frame);
            return byteBuf;
        }
        catch (Throwable t) {
            if (frame != null) {
                BufferPool.put(frame);
            }
            throw t;
        }
        finally {
            BufferPool.put(in);
        }
    }
}

