/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.DroppedMessageMetrics;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.net.InboundMessageHandlers;
import org.apache.cassandra.net.LatencyConsumer;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.utils.StatusLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingMetrics
implements InboundMessageHandlers.GlobalMetricCallbacks {
    private static final MetricNameFactory factory = new DefaultNameFactory("Messaging");
    private static final Logger logger = LoggerFactory.getLogger(MessagingMetrics.class);
    private static final int LOG_DROPPED_INTERVAL_IN_MS = 5000;
    private final Timer allLatency;
    public final ConcurrentHashMap<String, DCLatencyRecorder> dcLatency;
    public final EnumMap<Verb, Timer> internalLatency;
    private final Map<Verb, DroppedForVerb> droppedMessages = new EnumMap<Verb, DroppedForVerb>(Verb.class);

    public MessagingMetrics() {
        this.allLatency = CassandraMetricsRegistry.Metrics.timer(factory.createMetricName("CrossNodeLatency"));
        this.dcLatency = new ConcurrentHashMap();
        this.internalLatency = new EnumMap(Verb.class);
        for (Verb verb : Verb.VERBS) {
            this.internalLatency.put(verb, CassandraMetricsRegistry.Metrics.timer(factory.createMetricName((Object)((Object)verb) + "-WaitLatency")));
        }
        for (Verb verb : Verb.values()) {
            this.droppedMessages.put(verb, new DroppedForVerb(verb));
        }
    }

    @Override
    public DCLatencyRecorder internodeLatencyRecorder(InetAddressAndPort from) {
        String dcName = DatabaseDescriptor.getEndpointSnitch().getDatacenter(from);
        DCLatencyRecorder dcUpdater = this.dcLatency.get(dcName);
        if (dcUpdater == null) {
            dcUpdater = this.dcLatency.computeIfAbsent(dcName, k -> new DCLatencyRecorder(CassandraMetricsRegistry.Metrics.timer(factory.createMetricName(dcName + "-Latency")), this.allLatency));
        }
        return dcUpdater;
    }

    @Override
    public void recordInternalLatency(Verb verb, long timeTaken, TimeUnit units) {
        if (timeTaken > 0L) {
            this.internalLatency.get((Object)verb).update(timeTaken, units);
        }
    }

    public void recordSelfDroppedMessage(Verb verb) {
        MessagingMetrics.recordDroppedMessage(this.droppedMessages.get((Object)verb), false);
    }

    public void recordSelfDroppedMessage(Verb verb, long timeElapsed, TimeUnit timeUnit) {
        this.recordDroppedMessage(verb, timeElapsed, timeUnit, false);
    }

    @Override
    public void recordInternodeDroppedMessage(Verb verb, long timeElapsed, TimeUnit timeUnit) {
        this.recordDroppedMessage(verb, timeElapsed, timeUnit, true);
    }

    public void recordDroppedMessage(Message<?> message, long timeElapsed, TimeUnit timeUnit) {
        this.recordDroppedMessage(message.verb(), timeElapsed, timeUnit, message.isCrossNode());
    }

    public void recordDroppedMessage(Verb verb, long timeElapsed, TimeUnit timeUnit, boolean isCrossNode) {
        MessagingMetrics.recordDroppedMessage(this.droppedMessages.get((Object)verb), timeElapsed, timeUnit, isCrossNode);
    }

    private static void recordDroppedMessage(DroppedForVerb droppedMessages, long timeTaken, TimeUnit units, boolean isCrossNode) {
        if (isCrossNode) {
            droppedMessages.metrics.crossNodeDroppedLatency.update(timeTaken, units);
        } else {
            droppedMessages.metrics.internalDroppedLatency.update(timeTaken, units);
        }
        MessagingMetrics.recordDroppedMessage(droppedMessages, isCrossNode);
    }

    private static void recordDroppedMessage(DroppedForVerb droppedMessages, boolean isCrossNode) {
        droppedMessages.metrics.dropped.mark();
        if (isCrossNode) {
            droppedMessages.droppedFromPeer.incrementAndGet();
        } else {
            droppedMessages.droppedFromSelf.incrementAndGet();
        }
    }

    public void scheduleLogging() {
        ScheduledExecutors.scheduledTasks.scheduleWithFixedDelay(this::logDroppedMessages, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    public Map<String, Integer> getDroppedMessages() {
        HashMap<String, Integer> map = new HashMap<String, Integer>(this.droppedMessages.size());
        for (Map.Entry<Verb, DroppedForVerb> entry : this.droppedMessages.entrySet()) {
            map.put(entry.getKey().toString(), (int)entry.getValue().metrics.dropped.getCount());
        }
        return map;
    }

    private void logDroppedMessages() {
        if (this.resetAndConsumeDroppedErrors(arg_0 -> ((Logger)logger).info(arg_0)) > 0) {
            StatusLogger.log();
        }
    }

    @VisibleForTesting
    public int resetAndConsumeDroppedErrors(Consumer<String> messageConsumer) {
        int count = 0;
        for (Map.Entry<Verb, DroppedForVerb> entry : this.droppedMessages.entrySet()) {
            Verb verb = entry.getKey();
            DroppedForVerb droppedForVerb = entry.getValue();
            int droppedInternal = droppedForVerb.droppedFromSelf.getAndSet(0);
            int droppedCrossNode = droppedForVerb.droppedFromPeer.getAndSet(0);
            if (droppedInternal <= 0 && droppedCrossNode <= 0) continue;
            messageConsumer.accept(String.format("%s messages were dropped in last %d ms: %d internal and %d cross node. Mean internal dropped latency: %d ms and Mean cross-node dropped latency: %d ms", new Object[]{verb, 5000, droppedInternal, droppedCrossNode, TimeUnit.NANOSECONDS.toMillis((long)droppedForVerb.metrics.internalDroppedLatency.getSnapshot().getMean()), TimeUnit.NANOSECONDS.toMillis((long)droppedForVerb.metrics.crossNodeDroppedLatency.getSnapshot().getMean())}));
            ++count;
        }
        return count;
    }

    @VisibleForTesting
    public void resetDroppedMessages(String scope) {
        for (Verb verb : this.droppedMessages.keySet()) {
            this.droppedMessages.put(verb, new DroppedForVerb(new DroppedMessageMetrics(metricName -> new CassandraMetricsRegistry.MetricName("DroppedMessages", metricName, scope))));
        }
    }

    private static final class DroppedForVerb {
        final DroppedMessageMetrics metrics;
        final AtomicInteger droppedFromSelf;
        final AtomicInteger droppedFromPeer;

        DroppedForVerb(Verb verb) {
            this(new DroppedMessageMetrics(verb));
        }

        DroppedForVerb(DroppedMessageMetrics metrics) {
            this.metrics = metrics;
            this.droppedFromSelf = new AtomicInteger(0);
            this.droppedFromPeer = new AtomicInteger(0);
        }
    }

    public static class DCLatencyRecorder
    implements LatencyConsumer {
        public final Timer dcLatency;
        public final Timer allLatency;

        DCLatencyRecorder(Timer dcLatency, Timer allLatency) {
            this.dcLatency = dcLatency;
            this.allLatency = allLatency;
        }

        @Override
        public void accept(long timeTaken, TimeUnit units) {
            if (timeTaken > 0L) {
                this.dcLatency.update(timeTaken, units);
                this.allLatency.update(timeTaken, units);
            }
        }
    }
}

