/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.streaming;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.apache.cassandra.db.streaming.ComponentManifest;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.net.AsyncStreamingOutputPlus;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.StreamManager;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraEntireSSTableStreamWriter {
    private static final Logger logger = LoggerFactory.getLogger(CassandraEntireSSTableStreamWriter.class);
    private final SSTableReader sstable;
    private final ComponentManifest manifest;
    private final StreamSession session;
    private final StreamManager.StreamRateLimiter limiter;

    public CassandraEntireSSTableStreamWriter(SSTableReader sstable, StreamSession session, ComponentManifest manifest) {
        this.session = session;
        this.sstable = sstable;
        this.manifest = manifest;
        this.limiter = StreamManager.getRateLimiter(session.peer);
    }

    public void write(AsyncStreamingOutputPlus out) throws IOException {
        long totalSize = this.manifest.totalSize();
        logger.debug("[Stream #{}] Start streaming sstable {} to {}, repairedAt = {}, totalSize = {}", new Object[]{this.session.planId(), this.sstable.getFilename(), this.session.peer, this.sstable.getSSTableMetadata().repairedAt, FBUtilities.prettyPrintMemory(totalSize)});
        long progress = 0L;
        for (Component component : this.manifest.components()) {
            FileChannel in = new RandomAccessFile(this.sstable.descriptor.filenameFor(component), "r").getChannel();
            long length = in.size();
            logger.debug("[Stream #{}] Streaming {}.{} gen {} component {} size {}", new Object[]{this.session.planId(), this.sstable.getKeyspaceName(), this.sstable.getColumnFamilyName(), this.sstable.descriptor.generation, component, FBUtilities.prettyPrintMemory(length)});
            long bytesWritten = out.writeFileToChannel(in, this.limiter);
            progress += bytesWritten;
            this.session.progress(this.sstable.descriptor.filenameFor(component), ProgressInfo.Direction.OUT, bytesWritten, length);
            logger.debug("[Stream #{}] Finished streaming {}.{} gen {} component {} to {}, xfered = {}, length = {}, totalSize = {}", new Object[]{this.session.planId(), this.sstable.getKeyspaceName(), this.sstable.getColumnFamilyName(), this.sstable.descriptor.generation, component, this.session.peer, FBUtilities.prettyPrintMemory(bytesWritten), FBUtilities.prettyPrintMemory(length), FBUtilities.prettyPrintMemory(totalSize)});
        }
        out.flush();
        logger.debug("[Stream #{}] Finished streaming sstable {} to {}, xfered = {}, totalSize = {}", new Object[]{this.session.planId(), this.sstable.getFilename(), this.session.peer, FBUtilities.prettyPrintMemory(progress), FBUtilities.prettyPrintMemory(totalSize)});
    }
}

