/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DeletionPurger;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.rows.AbstractRow;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Cells;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.DroppedColumn;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.BiLongAccumulator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.LongAccumulator;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.BTreeSearchIterator;
import org.apache.cassandra.utils.btree.UpdateFunction;

public class BTreeRow
extends AbstractRow {
    private static final long EMPTY_SIZE = ObjectSizes.measure(BTreeRow.emptyRow(Clustering.EMPTY));
    private final Clustering clustering;
    private final LivenessInfo primaryKeyLivenessInfo;
    private final Row.Deletion deletion;
    private final Object[] btree;
    private static final ColumnData FIRST_COMPLEX_STATIC = new ComplexColumnData(Columns.FIRST_COMPLEX_STATIC, new Object[0], new DeletionTime(0L, 0));
    private static final ColumnData FIRST_COMPLEX_REGULAR = new ComplexColumnData(Columns.FIRST_COMPLEX_REGULAR, new Object[0], new DeletionTime(0L, 0));
    private static final Comparator<ColumnData> COLUMN_COMPARATOR = (cd1, cd2) -> cd1.column.compareTo(cd2.column);
    private final int minLocalDeletionTime;

    private BTreeRow(Clustering clustering, LivenessInfo primaryKeyLivenessInfo, Row.Deletion deletion, Object[] btree, int minLocalDeletionTime) {
        assert (!deletion.isShadowedBy(primaryKeyLivenessInfo));
        this.clustering = clustering;
        this.primaryKeyLivenessInfo = primaryKeyLivenessInfo;
        this.deletion = deletion;
        this.btree = btree;
        this.minLocalDeletionTime = minLocalDeletionTime;
    }

    private BTreeRow(Clustering clustering, Object[] btree, int minLocalDeletionTime) {
        this(clustering, LivenessInfo.EMPTY, Row.Deletion.LIVE, btree, minLocalDeletionTime);
    }

    public static BTreeRow create(Clustering clustering, LivenessInfo primaryKeyLivenessInfo, Row.Deletion deletion, Object[] btree) {
        int minDeletionTime = Math.min(BTreeRow.minDeletionTime(primaryKeyLivenessInfo), BTreeRow.minDeletionTime(deletion.time()));
        if (minDeletionTime != Integer.MIN_VALUE) {
            long result = BTree.accumulate(btree, (cd, l) -> Math.min(l, (long)BTreeRow.minDeletionTime(cd)), minDeletionTime);
            minDeletionTime = Ints.checkedCast((long)result);
        }
        return BTreeRow.create(clustering, primaryKeyLivenessInfo, deletion, btree, minDeletionTime);
    }

    public static BTreeRow create(Clustering clustering, LivenessInfo primaryKeyLivenessInfo, Row.Deletion deletion, Object[] btree, int minDeletionTime) {
        return new BTreeRow(clustering, primaryKeyLivenessInfo, deletion, btree, minDeletionTime);
    }

    public static BTreeRow emptyRow(Clustering clustering) {
        return new BTreeRow(clustering, BTree.empty(), Integer.MAX_VALUE);
    }

    public static BTreeRow singleCellRow(Clustering clustering, Cell cell) {
        if (cell.column().isSimple()) {
            return new BTreeRow(clustering, BTree.singleton(cell), BTreeRow.minDeletionTime(cell));
        }
        ComplexColumnData complexData = new ComplexColumnData(cell.column(), new Cell[]{cell}, DeletionTime.LIVE);
        return new BTreeRow(clustering, BTree.singleton(complexData), BTreeRow.minDeletionTime(cell));
    }

    public static BTreeRow emptyDeletedRow(Clustering clustering, Row.Deletion deletion) {
        assert (!deletion.isLive());
        return new BTreeRow(clustering, LivenessInfo.EMPTY, deletion, BTree.empty(), Integer.MIN_VALUE);
    }

    public static BTreeRow noCellLiveRow(Clustering clustering, LivenessInfo primaryKeyLivenessInfo) {
        assert (!primaryKeyLivenessInfo.isEmpty());
        return new BTreeRow(clustering, primaryKeyLivenessInfo, Row.Deletion.LIVE, BTree.empty(), BTreeRow.minDeletionTime(primaryKeyLivenessInfo));
    }

    private static int minDeletionTime(Cell cell) {
        return cell.isTombstone() ? Integer.MIN_VALUE : cell.localDeletionTime();
    }

    private static int minDeletionTime(LivenessInfo info) {
        return info.isExpiring() ? info.localExpirationTime() : Integer.MAX_VALUE;
    }

    private static int minDeletionTime(DeletionTime dt) {
        return dt.isLive() ? Integer.MAX_VALUE : Integer.MIN_VALUE;
    }

    private static int minDeletionTime(ComplexColumnData cd) {
        Cell cell;
        int min = BTreeRow.minDeletionTime(cd.complexDeletion());
        Iterator<Cell> iterator = cd.iterator();
        while (iterator.hasNext() && (min = Math.min(min, BTreeRow.minDeletionTime(cell = iterator.next()))) != Integer.MIN_VALUE) {
        }
        return min;
    }

    private static int minDeletionTime(ColumnData cd) {
        return cd.column().isSimple() ? BTreeRow.minDeletionTime((Cell)cd) : BTreeRow.minDeletionTime((ComplexColumnData)cd);
    }

    @Override
    public void apply(Consumer<ColumnData> function) {
        BTree.apply(this.btree, function);
    }

    @Override
    public <A> void apply(BiConsumer<A, ColumnData> function, A arg) {
        BTree.apply(this.btree, function, arg);
    }

    @Override
    public long accumulate(LongAccumulator<ColumnData> accumulator, long initialValue) {
        return BTree.accumulate(this.btree, accumulator, initialValue);
    }

    @Override
    public long accumulate(LongAccumulator<ColumnData> accumulator, Comparator<ColumnData> comparator, ColumnData from, long initialValue) {
        return BTree.accumulate(this.btree, accumulator, comparator, from, initialValue);
    }

    @Override
    public <A> long accumulate(BiLongAccumulator<A, ColumnData> accumulator, A arg, long initialValue) {
        return BTree.accumulate(this.btree, accumulator, arg, initialValue);
    }

    @Override
    public <A> long accumulate(BiLongAccumulator<A, ColumnData> accumulator, A arg, Comparator<ColumnData> comparator, ColumnData from, long initialValue) {
        return BTree.accumulate(this.btree, accumulator, arg, comparator, from, initialValue);
    }

    private static int minDeletionTime(Object[] btree, LivenessInfo info, DeletionTime rowDeletion) {
        long min = Math.min(BTreeRow.minDeletionTime(info), BTreeRow.minDeletionTime(rowDeletion));
        if ((min = BTree.accumulate(btree, (cd, l) -> {
            int m = Math.min((int)l, BTreeRow.minDeletionTime(cd));
            return m != Integer.MIN_VALUE ? (long)m : Long.MAX_VALUE;
        }, min)) == Long.MAX_VALUE) {
            return Integer.MIN_VALUE;
        }
        return Ints.checkedCast((long)min);
    }

    @Override
    public Clustering clustering() {
        return this.clustering;
    }

    @Override
    public Collection<ColumnMetadata> columns() {
        return Collections2.transform(this.columnData(), ColumnData::column);
    }

    @Override
    public int columnCount() {
        return BTree.size(this.btree);
    }

    @Override
    public LivenessInfo primaryKeyLivenessInfo() {
        return this.primaryKeyLivenessInfo;
    }

    @Override
    public boolean isEmpty() {
        return this.primaryKeyLivenessInfo().isEmpty() && this.deletion().isLive() && BTree.isEmpty(this.btree);
    }

    @Override
    public Row.Deletion deletion() {
        return this.deletion;
    }

    @Override
    public Cell getCell(ColumnMetadata c) {
        assert (!c.isComplex());
        return (Cell)((Object)BTree.find(this.btree, ColumnMetadata.asymmetricColumnDataComparator, c));
    }

    @Override
    public Cell getCell(ColumnMetadata c, CellPath path) {
        assert (c.isComplex());
        ComplexColumnData cd = this.getComplexColumnData(c);
        if (cd == null) {
            return null;
        }
        return cd.getCell(path);
    }

    @Override
    public ComplexColumnData getComplexColumnData(ColumnMetadata c) {
        assert (c.isComplex());
        return (ComplexColumnData)((Object)BTree.find(this.btree, ColumnMetadata.asymmetricColumnDataComparator, c));
    }

    @Override
    public Collection<ColumnData> columnData() {
        return new AbstractCollection<ColumnData>(){

            @Override
            public Iterator<ColumnData> iterator() {
                return BTreeRow.this.iterator();
            }

            @Override
            public int size() {
                return BTree.size(BTreeRow.this.btree);
            }
        };
    }

    @Override
    public Iterator<ColumnData> iterator() {
        return this.searchIterator();
    }

    @Override
    public Iterable<Cell> cells() {
        return () -> new CellIterator();
    }

    public BTreeSearchIterator<ColumnMetadata, ColumnData> searchIterator() {
        return BTree.slice(this.btree, ColumnMetadata.asymmetricColumnDataComparator, BTree.Dir.ASC);
    }

    @Override
    public Row filter(ColumnFilter filter, TableMetadata metadata) {
        return this.filter(filter, DeletionTime.LIVE, false, metadata);
    }

    @Override
    public Row filter(ColumnFilter filter, DeletionTime activeDeletion, boolean setActiveDeletionToRow, TableMetadata metadata) {
        ImmutableMap<ByteBuffer, DroppedColumn> droppedColumns = metadata.droppedColumns;
        boolean mayFilterColumns = !filter.fetchesAllColumns(this.isStatic());
        boolean mayHaveShadowed = activeDeletion.supersedes(this.deletion.time());
        if (!mayFilterColumns && !mayHaveShadowed && droppedColumns.isEmpty()) {
            return this;
        }
        LivenessInfo newInfo = this.primaryKeyLivenessInfo;
        Row.Deletion newDeletion = this.deletion;
        if (mayHaveShadowed) {
            if (activeDeletion.deletes(newInfo.timestamp())) {
                newInfo = LivenessInfo.EMPTY;
            }
            newDeletion = setActiveDeletionToRow ? Row.Deletion.regular(activeDeletion) : Row.Deletion.LIVE;
        }
        Columns columns = filter.fetchedColumns().columns(this.isStatic());
        Predicate<ColumnMetadata> inclusionTester = columns.inOrderInclusionTester();
        Predicate<ColumnMetadata> queriedByUserTester = filter.queriedColumns().columns(this.isStatic()).inOrderInclusionTester();
        LivenessInfo rowLiveness = newInfo;
        return this.transformAndFilter(newInfo, newDeletion, (Function<ColumnData, ColumnData>)((Function)cd -> {
            ColumnMetadata column = cd.column();
            if (!inclusionTester.test(column)) {
                return null;
            }
            DroppedColumn dropped = (DroppedColumn)droppedColumns.get(column.name.bytes);
            if (column.isComplex()) {
                return ((ComplexColumnData)cd).filter(filter, mayHaveShadowed ? activeDeletion : DeletionTime.LIVE, dropped, rowLiveness);
            }
            Cell cell = (Cell)cd;
            boolean isForDropped = dropped != null && cell.timestamp() <= dropped.droppedTime;
            boolean isShadowed = mayHaveShadowed && activeDeletion.deletes(cell);
            boolean isSkippable = !queriedByUserTester.test(column) && cell.timestamp() < rowLiveness.timestamp();
            return isForDropped || isShadowed || isSkippable ? null : cell;
        }));
    }

    @Override
    public Row withOnlyQueriedData(ColumnFilter filter) {
        if (filter.allFetchedColumnsAreQueried()) {
            return this;
        }
        return this.transformAndFilter(this.primaryKeyLivenessInfo, this.deletion, (Function<ColumnData, ColumnData>)((Function)cd -> {
            ColumnMetadata column = cd.column();
            if (column.isComplex()) {
                return ((ComplexColumnData)cd).withOnlyQueriedData(filter);
            }
            return filter.fetchedColumnIsQueried(column) ? cd : null;
        }));
    }

    @Override
    public boolean hasComplex() {
        if (BTree.isEmpty(this.btree)) {
            return false;
        }
        int size = BTree.size(this.btree);
        ColumnData last = (ColumnData)BTree.findByIndex(this.btree, size - 1);
        return last.column.isComplex();
    }

    @Override
    public boolean hasComplexDeletion() {
        long result = this.accumulate((cd, v) -> ((ComplexColumnData)cd).complexDeletion().isLive() ? 0L : Long.MAX_VALUE, COLUMN_COMPARATOR, this.isStatic() ? FIRST_COMPLEX_STATIC : FIRST_COMPLEX_REGULAR, 0L);
        return result == Long.MAX_VALUE;
    }

    @Override
    public Row markCounterLocalToBeCleared() {
        return this.transformAndFilter(this.primaryKeyLivenessInfo, this.deletion, (Function<ColumnData, ColumnData>)((Function)cd -> cd.column().isCounterColumn() ? cd.markCounterLocalToBeCleared() : cd));
    }

    @Override
    public boolean hasDeletion(int nowInSec) {
        return nowInSec >= this.minLocalDeletionTime;
    }

    @Override
    public boolean hasInvalidDeletions() {
        if (this.primaryKeyLivenessInfo().isExpiring() && (this.primaryKeyLivenessInfo().ttl() < 0 || this.primaryKeyLivenessInfo().localExpirationTime() < 0)) {
            return true;
        }
        if (!this.deletion().time().validate()) {
            return true;
        }
        return this.accumulate((cd, v) -> cd.hasInvalidDeletions() ? Long.MAX_VALUE : v, 0L) != 0L;
    }

    @Override
    public Row updateAllTimestamp(long newTimestamp) {
        LivenessInfo newInfo = this.primaryKeyLivenessInfo.isEmpty() ? this.primaryKeyLivenessInfo : this.primaryKeyLivenessInfo.withUpdatedTimestamp(newTimestamp);
        Row.Deletion newDeletion = this.deletion.isLive() || this.deletion.isShadowable() && !this.primaryKeyLivenessInfo.isEmpty() ? Row.Deletion.LIVE : new Row.Deletion(new DeletionTime(newTimestamp - 1L, this.deletion.time().localDeletionTime()), this.deletion.isShadowable());
        return this.transformAndFilter(newInfo, newDeletion, (Function<ColumnData, ColumnData>)((Function)cd -> cd.updateAllTimestamp(newTimestamp)));
    }

    @Override
    public Row withRowDeletion(DeletionTime newDeletion) {
        return newDeletion.isLive() || !this.deletion.isLive() ? this : new BTreeRow(this.clustering, this.primaryKeyLivenessInfo, Row.Deletion.regular(newDeletion), this.btree, Integer.MIN_VALUE);
    }

    @Override
    public Row purge(DeletionPurger purger, int nowInSec, boolean enforceStrictLiveness) {
        Row.Deletion newDeletion;
        if (!this.hasDeletion(nowInSec)) {
            return this;
        }
        LivenessInfo newInfo = purger.shouldPurge(this.primaryKeyLivenessInfo, nowInSec) ? LivenessInfo.EMPTY : this.primaryKeyLivenessInfo;
        Row.Deletion deletion = newDeletion = purger.shouldPurge(this.deletion.time()) ? Row.Deletion.LIVE : this.deletion;
        if (enforceStrictLiveness && newDeletion.isLive() && newInfo.isEmpty()) {
            return null;
        }
        return this.transformAndFilter(newInfo, newDeletion, (Function<ColumnData, ColumnData>)((Function)cd -> cd.purge(purger, nowInSec)));
    }

    private Row transformAndFilter(LivenessInfo info, Row.Deletion deletion, Function<ColumnData, ColumnData> function) {
        Object[] transformed = BTree.transformAndFilter(this.btree, function);
        if (this.btree == transformed && info == this.primaryKeyLivenessInfo && deletion == this.deletion) {
            return this;
        }
        if (info.isEmpty() && deletion.isLive() && BTree.isEmpty(transformed)) {
            return null;
        }
        int minDeletionTime = BTreeRow.minDeletionTime(transformed, info, deletion.time());
        return BTreeRow.create(this.clustering, info, deletion, transformed, minDeletionTime);
    }

    @Override
    public int dataSize() {
        int dataSize = this.clustering.dataSize() + this.primaryKeyLivenessInfo.dataSize() + this.deletion.dataSize();
        return Ints.checkedCast((long)this.accumulate((cd, v) -> v + (long)cd.dataSize(), dataSize));
    }

    @Override
    public long unsharedHeapSizeExcludingData() {
        long heapSize = EMPTY_SIZE + this.clustering.unsharedHeapSizeExcludingData() + BTree.sizeOfStructureOnHeap(this.btree);
        return this.accumulate((cd, v) -> v + cd.unsharedHeapSizeExcludingData(), heapSize);
    }

    public static Row.Builder sortedBuilder() {
        return new Builder(true);
    }

    public static Row.Builder unsortedBuilder() {
        return new Builder(false);
    }

    public void setValue(ColumnMetadata column, CellPath path, ByteBuffer value) {
        ColumnData current = (ColumnData)((Object)BTree.find(this.btree, ColumnMetadata.asymmetricColumnDataComparator, column));
        if (column.isSimple()) {
            BTree.replaceInSitu(this.btree, ColumnData.comparator, current, ((Cell)current).withUpdatedValue(value));
        } else {
            ((ComplexColumnData)current).setValue(path, value);
        }
    }

    @Override
    public Iterable<Cell> cellsInLegacyOrder(TableMetadata metadata, boolean reversed) {
        return () -> new CellInLegacyOrderIterator(metadata, reversed);
    }

    public static class Builder
    implements Row.Builder {
        protected Clustering clustering;
        protected LivenessInfo primaryKeyLivenessInfo = LivenessInfo.EMPTY;
        protected Row.Deletion deletion = Row.Deletion.LIVE;
        private final boolean isSorted;
        private BTree.Builder<Cell> cells_;
        private boolean hasComplex = false;

        protected Builder(boolean isSorted) {
            this.cells_ = null;
            this.isSorted = isSorted;
        }

        private BTree.Builder<Cell> getCells() {
            if (this.cells_ == null) {
                this.cells_ = BTree.builder(ColumnData.comparator);
                this.cells_.auto(false);
            }
            return this.cells_;
        }

        protected Builder(Builder builder) {
            this.clustering = builder.clustering;
            this.primaryKeyLivenessInfo = builder.primaryKeyLivenessInfo;
            this.deletion = builder.deletion;
            this.cells_ = builder.cells_ == null ? null : builder.cells_.copy();
            this.isSorted = builder.isSorted;
            this.hasComplex = builder.hasComplex;
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public boolean isSorted() {
            return this.isSorted;
        }

        @Override
        public void newRow(Clustering clustering) {
            assert (this.clustering == null);
            this.clustering = clustering;
        }

        @Override
        public Clustering clustering() {
            return this.clustering;
        }

        protected void reset() {
            this.clustering = null;
            this.primaryKeyLivenessInfo = LivenessInfo.EMPTY;
            this.deletion = Row.Deletion.LIVE;
            this.cells_.reuse();
            this.hasComplex = false;
        }

        @Override
        public void addPrimaryKeyLivenessInfo(LivenessInfo info) {
            if (!this.deletion.deletes(info)) {
                this.primaryKeyLivenessInfo = info;
            }
        }

        @Override
        public void addRowDeletion(Row.Deletion deletion) {
            this.deletion = deletion;
            if (deletion.deletes(this.primaryKeyLivenessInfo)) {
                this.primaryKeyLivenessInfo = LivenessInfo.EMPTY;
            }
        }

        @Override
        public void addCell(Cell cell) {
            assert (cell.column().isStatic() == (this.clustering == Clustering.STATIC_CLUSTERING)) : "Column is " + cell.column() + ", clustering = " + this.clustering;
            if (this.deletion.deletes(cell)) {
                return;
            }
            this.getCells().add(cell);
            this.hasComplex |= cell.column.isComplex();
        }

        @Override
        public void addComplexDeletion(ColumnMetadata column, DeletionTime complexDeletion) {
            this.getCells().add(new ComplexColumnDeletion(column, complexDeletion));
            this.hasComplex = true;
        }

        @Override
        public Row build() {
            if (!this.isSorted) {
                this.getCells().sort();
            }
            if (!this.isSorted | this.hasComplex) {
                this.getCells().resolve(CellResolver.instance);
            }
            Object[] btree = this.getCells().build();
            if (this.deletion.isShadowedBy(this.primaryKeyLivenessInfo)) {
                this.deletion = Row.Deletion.LIVE;
            }
            int minDeletionTime = BTreeRow.minDeletionTime(btree, this.primaryKeyLivenessInfo, this.deletion.time());
            BTreeRow row = BTreeRow.create(this.clustering, this.primaryKeyLivenessInfo, this.deletion, btree, minDeletionTime);
            this.reset();
            return row;
        }

        private static class CellResolver
        implements BTree.Builder.Resolver {
            static final CellResolver instance = new CellResolver();

            private CellResolver() {
            }

            @Override
            public ColumnData resolve(Object[] cells, int lb, int ub) {
                Cell cell = (Cell)cells[lb];
                ColumnMetadata column = cell.column;
                if (cell.column.isSimple()) {
                    while (++lb < ub) {
                        cell = Cells.reconcile(cell, (Cell)cells[lb]);
                    }
                    return cell;
                }
                Arrays.sort(cells, lb, ub, column.cellComparator());
                DeletionTime deletion = DeletionTime.LIVE;
                while (lb < ub && (cell = (Cell)cells[lb]) instanceof ComplexColumnDeletion) {
                    if (cell.timestamp() > deletion.markedForDeleteAt()) {
                        deletion = new DeletionTime(cell.timestamp(), cell.localDeletionTime());
                    }
                    ++lb;
                }
                ArrayList<Cell> buildFrom = new ArrayList<Cell>(ub - lb);
                Cell previous = null;
                for (int i = lb; i < ub; ++i) {
                    Cell c = (Cell)cells[i];
                    if (deletion != DeletionTime.LIVE && c.timestamp() < deletion.markedForDeleteAt()) continue;
                    if (previous != null && column.cellComparator().compare(previous, c) == 0) {
                        c = Cells.reconcile(previous, c);
                        buildFrom.set(buildFrom.size() - 1, c);
                    } else {
                        buildFrom.add(c);
                    }
                    previous = c;
                }
                Object[] btree = BTree.build(buildFrom, UpdateFunction.noOp());
                return new ComplexColumnData(column, btree, deletion);
            }
        }

        private static class ComplexColumnDeletion
        extends BufferCell {
            public ComplexColumnDeletion(ColumnMetadata column, DeletionTime deletionTime) {
                super(column, deletionTime.markedForDeleteAt(), 0, deletionTime.localDeletionTime(), ByteBufferUtil.EMPTY_BYTE_BUFFER, CellPath.BOTTOM);
            }
        }
    }

    private class CellInLegacyOrderIterator
    extends AbstractIterator<Cell> {
        private final Comparator<ByteBuffer> comparator;
        private final boolean reversed;
        private final int firstComplexIdx;
        private int simpleIdx;
        private int complexIdx;
        private Iterator<Cell> complexCells;
        private final Object[] data;

        private CellInLegacyOrderIterator(TableMetadata metadata, boolean reversed) {
            UTF8Type nameComparator = UTF8Type.instance;
            this.comparator = reversed ? Collections.reverseOrder(nameComparator) : nameComparator;
            this.reversed = reversed;
            this.data = new Object[BTree.size(BTreeRow.this.btree)];
            BTree.toArray(BTreeRow.this.btree, this.data, 0);
            int idx = Iterators.indexOf((Iterator)Iterators.forArray((Object[])this.data), cd -> cd instanceof ComplexColumnData);
            this.complexIdx = this.firstComplexIdx = idx < 0 ? this.data.length : idx;
        }

        private int getSimpleIdx() {
            return this.reversed ? this.firstComplexIdx - this.simpleIdx - 1 : this.simpleIdx;
        }

        private int getSimpleIdxAndIncrement() {
            int idx = this.getSimpleIdx();
            ++this.simpleIdx;
            return idx;
        }

        private int getComplexIdx() {
            return this.reversed ? this.data.length + this.firstComplexIdx - this.complexIdx - 1 : this.complexIdx;
        }

        private int getComplexIdxAndIncrement() {
            int idx = this.getComplexIdx();
            ++this.complexIdx;
            return idx;
        }

        private Iterator<Cell> makeComplexIterator(Object complexData) {
            ComplexColumnData ccd = (ComplexColumnData)complexData;
            return this.reversed ? ccd.reverseIterator() : ccd.iterator();
        }

        @Override
        protected Cell computeNext() {
            while (true) {
                if (this.complexCells != null) {
                    if (this.complexCells.hasNext()) {
                        return this.complexCells.next();
                    }
                    this.complexCells = null;
                }
                if (this.simpleIdx >= this.firstComplexIdx) {
                    if (this.complexIdx >= this.data.length) {
                        return (Cell)this.endOfData();
                    }
                    this.complexCells = this.makeComplexIterator(this.data[this.getComplexIdxAndIncrement()]);
                    continue;
                }
                if (this.complexIdx >= this.data.length) {
                    return (Cell)this.data[this.getSimpleIdxAndIncrement()];
                }
                if (this.comparator.compare(((ColumnData)this.data[this.getSimpleIdx()]).column().name.bytes, ((ColumnData)this.data[this.getComplexIdx()]).column().name.bytes) < 0) {
                    return (Cell)this.data[this.getSimpleIdxAndIncrement()];
                }
                this.complexCells = this.makeComplexIterator(this.data[this.getComplexIdxAndIncrement()]);
            }
        }
    }

    private class CellIterator
    extends AbstractIterator<Cell> {
        private Iterator<ColumnData> columnData;
        private Iterator<Cell> complexCells;

        private CellIterator() {
            this.columnData = BTreeRow.this.iterator();
        }

        @Override
        protected Cell computeNext() {
            ColumnData cd;
            while (true) {
                if (this.complexCells != null) {
                    if (this.complexCells.hasNext()) {
                        return this.complexCells.next();
                    }
                    this.complexCells = null;
                }
                if (!this.columnData.hasNext()) {
                    return (Cell)this.endOfData();
                }
                cd = this.columnData.next();
                if (!cd.column().isComplex()) break;
                this.complexCells = ((ComplexColumnData)cd).iterator();
            }
            return (Cell)cd;
        }
    }
}

