/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.NumberType;
import org.apache.cassandra.serializers.DecimalSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public class DecimalType
extends NumberType<BigDecimal> {
    public static final DecimalType instance = new DecimalType();
    private static final int MIN_SCALE = 32;
    private static final int MIN_SIGNIFICANT_DIGITS = 32;
    private static final int MAX_SCALE = 1000;
    private static final MathContext MAX_PRECISION = new MathContext(10000);

    DecimalType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public boolean isFloatingPoint() {
        return true;
    }

    @Override
    public int compareCustom(ByteBuffer o1, ByteBuffer o2) {
        if (!o1.hasRemaining() || !o2.hasRemaining()) {
            return o1.hasRemaining() ? 1 : (o2.hasRemaining() ? -1 : 0);
        }
        return ((BigDecimal)this.compose(o1)).compareTo((BigDecimal)this.compose(o2));
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        BigDecimal decimal;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            decimal = new BigDecimal(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("unable to make BigDecimal from '%s'", source), e);
        }
        return this.decompose(decimal);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.fromString(Objects.toString(parsed)));
        }
        catch (NumberFormatException | MarshalException exc) {
            throw new MarshalException(String.format("Value '%s' is not a valid representation of a decimal value", parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return Objects.toString(this.getSerializer().deserialize(buffer), "\"\"");
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.DECIMAL;
    }

    @Override
    public TypeSerializer<BigDecimal> getSerializer() {
        return DecimalSerializer.instance;
    }

    @Override
    protected int toInt(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected float toFloat(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected long toLong(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected double toDouble(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected BigInteger toBigInteger(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected BigDecimal toBigDecimal(ByteBuffer value) {
        return (BigDecimal)this.compose(value);
    }

    @Override
    public ByteBuffer add(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return this.decompose(leftType.toBigDecimal(left).add(rightType.toBigDecimal(right), MAX_PRECISION));
    }

    @Override
    public ByteBuffer substract(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return this.decompose(leftType.toBigDecimal(left).subtract(rightType.toBigDecimal(right), MAX_PRECISION));
    }

    @Override
    public ByteBuffer multiply(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return this.decompose(leftType.toBigDecimal(left).multiply(rightType.toBigDecimal(right), MAX_PRECISION));
    }

    @Override
    public ByteBuffer divide(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        BigDecimal leftOperand = leftType.toBigDecimal(left);
        BigDecimal rightOperand = rightType.toBigDecimal(right);
        int quotientFirstDigitPos = leftOperand.precision() - leftOperand.scale() - (rightOperand.precision() - rightOperand.scale());
        int scale = 32 - quotientFirstDigitPos;
        scale = Math.max(scale, leftOperand.scale());
        scale = Math.max(scale, rightOperand.scale());
        scale = Math.max(scale, 32);
        scale = Math.min(scale, 1000);
        return this.decompose(leftOperand.divide(rightOperand, scale, RoundingMode.HALF_UP).stripTrailingZeros());
    }

    @Override
    public ByteBuffer mod(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return this.decompose(leftType.toBigDecimal(left).remainder(rightType.toBigDecimal(right)));
    }

    @Override
    public ByteBuffer negate(ByteBuffer input) {
        return this.decompose(this.toBigDecimal(input).negate());
    }
}

