/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.MutationExceededMaxSizeException;
import org.apache.cassandra.db.SimpleBuilders;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.DeserializationHelper;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.MonotonicClock;
import org.apache.commons.lang3.StringUtils;

public class Mutation
implements IMutation {
    public static final MutationSerializer serializer = new MutationSerializer();
    private final String keyspaceName;
    private final DecoratedKey key;
    private final ImmutableMap<TableId, PartitionUpdate> modifications;
    final long approxCreatedAtNanos;
    final AtomicLong viewLockAcquireStart = new AtomicLong(0L);
    private final boolean cdcEnabled;
    private int serializedSize30;
    private int serializedSize3014;
    private int serializedSize40;

    public Mutation(PartitionUpdate update) {
        this(update.metadata().keyspace, update.partitionKey(), (ImmutableMap<TableId, PartitionUpdate>)ImmutableMap.of((Object)update.metadata().id, (Object)update), MonotonicClock.approxTime.now());
    }

    public Mutation(String keyspaceName, DecoratedKey key, ImmutableMap<TableId, PartitionUpdate> modifications, long approxCreatedAtNanos) {
        this.keyspaceName = keyspaceName;
        this.key = key;
        this.modifications = modifications;
        boolean cdc = false;
        for (PartitionUpdate pu : modifications.values()) {
            cdc |= pu.metadata().params.cdc;
        }
        this.cdcEnabled = cdc;
        this.approxCreatedAtNanos = approxCreatedAtNanos;
    }

    public Mutation without(Set<TableId> tableIds) {
        if (tableIds.isEmpty()) {
            return this;
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry update : this.modifications.entrySet()) {
            if (tableIds.contains(update.getKey())) continue;
            builder.put(update);
        }
        return new Mutation(this.keyspaceName, this.key, (ImmutableMap<TableId, PartitionUpdate>)builder.build(), this.approxCreatedAtNanos);
    }

    public Mutation without(TableId tableId) {
        return this.without(Collections.singleton(tableId));
    }

    @Override
    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    @Override
    public Collection<TableId> getTableIds() {
        return this.modifications.keySet();
    }

    @Override
    public DecoratedKey key() {
        return this.key;
    }

    public ImmutableCollection<PartitionUpdate> getPartitionUpdates() {
        return this.modifications.values();
    }

    @Override
    public void validateSize(int version, int overhead) {
        long totalSize = this.serializedSize(version) + overhead;
        if (totalSize > MAX_MUTATION_SIZE) {
            throw new MutationExceededMaxSizeException(this, version, totalSize);
        }
    }

    public PartitionUpdate getPartitionUpdate(TableMetadata table) {
        return table == null ? null : (PartitionUpdate)this.modifications.get((Object)table.id);
    }

    public boolean isEmpty() {
        return this.modifications.isEmpty();
    }

    public static Mutation merge(List<Mutation> mutations) {
        assert (!mutations.isEmpty());
        if (mutations.size() == 1) {
            return mutations.get(0);
        }
        HashSet updatedTables = new HashSet();
        String ks = null;
        DecoratedKey key = null;
        for (Mutation mutation : mutations) {
            updatedTables.addAll(mutation.modifications.keySet());
            if (ks != null && !ks.equals(mutation.keyspaceName)) {
                throw new IllegalArgumentException();
            }
            if (key != null && !key.equals(mutation.key)) {
                throw new IllegalArgumentException();
            }
            ks = mutation.keyspaceName;
            key = mutation.key;
        }
        ArrayList<PartitionUpdate> updates = new ArrayList<PartitionUpdate>(mutations.size());
        ImmutableMap.Builder modifications = new ImmutableMap.Builder();
        for (TableId table : updatedTables) {
            for (Mutation mutation : mutations) {
                PartitionUpdate upd = (PartitionUpdate)mutation.modifications.get((Object)table);
                if (upd == null) continue;
                updates.add(upd);
            }
            if (updates.isEmpty()) continue;
            modifications.put((Object)table, (Object)(updates.size() == 1 ? (PartitionUpdate)updates.get(0) : PartitionUpdate.merge(updates)));
            updates.clear();
        }
        return new Mutation(ks, key, (ImmutableMap<TableId, PartitionUpdate>)modifications.build(), MonotonicClock.approxTime.now());
    }

    public CompletableFuture<?> applyFuture() {
        Keyspace ks = Keyspace.open(this.keyspaceName);
        return ks.applyFuture(this, Keyspace.open((String)this.keyspaceName).getMetadata().params.durableWrites, true);
    }

    public void apply(boolean durableWrites, boolean isDroppable) {
        Keyspace.open(this.keyspaceName).apply(this, durableWrites, true, isDroppable);
    }

    public void apply(boolean durableWrites) {
        this.apply(durableWrites, true);
    }

    @Override
    public void apply() {
        this.apply(Keyspace.open((String)this.keyspaceName).getMetadata().params.durableWrites);
    }

    public void applyUnsafe() {
        this.apply(false);
    }

    @Override
    public long getTimeout(TimeUnit unit) {
        return DatabaseDescriptor.getWriteRpcTimeout(unit);
    }

    public int smallestGCGS() {
        int gcgs = Integer.MAX_VALUE;
        for (PartitionUpdate update : this.getPartitionUpdates()) {
            gcgs = Math.min(gcgs, update.metadata().params.gcGraceSeconds);
        }
        return gcgs;
    }

    public boolean trackedByCDC() {
        return this.cdcEnabled;
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean shallow) {
        StringBuilder buff = new StringBuilder("Mutation(");
        buff.append("keyspace='").append(this.keyspaceName).append('\'');
        buff.append(", key='").append(ByteBufferUtil.bytesToHex(this.key.getKey())).append('\'');
        buff.append(", modifications=[");
        if (shallow) {
            ArrayList<String> cfnames = new ArrayList<String>(this.modifications.size());
            for (TableId tableId : this.modifications.keySet()) {
                TableMetadata cfm = Schema.instance.getTableMetadata(tableId);
                cfnames.add(cfm == null ? "-dropped-" : cfm.name);
            }
            buff.append(StringUtils.join(cfnames, (String)", "));
        } else {
            buff.append("\n  ").append(StringUtils.join((Iterable)this.modifications.values(), (String)"\n  ")).append('\n');
        }
        return buff.append("])").toString();
    }

    public int serializedSize(int version) {
        switch (version) {
            case 10: {
                if (this.serializedSize30 == 0) {
                    this.serializedSize30 = (int)serializer.serializedSize(this, 10);
                }
                return this.serializedSize30;
            }
            case 11: {
                if (this.serializedSize3014 == 0) {
                    this.serializedSize3014 = (int)serializer.serializedSize(this, 11);
                }
                return this.serializedSize3014;
            }
            case 12: {
                if (this.serializedSize40 == 0) {
                    this.serializedSize40 = (int)serializer.serializedSize(this, 12);
                }
                return this.serializedSize40;
            }
        }
        throw new IllegalStateException("Unknown serialization version: " + version);
    }

    public static SimpleBuilder simpleBuilder(String keyspaceName, DecoratedKey partitionKey) {
        return new SimpleBuilders.MutationBuilder(keyspaceName, partitionKey);
    }

    public static class PartitionUpdateCollector {
        private final ImmutableMap.Builder<TableId, PartitionUpdate> modifications = new ImmutableMap.Builder();
        private final String keyspaceName;
        private final DecoratedKey key;
        private final long approxCreatedAtNanos = MonotonicClock.approxTime.now();
        private boolean empty = true;

        public PartitionUpdateCollector(String keyspaceName, DecoratedKey key) {
            this.keyspaceName = keyspaceName;
            this.key = key;
        }

        public PartitionUpdateCollector add(PartitionUpdate partitionUpdate) {
            assert (partitionUpdate != null);
            assert (partitionUpdate.partitionKey().getPartitioner() == this.key.getPartitioner());
            this.modifications.put((Object)partitionUpdate.metadata().id, (Object)partitionUpdate);
            this.empty = false;
            return this;
        }

        public DecoratedKey key() {
            return this.key;
        }

        public String getKeyspaceName() {
            return this.keyspaceName;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public Mutation build() {
            return new Mutation(this.keyspaceName, this.key, (ImmutableMap<TableId, PartitionUpdate>)this.modifications.build(), this.approxCreatedAtNanos);
        }
    }

    public static class MutationSerializer
    implements IVersionedSerializer<Mutation> {
        @Override
        public void serialize(Mutation mutation, DataOutputPlus out, int version) throws IOException {
            int size = mutation.modifications.size();
            out.writeUnsignedVInt(size);
            assert (size > 0);
            for (Map.Entry entry : mutation.modifications.entrySet()) {
                PartitionUpdate.serializer.serialize((PartitionUpdate)entry.getValue(), out, version);
            }
        }

        public Mutation deserialize(DataInputPlus in, int version, DeserializationHelper.Flag flag) throws IOException {
            int size = (int)in.readUnsignedVInt();
            assert (size > 0);
            PartitionUpdate update = PartitionUpdate.serializer.deserialize(in, version, flag);
            if (size == 1) {
                return new Mutation(update);
            }
            ImmutableMap.Builder modifications = new ImmutableMap.Builder();
            DecoratedKey dk = update.partitionKey();
            modifications.put((Object)update.metadata().id, (Object)update);
            for (int i = 1; i < size; ++i) {
                update = PartitionUpdate.serializer.deserialize(in, version, flag);
                modifications.put((Object)update.metadata().id, (Object)update);
            }
            return new Mutation(update.metadata().keyspace, dk, (ImmutableMap<TableId, PartitionUpdate>)modifications.build(), MonotonicClock.approxTime.now());
        }

        @Override
        public Mutation deserialize(DataInputPlus in, int version) throws IOException {
            return this.deserialize(in, version, DeserializationHelper.Flag.FROM_REMOTE);
        }

        @Override
        public long serializedSize(Mutation mutation, int version) {
            int size = TypeSizes.sizeofUnsignedVInt(mutation.modifications.size());
            for (Map.Entry entry : mutation.modifications.entrySet()) {
                size = (int)((long)size + PartitionUpdate.serializer.serializedSize((PartitionUpdate)entry.getValue(), version));
            }
            return size;
        }
    }

    public static interface SimpleBuilder {
        public SimpleBuilder timestamp(long var1);

        public SimpleBuilder ttl(int var1);

        public PartitionUpdate.SimpleBuilder update(TableMetadata var1);

        public PartitionUpdate.SimpleBuilder update(String var1);

        public Mutation build();
    }
}

