/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Tuples;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.TokenRestriction;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;

public final class TokenRelation
extends Relation {
    private final List<ColumnIdentifier> entities;
    private final Term.Raw value;

    public TokenRelation(List<ColumnIdentifier> entities, Operator type, Term.Raw value) {
        this.entities = entities;
        this.relationType = type;
        this.value = value;
    }

    @Override
    public boolean onToken() {
        return true;
    }

    @Override
    public Term.Raw getValue() {
        return this.value;
    }

    @Override
    public List<? extends Term.Raw> getInValues() {
        return null;
    }

    @Override
    protected Restriction newEQRestriction(TableMetadata table, VariableSpecifications boundNames) {
        List<ColumnMetadata> columnDefs = this.getColumnDefinitions(table);
        Term term = this.toTerm(TokenRelation.toReceivers(table, columnDefs), this.value, table.keyspace, boundNames);
        return new TokenRestriction.EQRestriction(table, columnDefs, term);
    }

    @Override
    protected Restriction newINRestriction(TableMetadata table, VariableSpecifications boundNames) {
        throw RequestValidations.invalidRequest("%s cannot be used with the token function", new Object[]{this.operator()});
    }

    @Override
    protected Restriction newSliceRestriction(TableMetadata table, VariableSpecifications boundNames, Bound bound, boolean inclusive) {
        List<ColumnMetadata> columnDefs = this.getColumnDefinitions(table);
        Term term = this.toTerm(TokenRelation.toReceivers(table, columnDefs), this.value, table.keyspace, boundNames);
        return new TokenRestriction.SliceRestriction(table, columnDefs, bound, inclusive, term);
    }

    @Override
    protected Restriction newContainsRestriction(TableMetadata table, VariableSpecifications boundNames, boolean isKey) {
        throw RequestValidations.invalidRequest("%s cannot be used with the token function", new Object[]{this.operator()});
    }

    @Override
    protected Restriction newIsNotRestriction(TableMetadata table, VariableSpecifications boundNames) {
        throw RequestValidations.invalidRequest("%s cannot be used with the token function", new Object[]{this.operator()});
    }

    @Override
    protected Restriction newLikeRestriction(TableMetadata table, VariableSpecifications boundNames, Operator operator) {
        throw RequestValidations.invalidRequest("%s cannot be used with the token function", new Object[]{operator});
    }

    @Override
    protected Term toTerm(List<? extends ColumnSpecification> receivers, Term.Raw raw, String keyspace, VariableSpecifications boundNames) throws InvalidRequestException {
        Term term = raw.prepare(keyspace, receivers.get(0));
        term.collectMarkerSpecification(boundNames);
        return term;
    }

    @Override
    public Relation renameIdentifier(ColumnIdentifier from, ColumnIdentifier to) {
        if (!this.entities.contains(from)) {
            return this;
        }
        List<ColumnIdentifier> newEntities = this.entities.stream().map(e -> e.equals(from) ? to : e).collect(Collectors.toList());
        return new TokenRelation(newEntities, this.operator(), this.value);
    }

    public String toString() {
        return String.format("token%s %s %s", new Object[]{Tuples.tupleToString(this.entities), this.relationType, this.value});
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.relationType, this.entities, this.value});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TokenRelation)) {
            return false;
        }
        TokenRelation tr = (TokenRelation)o;
        return this.relationType.equals((Object)tr.relationType) && this.entities.equals(tr.entities) && this.value.equals(tr.value);
    }

    private List<ColumnMetadata> getColumnDefinitions(TableMetadata table) {
        ArrayList<ColumnMetadata> columnDefs = new ArrayList<ColumnMetadata>(this.entities.size());
        for (ColumnIdentifier id : this.entities) {
            columnDefs.add(table.getExistingColumn(id));
        }
        return columnDefs;
    }

    private static List<? extends ColumnSpecification> toReceivers(TableMetadata table, List<ColumnMetadata> columnDefs) throws InvalidRequestException {
        if (!columnDefs.equals(table.partitionKeyColumns())) {
            RequestValidations.checkTrue(columnDefs.containsAll((Collection<?>)table.partitionKeyColumns()), "The token() function must be applied to all partition key components or none of them");
            RequestValidations.checkContainsNoDuplicates(columnDefs, "The token() function contains duplicate partition key components");
            RequestValidations.checkContainsOnly(columnDefs, table.partitionKeyColumns(), "The token() function must contains only partition key components");
            throw RequestValidations.invalidRequest("The token function arguments must be in the partition key order: %s", Joiner.on((String)", ").join(ColumnMetadata.toIdentifiers(table.partitionKeyColumns())));
        }
        ColumnMetadata firstColumn = columnDefs.get(0);
        return Collections.singletonList(new ColumnSpecification(firstColumn.ksName, firstColumn.cfName, new ColumnIdentifier("partition key token", true), table.partitioner.getTokenValidator()));
    }
}

