/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool.stats;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import org.apache.cassandra.tools.nodetool.stats.StatsPrinter;
import org.apache.cassandra.tools.nodetool.stats.TpStatsHolder;

public class TpStatsPrinter {
    public static StatsPrinter from(String format) {
        switch (format) {
            case "json": {
                return new StatsPrinter.JsonPrinter();
            }
            case "yaml": {
                return new StatsPrinter.YamlPrinter();
            }
        }
        return new DefaultPrinter();
    }

    public static class DefaultPrinter
    implements StatsPrinter<TpStatsHolder> {
        @Override
        public void print(TpStatsHolder data, PrintStream out) {
            Map<String, Object> convertData = data.convert2Map();
            out.printf("%-30s%10s%10s%15s%10s%18s%n", "Pool Name", "Active", "Pending", "Completed", "Blocked", "All time blocked");
            Map threadPools = convertData.get("ThreadPools") instanceof Map ? (Map)convertData.get("ThreadPools") : Collections.emptyMap();
            for (Map.Entry entry : threadPools.entrySet()) {
                Map values = entry.getValue() instanceof Map ? (Map)entry.getValue() : Collections.emptyMap();
                out.printf("%-30s%10s%10s%15s%10s%18s%n", entry.getKey(), values.get("ActiveTasks"), values.get("PendingTasks"), values.get("CompletedTasks"), values.get("CurrentlyBlockedTasks"), values.get("TotalBlockedTasks"));
            }
            out.printf("%n%-20s%10s%18s%18s%18s%18s%n", "Message type", "Dropped", "", "Latency waiting in queue (micros)", "", "");
            out.printf("%-20s%10s%18s%18s%18s%18s%n", "", "", "50%", "95%", "99%", "Max");
            Map droppedMessages = convertData.get("DroppedMessage") instanceof Map ? (Map)convertData.get("DroppedMessage") : Collections.emptyMap();
            Map waitLatencies = convertData.get("WaitLatencies") instanceof Map ? (Map)convertData.get("WaitLatencies") : Collections.emptyMap();
            for (Map.Entry entry : droppedMessages.entrySet()) {
                out.printf("%-20s%10s", entry.getKey(), entry.getValue());
                if (waitLatencies.containsKey(entry.getKey())) {
                    double[] latencies = (double[])waitLatencies.get(entry.getKey());
                    out.printf("%18.2f%18.2f%18.2f%18.2f", latencies[0], latencies[2], latencies[4], latencies[6]);
                } else {
                    out.printf("%18s%18s%18s%18s", "N/A", "N/A", "N/A", "N/A");
                }
                out.printf("%n", new Object[0]);
            }
        }
    }
}

