/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.streaming.IncomingStream;
import org.apache.cassandra.streaming.StreamReceiver;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamTask;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamReceiveTask
extends StreamTask {
    private static final Logger logger = LoggerFactory.getLogger(StreamReceiveTask.class);
    private static final ExecutorService executor = Executors.newCachedThreadPool(new NamedThreadFactory("StreamReceiveTask"));
    private final StreamReceiver receiver;
    private final int totalStreams;
    private final long totalSize;
    private volatile boolean done = false;
    private int remoteStreamsReceived = 0;
    private long bytesReceived = 0L;

    public StreamReceiveTask(StreamSession session, TableId tableId, int totalStreams, long totalSize) {
        super(session, tableId);
        this.receiver = ColumnFamilyStore.getIfExists(tableId).getStreamManager().createStreamReceiver(session, totalStreams);
        this.totalStreams = totalStreams;
        this.totalSize = totalSize;
    }

    public synchronized void received(IncomingStream stream) {
        Preconditions.checkState((!this.session.isPreview() ? 1 : 0) != 0, (Object)"we should never receive sstables when previewing");
        if (this.done) {
            logger.warn("[{}] Received stream {} on already finished stream received task. Aborting stream.", (Object)this.session.planId(), (Object)stream.getName());
            this.receiver.discardStream(stream);
            return;
        }
        this.remoteStreamsReceived += stream.getNumFiles();
        this.bytesReceived += stream.getSize();
        Preconditions.checkArgument((boolean)this.tableId.equals(stream.getTableId()));
        logger.debug("received {} of {} total files {} of total bytes {}", new Object[]{this.remoteStreamsReceived, this.totalStreams, this.bytesReceived, this.totalSize});
        this.receiver.received(stream);
        if (this.remoteStreamsReceived == this.totalStreams) {
            this.done = true;
            executor.submit(new OnCompletionRunnable(this));
        }
    }

    @Override
    public int getTotalNumberOfFiles() {
        return this.totalStreams;
    }

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    public synchronized StreamReceiver getReceiver() {
        if (this.done) {
            throw new RuntimeException(String.format("Stream receive task %s of cf %s already finished.", this.session.planId(), this.tableId));
        }
        return this.receiver;
    }

    @Override
    public synchronized void abort() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.receiver.abort();
    }

    @VisibleForTesting
    public static void shutdownAndWait(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        ExecutorUtils.shutdown(executor);
        ExecutorUtils.awaitTermination(timeout, unit, executor);
    }

    private static class OnCompletionRunnable
    implements Runnable {
        private final StreamReceiveTask task;

        public OnCompletionRunnable(StreamReceiveTask task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                if (ColumnFamilyStore.getIfExists(this.task.tableId) == null) {
                    this.task.receiver.abort();
                    this.task.session.taskCompleted(this.task);
                    return;
                }
                this.task.receiver.finished();
                this.task.session.taskCompleted(this.task);
            }
            catch (Throwable t) {
                JVMStabilityInspector.inspectThrowable(t);
                this.task.session.onError(t);
            }
            finally {
                this.task.receiver.cleanup();
            }
        }
    }
}

