/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.marshal.EmptyType;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class CompactTables {
    public static final ByteBuffer SUPER_COLUMN_MAP_COLUMN = ByteBufferUtil.EMPTY_BYTE_BUFFER;

    private CompactTables() {
    }

    public static ColumnMetadata getCompactValueColumn(RegularAndStaticColumns columns, boolean isSuper) {
        if (isSuper) {
            for (ColumnMetadata column : columns.regulars) {
                if (!column.name.bytes.equals(SUPER_COLUMN_MAP_COLUMN)) continue;
                return column;
            }
            throw new AssertionError((Object)"Invalid super column table definition, no 'dynamic' map column");
        }
        assert (columns.regulars.simpleColumnCount() == 1 && columns.regulars.complexColumnCount() == 0);
        return columns.regulars.getSimple(0);
    }

    public static boolean hasEmptyCompactValue(TableMetadata metadata) {
        return metadata.compactValueColumn.type instanceof EmptyType;
    }

    public static boolean isSuperColumnMapColumn(ColumnMetadata column) {
        return column.kind == ColumnMetadata.Kind.REGULAR && column.name.bytes.equals(SUPER_COLUMN_MAP_COLUMN);
    }

    public static DefaultNames defaultNameGenerator(Set<String> usedNames) {
        return new DefaultNames(new HashSet<String>(usedNames));
    }

    public static class DefaultNames {
        private static final String DEFAULT_CLUSTERING_NAME = "column";
        private static final String DEFAULT_COMPACT_VALUE_NAME = "value";
        private final Set<String> usedNames;
        private int clusteringIndex = 1;
        private int compactIndex = 0;

        private DefaultNames(Set<String> usedNames) {
            this.usedNames = usedNames;
        }

        public String defaultClusteringName() {
            String candidate;
            do {
                candidate = DEFAULT_CLUSTERING_NAME + this.clusteringIndex;
                ++this.clusteringIndex;
            } while (!this.usedNames.add(candidate));
            return candidate;
        }

        public String defaultCompactValueName() {
            String candidate;
            do {
                candidate = this.compactIndex == 0 ? DEFAULT_COMPACT_VALUE_NAME : DEFAULT_COMPACT_VALUE_NAME + this.compactIndex;
                ++this.compactIndex;
            } while (!this.usedNames.add(candidate));
            return candidate;
        }
    }
}

