/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import org.antlr.runtime.RecognitionException;
import org.apache.cassandra.cql3.CQLFragmentParser;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.restrictions.CustomIndexExpression;
import org.apache.cassandra.schema.ColumnMetadata;

public final class WhereClause {
    private static final WhereClause EMPTY = new WhereClause(new Builder());
    public final List<Relation> relations;
    public final List<CustomIndexExpression> expressions;

    private WhereClause(Builder builder) {
        this.relations = builder.relations.build();
        this.expressions = builder.expressions.build();
    }

    public static WhereClause empty() {
        return EMPTY;
    }

    public boolean containsCustomExpressions() {
        return !this.expressions.isEmpty();
    }

    public WhereClause renameIdentifier(ColumnMetadata.Raw from, ColumnMetadata.Raw to) {
        Builder builder = new Builder();
        this.relations.stream().map(r -> r.renameIdentifier(from, to)).forEach(builder::add);
        this.expressions.forEach(builder::add);
        return builder.build();
    }

    public static WhereClause parse(String cql) throws RecognitionException {
        return CQLFragmentParser.parseAnyUnhandled(CqlParser::whereClause, cql).build();
    }

    public String toString() {
        return String.join((CharSequence)" AND ", Iterables.concat((Iterable)Iterables.transform(this.relations, Object::toString), (Iterable)Iterables.transform(this.expressions, CustomIndexExpression::toString)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WhereClause)) {
            return false;
        }
        WhereClause wc = (WhereClause)o;
        return this.relations.equals(wc.relations) && this.expressions.equals(wc.expressions);
    }

    public int hashCode() {
        return Objects.hash(this.relations, this.expressions);
    }

    public static final class Builder {
        ImmutableList.Builder<Relation> relations = new ImmutableList.Builder();
        ImmutableList.Builder<CustomIndexExpression> expressions = new ImmutableList.Builder();

        public Builder add(Relation relation) {
            this.relations.add((Object)relation);
            return this;
        }

        public Builder add(CustomIndexExpression expression) {
            this.expressions.add((Object)expression);
            return this;
        }

        public WhereClause build() {
            return new WhereClause(this);
        }
    }
}

