/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.lang.management.MemoryUsage;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.CacheServiceMBean;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="info", description="Print node information (uptime, load, ...)")
public class Info
extends NodeTool.NodeToolCmd {
    @Option(name={"-T", "--tokens"}, description="Display all tokens")
    private boolean tokens = false;

    @Override
    public void execute(NodeProbe probe) {
        block12: {
            block11: {
                boolean gossipInitialized = probe.isGossipRunning();
                System.out.printf("%-23s: %s%n", "ID", probe.getLocalHostId());
                System.out.printf("%-23s: %s%n", "Gossip active", gossipInitialized);
                System.out.printf("%-23s: %s%n", "Native Transport active", probe.isNativeTransportRunning());
                System.out.printf("%-23s: %s%n", "Load", probe.getLoadString());
                if (gossipInitialized) {
                    System.out.printf("%-23s: %s%n", "Generation No", probe.getCurrentGenerationNumber());
                } else {
                    System.out.printf("%-23s: %s%n", "Generation No", 0);
                }
                long secondsUp = probe.getUptime() / 1000L;
                System.out.printf("%-23s: %d%n", "Uptime (seconds)", secondsUp);
                MemoryUsage heapUsage = probe.getHeapMemoryUsage();
                double memUsed = (double)heapUsage.getUsed() / 1048576.0;
                double memMax = (double)heapUsage.getMax() / 1048576.0;
                System.out.printf("%-23s: %.2f / %.2f%n", "Heap Memory (MB)", memUsed, memMax);
                try {
                    System.out.printf("%-23s: %.2f%n", "Off Heap Memory (MB)", Info.getOffHeapMemoryUsed(probe));
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof InstanceNotFoundException) break block11;
                    throw e;
                }
            }
            System.out.printf("%-23s: %s%n", "Data Center", probe.getDataCenter());
            System.out.printf("%-23s: %s%n", "Rack", probe.getRack());
            System.out.printf("%-23s: %s%n", "Exceptions", probe.getStorageMetric("Exceptions"));
            CacheServiceMBean cacheService = probe.getCacheServiceMBean();
            System.out.printf("%-23s: entries %d, size %s, capacity %s, %d hits, %d requests, %.3f recent hit rate, %d save period in seconds%n", "Key Cache", probe.getCacheMetric("KeyCache", "Entries"), FileUtils.stringifyFileSize(((Long)probe.getCacheMetric("KeyCache", "Size")).longValue()), FileUtils.stringifyFileSize(((Long)probe.getCacheMetric("KeyCache", "Capacity")).longValue()), probe.getCacheMetric("KeyCache", "Hits"), probe.getCacheMetric("KeyCache", "Requests"), probe.getCacheMetric("KeyCache", "HitRate"), cacheService.getKeyCacheSavePeriodInSeconds());
            System.out.printf("%-23s: entries %d, size %s, capacity %s, %d hits, %d requests, %.3f recent hit rate, %d save period in seconds%n", "Row Cache", probe.getCacheMetric("RowCache", "Entries"), FileUtils.stringifyFileSize(((Long)probe.getCacheMetric("RowCache", "Size")).longValue()), FileUtils.stringifyFileSize(((Long)probe.getCacheMetric("RowCache", "Capacity")).longValue()), probe.getCacheMetric("RowCache", "Hits"), probe.getCacheMetric("RowCache", "Requests"), probe.getCacheMetric("RowCache", "HitRate"), cacheService.getRowCacheSavePeriodInSeconds());
            System.out.printf("%-23s: entries %d, size %s, capacity %s, %d hits, %d requests, %.3f recent hit rate, %d save period in seconds%n", "Counter Cache", probe.getCacheMetric("CounterCache", "Entries"), FileUtils.stringifyFileSize(((Long)probe.getCacheMetric("CounterCache", "Size")).longValue()), FileUtils.stringifyFileSize(((Long)probe.getCacheMetric("CounterCache", "Capacity")).longValue()), probe.getCacheMetric("CounterCache", "Hits"), probe.getCacheMetric("CounterCache", "Requests"), probe.getCacheMetric("CounterCache", "HitRate"), cacheService.getCounterCacheSavePeriodInSeconds());
            try {
                System.out.printf("%-23s: entries %d, size %s, capacity %s, %d misses, %d requests, %.3f recent hit rate, %.3f %s miss latency%n", "Chunk Cache", probe.getCacheMetric("ChunkCache", "Entries"), FileUtils.stringifyFileSize(((Long)probe.getCacheMetric("ChunkCache", "Size")).longValue()), FileUtils.stringifyFileSize(((Long)probe.getCacheMetric("ChunkCache", "Capacity")).longValue()), probe.getCacheMetric("ChunkCache", "Misses"), probe.getCacheMetric("ChunkCache", "Requests"), probe.getCacheMetric("ChunkCache", "HitRate"), probe.getCacheMetric("ChunkCache", "MissLatency"), probe.getCacheMetric("ChunkCache", "MissLatencyUnit"));
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof InstanceNotFoundException) break block12;
                throw e;
            }
        }
        System.out.printf("%-23s: %s%%%n", "Percent Repaired", probe.getColumnFamilyMetric(null, null, "PercentRepaired"));
        if (probe.isJoined()) {
            List<String> tokens = probe.getTokens();
            if (tokens.size() == 1 || this.tokens) {
                for (String token : tokens) {
                    System.out.printf("%-23s: %s%n", "Token", token);
                }
            } else {
                System.out.printf("%-23s: (invoke with -T/--tokens to see all %d tokens)%n", "Token", tokens.size());
            }
        } else {
            System.out.printf("%-23s: (node is not joined to the cluster)%n", "Token");
        }
    }

    private static double getOffHeapMemoryUsed(NodeProbe probe) {
        long offHeapMemUsedInBytes = 0L;
        Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> cfamilies = probe.getColumnFamilyStoreMBeanProxies();
        while (cfamilies.hasNext()) {
            Map.Entry<String, ColumnFamilyStoreMBean> entry = cfamilies.next();
            String keyspaceName = entry.getKey();
            String cfName = entry.getValue().getTableName();
            offHeapMemUsedInBytes += ((Long)probe.getColumnFamilyMetric(keyspaceName, cfName, "MemtableOffHeapSize")).longValue();
            offHeapMemUsedInBytes += ((Long)probe.getColumnFamilyMetric(keyspaceName, cfName, "BloomFilterOffHeapMemoryUsed")).longValue();
            offHeapMemUsedInBytes += ((Long)probe.getColumnFamilyMetric(keyspaceName, cfName, "IndexSummaryOffHeapMemoryUsed")).longValue();
            offHeapMemUsedInBytes += ((Long)probe.getColumnFamilyMetric(keyspaceName, cfName, "CompressionMetadataOffHeapMemoryUsed")).longValue();
        }
        return (double)offHeapMemUsedInBytes / 1048576.0;
    }
}

