/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.repair;

import com.carrotsearch.hppc.ObjectIntHashMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.function.Consumer;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowDiffListener;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.locator.AbstractReplicaCollection;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.locator.ReplicaPlans;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.service.reads.repair.BlockingReadRepairs;
import org.apache.cassandra.service.reads.repair.ReadRepair;

public class RowIteratorMergeListener<E extends Endpoints<E>>
implements UnfilteredRowIterators.MergeListener {
    private final DecoratedKey partitionKey;
    private final RegularAndStaticColumns columns;
    private final boolean isReversed;
    private final ReadCommand command;
    private final BitSet writeBackTo;
    private final boolean buildFullDiff;
    private final PartitionUpdate.Builder[] repairs;
    private final Row.Builder[] currentRows;
    private final RowDiffListener diffListener;
    private final ReplicaPlan.ForRead<E> readPlan;
    private final ReplicaPlan.ForTokenWrite writePlan;
    private DeletionTime partitionLevelDeletion;
    private DeletionTime mergedDeletionTime;
    private final DeletionTime[] sourceDeletionTime;
    private final ClusteringBound[] markerToRepair;
    private final ReadRepair readRepair;

    public RowIteratorMergeListener(DecoratedKey partitionKey, RegularAndStaticColumns columns, boolean isReversed, ReplicaPlan.ForRead<E> readPlan, ReadCommand command, ReadRepair readRepair) {
        this.partitionKey = partitionKey;
        this.columns = columns;
        this.isReversed = isReversed;
        this.readPlan = readPlan;
        this.writePlan = ReplicaPlans.forReadRepair(partitionKey.getToken(), readPlan);
        int size = ((AbstractReplicaCollection)readPlan.contacts()).size();
        this.writeBackTo = new BitSet(size);
        int i = 0;
        for (Replica replica : readPlan.contacts()) {
            if (((EndpointsForToken)this.writePlan.contacts()).endpoints().contains(replica.endpoint())) {
                this.writeBackTo.set(i);
            }
            ++i;
        }
        this.buildFullDiff = Iterables.any(((EndpointsForToken)this.writePlan.contacts()).endpoints(), e -> !((Endpoints)readPlan.contacts()).endpoints().contains(e));
        this.repairs = new PartitionUpdate.Builder[size + (this.buildFullDiff ? 1 : 0)];
        this.currentRows = new Row.Builder[size];
        this.sourceDeletionTime = new DeletionTime[size];
        this.markerToRepair = new ClusteringBound[size];
        this.command = command;
        this.readRepair = readRepair;
        this.diffListener = new RowDiffListener(){

            @Override
            public void onPrimaryKeyLivenessInfo(int i, Clustering clustering, LivenessInfo merged, LivenessInfo original) {
                if (merged != null && !merged.equals(original)) {
                    RowIteratorMergeListener.this.currentRow(i, clustering).addPrimaryKeyLivenessInfo(merged);
                }
            }

            @Override
            public void onDeletion(int i, Clustering clustering, Row.Deletion merged, Row.Deletion original) {
                if (merged != null && !merged.equals(original)) {
                    RowIteratorMergeListener.this.currentRow(i, clustering).addRowDeletion(merged);
                }
            }

            @Override
            public void onComplexDeletion(int i, Clustering clustering, ColumnMetadata column, DeletionTime merged, DeletionTime original) {
                if (merged != null && !merged.equals(original)) {
                    RowIteratorMergeListener.this.currentRow(i, clustering).addComplexDeletion(column, merged);
                }
            }

            @Override
            public void onCell(int i, Clustering clustering, Cell merged, Cell original) {
                if (merged != null && !merged.equals(original) && this.isQueried(merged)) {
                    RowIteratorMergeListener.this.currentRow(i, clustering).addCell(merged);
                }
            }

            private boolean isQueried(Cell cell) {
                ColumnMetadata column = cell.column();
                ColumnFilter filter = RowIteratorMergeListener.this.command.columnFilter();
                return column.isComplex() ? filter.fetchedCellIsQueried(column, cell.path()) : filter.fetchedColumnIsQueried(column);
            }
        };
    }

    private DeletionTime partitionLevelRepairDeletion(int i) {
        return this.repairs[i] == null ? DeletionTime.LIVE : this.repairs[i].partitionLevelDeletion();
    }

    private Row.Builder currentRow(int i, Clustering clustering) {
        if (this.currentRows[i] == null) {
            this.currentRows[i] = BTreeRow.sortedBuilder();
            this.currentRows[i].newRow(clustering);
        }
        return this.currentRows[i];
    }

    private void applyToPartition(int i, Consumer<PartitionUpdate.Builder> f) {
        if (this.writeBackTo.get(i)) {
            if (this.repairs[i] == null) {
                this.repairs[i] = new PartitionUpdate.Builder(this.command.metadata(), this.partitionKey, this.columns, 1);
            }
            f.accept(this.repairs[i]);
        }
        if (this.buildFullDiff) {
            if (this.repairs[this.repairs.length - 1] == null) {
                this.repairs[this.repairs.length - 1] = new PartitionUpdate.Builder(this.command.metadata(), this.partitionKey, this.columns, 1);
            }
            f.accept(this.repairs[this.repairs.length - 1]);
        }
    }

    @Override
    public void onMergedPartitionLevelDeletion(DeletionTime mergedDeletion, DeletionTime[] versions) {
        this.partitionLevelDeletion = mergedDeletion;
        for (int i = 0; i < versions.length; ++i) {
            if (!mergedDeletion.supersedes(versions[i])) continue;
            this.applyToPartition(i, p -> p.addPartitionDeletion(mergedDeletion));
        }
    }

    @Override
    public void onMergedRows(Row merged, Row[] versions) {
        if (merged.isEmpty()) {
            return;
        }
        Rows.diff(this.diffListener, merged, versions);
        for (int i = 0; i < this.currentRows.length; ++i) {
            if (this.currentRows[i] == null) continue;
            Row row = this.currentRows[i].build();
            this.applyToPartition(i, p -> p.add(row));
        }
        Arrays.fill(this.currentRows, null);
    }

    private DeletionTime currentDeletion() {
        return this.mergedDeletionTime == null ? this.partitionLevelDeletion : this.mergedDeletionTime;
    }

    @Override
    public void onMergedRangeTombstoneMarkers(RangeTombstoneMarker merged, RangeTombstoneMarker[] versions) {
        DeletionTime currentDeletion = this.currentDeletion();
        for (int i = 0; i < versions.length; ++i) {
            DeletionTime sourceDeletion;
            DeletionTime newDeletion;
            RangeTombstoneMarker marker = versions[i];
            if (marker != null) {
                DeletionTime deletionTime = this.sourceDeletionTime[i] = marker.isOpen(this.isReversed) ? marker.openDeletionTime(this.isReversed) : null;
            }
            if (merged == null) {
                if (marker == null) continue;
                assert (!currentDeletion.isLive()) : currentDeletion.toString();
                DeletionTime partitionRepairDeletion = this.partitionLevelRepairDeletion(i);
                if (this.markerToRepair[i] == null && currentDeletion.supersedes(partitionRepairDeletion)) {
                    if (!marker.isBoundary() && marker.isOpen(this.isReversed) ? !$assertionsDisabled && !currentDeletion.equals(marker.openDeletionTime(this.isReversed)) : !$assertionsDisabled && (!marker.isClose(this.isReversed) || !currentDeletion.equals(marker.closeDeletionTime(this.isReversed)))) {
                        throw new AssertionError((Object)String.format("currentDeletion=%s, marker=%s", currentDeletion, marker.toString(this.command.metadata())));
                    }
                    if (marker.isOpen(this.isReversed) && currentDeletion.equals(marker.openDeletionTime(this.isReversed))) continue;
                    this.markerToRepair[i] = marker.closeBound(this.isReversed).invert();
                    continue;
                }
                if (!marker.isOpen(this.isReversed) || !currentDeletion.equals(marker.openDeletionTime(this.isReversed))) continue;
                this.closeOpenMarker(i, marker.openBound(this.isReversed).invert());
                continue;
            }
            if (merged.isClose(this.isReversed) && this.markerToRepair[i] != null) {
                this.closeOpenMarker(i, merged.closeBound(this.isReversed));
            }
            if (!merged.isOpen(this.isReversed) || (newDeletion = merged.openDeletionTime(this.isReversed)).equals(sourceDeletion = this.sourceDeletionTime[i])) continue;
            this.markerToRepair[i] = merged.openBound(this.isReversed);
        }
        if (merged != null) {
            this.mergedDeletionTime = merged.isOpen(this.isReversed) ? merged.openDeletionTime(this.isReversed) : null;
        }
    }

    private void closeOpenMarker(int i, ClusteringBound close) {
        ClusteringBound open = this.markerToRepair[i];
        RangeTombstone rt = new RangeTombstone(Slice.make(this.isReversed ? close : open, this.isReversed ? open : close), this.currentDeletion());
        this.applyToPartition(i, p -> p.add(rt));
        this.markerToRepair[i] = null;
    }

    @Override
    public void close() {
        boolean hasRepairs = false;
        for (int i = 0; !hasRepairs && i < this.repairs.length; ++i) {
            hasRepairs = this.repairs[i] != null;
        }
        if (!hasRepairs) {
            return;
        }
        PartitionUpdate fullDiffRepair = null;
        if (this.buildFullDiff && this.repairs[this.repairs.length - 1] != null) {
            fullDiffRepair = this.repairs[this.repairs.length - 1].build();
        }
        HashMap mutations = Maps.newHashMapWithExpectedSize((int)((EndpointsForToken)this.writePlan.contacts()).size());
        ObjectIntHashMap sourceIds = new ObjectIntHashMap((this.repairs.length + 1) * 4 / 3);
        for (int i = 0; i < ((AbstractReplicaCollection)this.readPlan.contacts()).size(); ++i) {
            sourceIds.put((Object)((AbstractReplicaCollection)this.readPlan.contacts()).get(i).endpoint(), 1 + i);
        }
        for (Replica replica : (EndpointsForToken)this.writePlan.contacts()) {
            PartitionUpdate update = null;
            int i = -1 + sourceIds.get((Object)replica.endpoint());
            if (i < 0) {
                update = fullDiffRepair;
            } else if (this.repairs[i] != null) {
                update = this.repairs[i].build();
            }
            Mutation mutation = BlockingReadRepairs.createRepairMutation(update, this.readPlan.consistencyLevel(), replica.endpoint(), false);
            if (mutation == null) continue;
            mutations.put(replica, mutation);
        }
        this.readRepair.repairPartition(this.partitionKey, mutations, this.writePlan);
    }
}

