/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;

public class ListSerializer<T>
extends CollectionSerializer<List<T>> {
    private static final ConcurrentMap<TypeSerializer<?>, ListSerializer> instances = new ConcurrentHashMap();
    public final TypeSerializer<T> elements;

    public static <T> ListSerializer<T> getInstance(TypeSerializer<T> elements) {
        ListSerializer t = (ListSerializer)instances.get(elements);
        if (t == null) {
            t = instances.computeIfAbsent(elements, k -> new ListSerializer(k));
        }
        return t;
    }

    private ListSerializer(TypeSerializer<T> elements) {
        this.elements = elements;
    }

    @Override
    public List<ByteBuffer> serializeValues(List<T> values) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(values.size());
        for (T value : values) {
            buffers.add(this.elements.serialize(value));
        }
        return buffers;
    }

    @Override
    public int getElementCount(List<T> value) {
        return value.size();
    }

    @Override
    public void validateForNativeProtocol(ByteBuffer bytes, ProtocolVersion version) {
        try {
            ByteBuffer input = bytes.duplicate();
            int n = ListSerializer.readCollectionSize(input, version);
            for (int i = 0; i < n; ++i) {
                this.elements.validate(ListSerializer.readValue(input, version));
            }
            if (input.hasRemaining()) {
                throw new MarshalException("Unexpected extraneous bytes after list value");
            }
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a list");
        }
    }

    @Override
    public List<T> deserializeForNativeProtocol(ByteBuffer bytes, ProtocolVersion version) {
        try {
            ByteBuffer input = bytes.duplicate();
            int n = ListSerializer.readCollectionSize(input, version);
            if (n < 0) {
                throw new MarshalException("The data cannot be deserialized as a list");
            }
            ArrayList<T> l = new ArrayList<T>(Math.min(n, 256));
            for (int i = 0; i < n; ++i) {
                ByteBuffer databb = ListSerializer.readValue(input, version);
                if (databb != null) {
                    this.elements.validate(databb);
                    l.add(this.elements.deserialize(databb));
                    continue;
                }
                l.add(null);
            }
            if (input.hasRemaining()) {
                throw new MarshalException("Unexpected extraneous bytes after list value");
            }
            return l;
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a list");
        }
    }

    public ByteBuffer getElement(ByteBuffer serializedList, int index) {
        try {
            ByteBuffer input = serializedList.duplicate();
            int n = ListSerializer.readCollectionSize(input, ProtocolVersion.V3);
            if (n <= index) {
                return null;
            }
            for (int i = 0; i < index; ++i) {
                int length = input.getInt();
                input.position(input.position() + length);
            }
            return ListSerializer.readValue(input, ProtocolVersion.V3);
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a list");
        }
    }

    @Override
    public String toString(List<T> value) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        sb.append('[');
        for (T element : value) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.elements.toString(element));
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Class<List<T>> getType() {
        return List.class;
    }

    @Override
    public ByteBuffer getSerializedValue(ByteBuffer collection, ByteBuffer key, AbstractType<?> comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer getSliceFromSerialized(ByteBuffer collection, ByteBuffer from, ByteBuffer to, AbstractType<?> comparator, boolean frozen) {
        throw new UnsupportedOperationException();
    }
}

