/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.asymmetric;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.asymmetric.DifferenceHolder;
import org.apache.cassandra.repair.asymmetric.HostDifferences;
import org.apache.cassandra.repair.asymmetric.IncomingRepairStreamTracker;
import org.apache.cassandra.repair.asymmetric.PreferedNodeFilter;
import org.apache.cassandra.repair.asymmetric.StreamFromOptions;

public class ReduceHelper {
    public static ImmutableMap<InetAddressAndPort, HostDifferences> reduce(DifferenceHolder differences, PreferedNodeFilter filter) {
        Map<InetAddressAndPort, IncomingRepairStreamTracker> trackers = ReduceHelper.createIncomingRepairStreamTrackers(differences);
        HashMap<InetAddressAndPort, Integer> outgoingStreamCounts = new HashMap<InetAddressAndPort, Integer>();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry<InetAddressAndPort, IncomingRepairStreamTracker> trackerEntry : trackers.entrySet()) {
            IncomingRepairStreamTracker tracker = trackerEntry.getValue();
            HostDifferences rangesToFetch = new HostDifferences();
            for (Map.Entry entry : tracker.getIncoming().entrySet()) {
                Range rangeToFetch = (Range)entry.getKey();
                for (InetAddressAndPort remoteNode : ReduceHelper.pickLeastStreaming(trackerEntry.getKey(), (StreamFromOptions)entry.getValue(), outgoingStreamCounts, filter)) {
                    rangesToFetch.addSingleRange(remoteNode, rangeToFetch);
                }
            }
            mapBuilder.put((Object)trackerEntry.getKey(), (Object)rangesToFetch);
        }
        return mapBuilder.build();
    }

    @VisibleForTesting
    static Map<InetAddressAndPort, IncomingRepairStreamTracker> createIncomingRepairStreamTrackers(DifferenceHolder differences) {
        HashMap<InetAddressAndPort, IncomingRepairStreamTracker> trackers = new HashMap<InetAddressAndPort, IncomingRepairStreamTracker>();
        for (InetAddressAndPort hostWithDifference : differences.keyHosts()) {
            HostDifferences hostDifferences = differences.get(hostWithDifference);
            for (InetAddressAndPort differingHost : hostDifferences.hosts()) {
                List<Range<Token>> differingRanges = hostDifferences.get(differingHost);
                for (Range<Token> range : differingRanges) {
                    ReduceHelper.getTracker(differences, trackers, hostWithDifference).addIncomingRangeFrom(range, differingHost);
                    ReduceHelper.getTracker(differences, trackers, differingHost).addIncomingRangeFrom(range, hostWithDifference);
                }
            }
        }
        return trackers;
    }

    private static IncomingRepairStreamTracker getTracker(DifferenceHolder differences, Map<InetAddressAndPort, IncomingRepairStreamTracker> trackers, InetAddressAndPort host) {
        return trackers.computeIfAbsent(host, h -> new IncomingRepairStreamTracker(differences));
    }

    private static Collection<InetAddressAndPort> pickLeastStreaming(InetAddressAndPort streamingNode, StreamFromOptions toStreamFrom, Map<InetAddressAndPort, Integer> outgoingStreamCounts, PreferedNodeFilter filter) {
        HashSet<InetAddressAndPort> retSet = new HashSet<InetAddressAndPort>();
        for (Set<InetAddressAndPort> toStream : toStreamFrom.allStreams()) {
            InetAddressAndPort candidate = null;
            Set<InetAddressAndPort> prefered = filter.apply(streamingNode, toStream);
            for (InetAddressAndPort node : prefered) {
                if (candidate != null && outgoingStreamCounts.getOrDefault(candidate, 0) <= outgoingStreamCounts.getOrDefault(node, 0)) continue;
                candidate = node;
            }
            if (candidate == null) {
                for (InetAddressAndPort node : toStream) {
                    if (candidate != null && outgoingStreamCounts.getOrDefault(candidate, 0) <= outgoingStreamCounts.getOrDefault(node, 0)) continue;
                    candidate = node;
                }
            }
            assert (candidate != null);
            outgoingStreamCounts.put(candidate, outgoingStreamCounts.getOrDefault(candidate, 0) + 1);
            retSet.add(candidate);
        }
        return retSet;
    }
}

