/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.asymmetric;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;

public class HostDifferences {
    private final Map<InetAddressAndPort, List<Range<Token>>> perHostDifferences = new HashMap<InetAddressAndPort, List<Range<Token>>>();

    public void add(InetAddressAndPort endpoint, List<Range<Token>> difference) {
        this.perHostDifferences.put(endpoint, difference);
    }

    public void addSingleRange(InetAddressAndPort remoteNode, Range<Token> rangeToFetch) {
        this.perHostDifferences.computeIfAbsent(remoteNode, x -> new ArrayList()).add(rangeToFetch);
    }

    public boolean hasDifferencesFor(InetAddressAndPort node2, Range<Token> range) {
        List<Range<Token>> differences = this.get(node2);
        for (Range<Token> diff : differences) {
            if (!range.equals(diff) && !range.intersects(diff)) continue;
            return true;
        }
        return false;
    }

    public Set<InetAddressAndPort> hosts() {
        return this.perHostDifferences.keySet();
    }

    public List<Range<Token>> get(InetAddressAndPort differingHost) {
        return this.perHostDifferences.getOrDefault(differingHost, Collections.emptyList());
    }

    public String toString() {
        return "HostDifferences{perHostDifferences=" + this.perHostDifferences + '}';
    }
}

