/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;

public class CommonRange {
    public final ImmutableSet<InetAddressAndPort> endpoints;
    public final ImmutableSet<InetAddressAndPort> transEndpoints;
    public final Collection<Range<Token>> ranges;

    public CommonRange(Set<InetAddressAndPort> endpoints, Set<InetAddressAndPort> transEndpoints, Collection<Range<Token>> ranges) {
        Preconditions.checkArgument((endpoints != null && !endpoints.isEmpty() ? 1 : 0) != 0, (Object)"Endpoints can not be empty");
        Preconditions.checkArgument((transEndpoints != null ? 1 : 0) != 0, (Object)"Transient endpoints can not be null");
        Preconditions.checkArgument((boolean)endpoints.containsAll(transEndpoints), (Object)"transEndpoints must be a subset of endpoints");
        Preconditions.checkArgument((ranges != null && !ranges.isEmpty() ? 1 : 0) != 0, (Object)"Ranges can not be empty");
        this.endpoints = ImmutableSet.copyOf(endpoints);
        this.transEndpoints = ImmutableSet.copyOf(transEndpoints);
        this.ranges = new ArrayList<Range<Token>>(ranges);
    }

    public boolean matchesEndpoints(Set<InetAddressAndPort> endpoints, Set<InetAddressAndPort> transEndpoints) {
        return this.endpoints.equals(endpoints) && this.transEndpoints.equals(transEndpoints);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonRange that = (CommonRange)o;
        if (!this.endpoints.equals(that.endpoints)) {
            return false;
        }
        if (!this.transEndpoints.equals(that.transEndpoints)) {
            return false;
        }
        return this.ranges.equals(that.ranges);
    }

    public int hashCode() {
        int result = this.endpoints.hashCode();
        result = 31 * result + this.transEndpoints.hashCode();
        result = 31 * result + this.ranges.hashCode();
        return result;
    }

    public String toString() {
        return "CommonRange{endpoints=" + this.endpoints + ", transEndpoints=" + this.transEndpoints + ", ranges=" + this.ranges + '}';
    }
}

