/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.BackPressureStrategy;
import org.apache.cassandra.net.RateBasedBackPressureState;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.SystemTimeSource;
import org.apache.cassandra.utils.TimeSource;
import org.apache.cassandra.utils.concurrent.IntervalLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateBasedBackPressure
implements BackPressureStrategy<RateBasedBackPressureState> {
    static final String HIGH_RATIO = "high_ratio";
    static final String FACTOR = "factor";
    static final String FLOW = "flow";
    private static final String BACK_PRESSURE_HIGH_RATIO = "0.90";
    private static final String BACK_PRESSURE_FACTOR = "5";
    private static final String BACK_PRESSURE_FLOW = "FAST";
    private static final Logger logger = LoggerFactory.getLogger(RateBasedBackPressure.class);
    private static final NoSpamLogger tenSecsNoSpamLogger = NoSpamLogger.getLogger(logger, 10L, TimeUnit.SECONDS);
    private static final NoSpamLogger oneMinNoSpamLogger = NoSpamLogger.getLogger(logger, 1L, TimeUnit.MINUTES);
    protected final TimeSource timeSource;
    protected final double highRatio;
    protected final int factor;
    protected final Flow flow;
    protected final long windowSize;
    private final Cache<Set<RateBasedBackPressureState>, IntervalRateLimiter> rateLimiters = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).executor(MoreExecutors.directExecutor()).build();

    public static ParameterizedClass withDefaultParams() {
        return new ParameterizedClass(RateBasedBackPressure.class.getName(), (Map<String, String>)ImmutableMap.of((Object)HIGH_RATIO, (Object)BACK_PRESSURE_HIGH_RATIO, (Object)FACTOR, (Object)BACK_PRESSURE_FACTOR, (Object)FLOW, (Object)BACK_PRESSURE_FLOW));
    }

    public RateBasedBackPressure(Map<String, Object> args) {
        this(args, new SystemTimeSource(), DatabaseDescriptor.getWriteRpcTimeout(TimeUnit.MILLISECONDS));
    }

    @VisibleForTesting
    public RateBasedBackPressure(Map<String, Object> args, TimeSource timeSource, long windowSize) {
        if (args.size() != 3) {
            throw new IllegalArgumentException(RateBasedBackPressure.class.getCanonicalName() + " requires 3 arguments: high ratio, back-pressure factor and flow type.");
        }
        try {
            this.highRatio = Double.parseDouble(args.getOrDefault(HIGH_RATIO, "").toString().trim());
            this.factor = Integer.parseInt(args.getOrDefault(FACTOR, "").toString().trim());
            this.flow = Flow.valueOf(args.getOrDefault(FLOW, "").toString().trim().toUpperCase());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        if (this.highRatio <= 0.0 || this.highRatio > 1.0) {
            throw new IllegalArgumentException("Back-pressure high ratio must be > 0 and <= 1");
        }
        if (this.factor < 1) {
            throw new IllegalArgumentException("Back-pressure factor must be >= 1");
        }
        if (windowSize < 10L) {
            throw new IllegalArgumentException("Back-pressure window size must be >= 10");
        }
        this.timeSource = timeSource;
        this.windowSize = windowSize;
        logger.info("Initialized back-pressure with high ratio: {}, factor: {}, flow: {}, window size: {}.", new Object[]{this.highRatio, this.factor, this.flow, windowSize});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Set<RateBasedBackPressureState> states, long timeout, TimeUnit unit) {
        boolean isUpdated = false;
        double minRateLimit = Double.POSITIVE_INFINITY;
        double maxRateLimit = Double.NEGATIVE_INFINITY;
        double minIncomingRate = Double.POSITIVE_INFINITY;
        RateLimiter currentMin = null;
        RateLimiter currentMax = null;
        for (RateBasedBackPressureState backPressure : states) {
            double incomingRate = backPressure.incomingRate.get(TimeUnit.SECONDS);
            double outgoingRate = backPressure.outgoingRate.get(TimeUnit.SECONDS);
            if (incomingRate < minIncomingRate) {
                minIncomingRate = incomingRate;
            }
            if (backPressure.tryIntervalLock(this.windowSize)) {
                isUpdated = true;
                try {
                    RateLimiter limiter = backPressure.rateLimiter;
                    if (outgoingRate > 0.0) {
                        double newRate;
                        double actualRatio = incomingRate / outgoingRate;
                        double limiterRate = limiter.getRate();
                        if (actualRatio >= this.highRatio) {
                            if (limiterRate <= outgoingRate && (newRate = limiterRate + limiterRate * (double)this.factor / 100.0) > 0.0 && newRate != Double.POSITIVE_INFINITY) {
                                limiter.setRate(newRate);
                            }
                        } else {
                            newRate = incomingRate - incomingRate * (double)this.factor / 100.0;
                            if (newRate > 0.0 && newRate < limiterRate) {
                                limiter.setRate(newRate);
                            }
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace("Back-pressure state for {}: incoming rate {}, outgoing rate {}, ratio {}, rate limiting {}", new Object[]{backPressure.getHost(), incomingRate, outgoingRate, actualRatio, limiter.getRate()});
                        }
                    } else {
                        limiter.setRate(Double.POSITIVE_INFINITY);
                    }
                    backPressure.incomingRate.prune();
                    backPressure.outgoingRate.prune();
                }
                finally {
                    backPressure.releaseIntervalLock();
                }
            }
            if (backPressure.rateLimiter.getRate() <= minRateLimit) {
                minRateLimit = backPressure.rateLimiter.getRate();
                currentMin = backPressure.rateLimiter;
            }
            if (!(backPressure.rateLimiter.getRate() >= maxRateLimit)) continue;
            maxRateLimit = backPressure.rateLimiter.getRate();
            currentMax = backPressure.rateLimiter;
        }
        if (!states.isEmpty()) {
            IntervalRateLimiter rateLimiter = (IntervalRateLimiter)this.rateLimiters.get(states, key -> new IntervalRateLimiter(this.timeSource));
            if (isUpdated && rateLimiter.tryIntervalLock(this.windowSize)) {
                try {
                    rateLimiter.limiter = this.flow.equals((Object)Flow.FAST) ? currentMax : currentMin;
                    tenSecsNoSpamLogger.info("{} currently applied for remote replicas: {}", rateLimiter.limiter, states);
                }
                finally {
                    rateLimiter.releaseIntervalLock();
                }
            }
            long responseTimeInNanos = (long)((double)TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS) / minIncomingRate);
            this.doRateLimit(rateLimiter.limiter, Math.max(0L, TimeUnit.NANOSECONDS.convert(timeout, unit) - responseTimeInNanos));
        }
    }

    @Override
    public RateBasedBackPressureState newState(InetAddressAndPort host) {
        return new RateBasedBackPressureState(host, this.timeSource, this.windowSize);
    }

    @VisibleForTesting
    RateLimiter getRateLimiterForReplicaGroup(Set<RateBasedBackPressureState> states) {
        IntervalRateLimiter rateLimiter = (IntervalRateLimiter)this.rateLimiters.getIfPresent(states);
        return rateLimiter != null ? rateLimiter.limiter : RateLimiter.create((double)Double.POSITIVE_INFINITY);
    }

    @VisibleForTesting
    boolean doRateLimit(RateLimiter rateLimiter, long timeoutInNanos) {
        if (!rateLimiter.tryAcquire(1, timeoutInNanos, TimeUnit.NANOSECONDS)) {
            this.timeSource.sleepUninterruptibly(timeoutInNanos, TimeUnit.NANOSECONDS);
            oneMinNoSpamLogger.info("Cannot apply {} due to exceeding write timeout, pausing {} nanoseconds instead.", rateLimiter, timeoutInNanos);
            return false;
        }
        return true;
    }

    private static class IntervalRateLimiter
    extends IntervalLock {
        public volatile RateLimiter limiter = RateLimiter.create((double)Double.POSITIVE_INFINITY);

        IntervalRateLimiter(TimeSource timeSource) {
            super(timeSource);
        }
    }

    static enum Flow {
        FAST,
        SLOW;

    }
}

