/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointStateSerializer;
import org.apache.cassandra.gms.HeartBeatState;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.utils.CassandraVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointState {
    protected static final Logger logger = LoggerFactory.getLogger(EndpointState.class);
    public static final IVersionedSerializer<EndpointState> serializer = new EndpointStateSerializer();
    private volatile HeartBeatState hbState;
    private final AtomicReference<Map<ApplicationState, VersionedValue>> applicationState;
    private volatile long updateTimestamp;
    private volatile boolean isAlive;

    public EndpointState(HeartBeatState initialHbState) {
        this(initialHbState, new EnumMap<ApplicationState, VersionedValue>(ApplicationState.class));
    }

    EndpointState(HeartBeatState initialHbState, Map<ApplicationState, VersionedValue> states) {
        this.hbState = initialHbState;
        this.applicationState = new AtomicReference<EnumMap<ApplicationState, VersionedValue>>(new EnumMap<ApplicationState, VersionedValue>(states));
        this.updateTimestamp = System.nanoTime();
        this.isAlive = true;
    }

    HeartBeatState getHeartBeatState() {
        return this.hbState;
    }

    void setHeartBeatState(HeartBeatState newHbState) {
        this.updateTimestamp();
        this.hbState = newHbState;
    }

    public VersionedValue getApplicationState(ApplicationState key) {
        return this.applicationState.get().get((Object)key);
    }

    public Set<Map.Entry<ApplicationState, VersionedValue>> states() {
        return this.applicationState.get().entrySet();
    }

    public void addApplicationState(ApplicationState key, VersionedValue value) {
        this.addApplicationStates(Collections.singletonMap(key, value));
    }

    public void addApplicationStates(Map<ApplicationState, VersionedValue> values) {
        this.addApplicationStates(values.entrySet());
    }

    public void addApplicationStates(Set<Map.Entry<ApplicationState, VersionedValue>> values) {
        EnumMap<ApplicationState, VersionedValue> copy;
        Map<ApplicationState, VersionedValue> orig;
        do {
            orig = this.applicationState.get();
            copy = new EnumMap<ApplicationState, VersionedValue>(orig);
            for (Map.Entry<ApplicationState, VersionedValue> value : values) {
                copy.put(value.getKey(), value.getValue());
            }
        } while (!this.applicationState.compareAndSet(orig, copy));
    }

    public long getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    void updateTimestamp() {
        this.updateTimestamp = System.nanoTime();
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    void markAlive() {
        this.isAlive = true;
    }

    void markDead() {
        this.isAlive = false;
    }

    public boolean isRpcReady() {
        VersionedValue rpcState = this.getApplicationState(ApplicationState.RPC_READY);
        return rpcState != null && Boolean.parseBoolean(rpcState.value);
    }

    public boolean isNormalState() {
        return this.getStatus().equals("NORMAL");
    }

    public String getStatus() {
        VersionedValue status = this.getApplicationState(ApplicationState.STATUS_WITH_PORT);
        if (status == null) {
            status = this.getApplicationState(ApplicationState.STATUS);
        }
        if (status == null) {
            return "";
        }
        String[] pieces = status.value.split(VersionedValue.DELIMITER_STR, -1);
        assert (pieces.length > 0);
        return pieces[0];
    }

    @Nullable
    public UUID getSchemaVersion() {
        VersionedValue applicationState = this.getApplicationState(ApplicationState.SCHEMA);
        return applicationState != null ? UUID.fromString(applicationState.value) : null;
    }

    @Nullable
    public CassandraVersion getReleaseVersion() {
        VersionedValue applicationState = this.getApplicationState(ApplicationState.RELEASE_VERSION);
        return applicationState != null ? new CassandraVersion(applicationState.value) : null;
    }

    public String toString() {
        return "EndpointState: HeartBeatState = " + this.hbState + ", AppStateMap = " + this.applicationState.get();
    }
}

