/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.schema.TableMetadata;

final class SystemPropertiesTable
extends AbstractVirtualTable {
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final Set<String> CASSANDRA_RELEVANT_PROPERTIES = Sets.newHashSet((Object[])new String[]{"java.home", "java.io.tmpdir", "java.library.path", "java.security.egd", "java.version", "java.vm.name", "line.separator", "os.arch", "os.name", "user.home", "sun.arch.data.model", "java.rmi.server.hostname", "java.rmi.server.randomID", "com.sun.management.jmxremote.authenticate", "com.sun.management.jmxremote.rmi.port", "com.sun.management.jmxremote.ssl", "com.sun.management.jmxremote.ssl.need.client.auth", "com.sun.management.jmxremote.access.file", "com.sun.management.jmxremote.password.file", "com.sun.management.jmxremote.port", "com.sun.management.jmxremote.ssl.enabled.protocols", "com.sun.management.jmxremote.ssl.enabled.cipher.suites", "mx4jaddress", "mx4jport", "cassandra-foreground", "cassandra-pidfile", "default.provide.overlapping.tombstones", "org.apache.cassandra.disable_mbean_registration", "org.apache.cassandra.db.virtual.SystemPropertiesTableTest"});
    private static final Set<String> CASSANDRA_RELEVANT_ENVS = Sets.newHashSet((Object[])new String[]{"JAVA_HOME"});

    SystemPropertiesTable(String keyspace) {
        super(TableMetadata.builder(keyspace, "system_properties").comment("Cassandra relevant system properties").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(UTF8Type.instance)).addPartitionKeyColumn(NAME, (AbstractType)UTF8Type.instance).addRegularColumn(VALUE, (AbstractType)UTF8Type.instance).build());
    }

    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        System.getenv().keySet().stream().filter(SystemPropertiesTable::isCassandraRelevant).forEach(name -> SystemPropertiesTable.addRow(result, name, System.getenv(name)));
        System.getProperties().stringPropertyNames().stream().filter(SystemPropertiesTable::isCassandraRelevant).forEach(name -> SystemPropertiesTable.addRow(result, name, System.getProperty(name)));
        return result;
    }

    @Override
    public AbstractVirtualTable.DataSet data(DecoratedKey partitionKey) {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        String name = (String)UTF8Type.instance.compose(partitionKey.getKey());
        if (SystemPropertiesTable.isCassandraRelevant(name)) {
            SystemPropertiesTable.addRow(result, name, System.getProperty(name, System.getenv(name)));
        }
        return result;
    }

    static boolean isCassandraRelevant(String name) {
        return name.startsWith("cassandra.") || CASSANDRA_RELEVANT_PROPERTIES.contains(name) || CASSANDRA_RELEVANT_ENVS.contains(name);
    }

    private static void addRow(SimpleDataSet result, String name, String value) {
        result.row(name).column(VALUE, value);
    }
}

