/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;

public abstract class Slices
implements Iterable<Slice> {
    public static final Serializer serializer = new Serializer();
    public static final Slices ALL = new SelectAllSlices();
    public static final Slices NONE = new SelectNoSlices();

    protected Slices() {
    }

    public static Slices with(ClusteringComparator comparator, Slice slice) {
        if (slice.start() == ClusteringBound.BOTTOM && slice.end() == ClusteringBound.TOP) {
            return ALL;
        }
        Preconditions.checkArgument((!slice.isEmpty(comparator) ? 1 : 0) != 0);
        return new ArrayBackedSlices(comparator, new Slice[]{slice});
    }

    public abstract boolean hasLowerBound();

    public abstract boolean hasUpperBound();

    public abstract int size();

    public abstract Slice get(int var1);

    public abstract Slices forPaging(ClusteringComparator var1, Clustering var2, boolean var3, boolean var4);

    public abstract InOrderTester inOrderTester(boolean var1);

    public abstract boolean selects(Clustering var1);

    public abstract boolean intersects(List<ByteBuffer> var1, List<ByteBuffer> var2);

    public abstract String toCQLString(TableMetadata var1);

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    private static class SelectNoSlices
    extends Slices {
        private static final InOrderTester trivialTester = new InOrderTester(){

            @Override
            public boolean includes(Clustering value) {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }
        };

        private SelectNoSlices() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Slice get(int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasLowerBound() {
            return false;
        }

        @Override
        public boolean hasUpperBound() {
            return false;
        }

        @Override
        public Slices forPaging(ClusteringComparator comparator, Clustering lastReturned, boolean inclusive, boolean reversed) {
            return this;
        }

        @Override
        public boolean selects(Clustering clustering) {
            return false;
        }

        @Override
        public InOrderTester inOrderTester(boolean reversed) {
            return trivialTester;
        }

        @Override
        public boolean intersects(List<ByteBuffer> minClusteringValues, List<ByteBuffer> maxClusteringValues) {
            return false;
        }

        @Override
        public Iterator<Slice> iterator() {
            return Collections.emptyIterator();
        }

        public String toString() {
            return "NONE";
        }

        @Override
        public String toCQLString(TableMetadata metadata) {
            return "";
        }
    }

    private static class SelectAllSlices
    extends Slices {
        private static final InOrderTester trivialTester = new InOrderTester(){

            @Override
            public boolean includes(Clustering value) {
                return true;
            }

            @Override
            public boolean isDone() {
                return false;
            }
        };

        private SelectAllSlices() {
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Slice get(int i) {
            return Slice.ALL;
        }

        @Override
        public boolean hasLowerBound() {
            return false;
        }

        @Override
        public boolean hasUpperBound() {
            return false;
        }

        @Override
        public boolean selects(Clustering clustering) {
            return true;
        }

        @Override
        public Slices forPaging(ClusteringComparator comparator, Clustering lastReturned, boolean inclusive, boolean reversed) {
            return new ArrayBackedSlices(comparator, new Slice[]{Slice.ALL.forPaging(comparator, lastReturned, inclusive, reversed)});
        }

        @Override
        public InOrderTester inOrderTester(boolean reversed) {
            return trivialTester;
        }

        @Override
        public boolean intersects(List<ByteBuffer> minClusteringValues, List<ByteBuffer> maxClusteringValues) {
            return true;
        }

        @Override
        public Iterator<Slice> iterator() {
            return Iterators.singletonIterator((Object)Slice.ALL);
        }

        public String toString() {
            return "ALL";
        }

        @Override
        public String toCQLString(TableMetadata metadata) {
            return "";
        }
    }

    private static class ArrayBackedSlices
    extends Slices {
        private final ClusteringComparator comparator;
        private final Slice[] slices;

        private ArrayBackedSlices(ClusteringComparator comparator, Slice[] slices) {
            this.comparator = comparator;
            this.slices = slices;
        }

        @Override
        public int size() {
            return this.slices.length;
        }

        @Override
        public boolean hasLowerBound() {
            return this.slices[0].start().size() != 0;
        }

        @Override
        public boolean hasUpperBound() {
            return this.slices[this.slices.length - 1].end().size() != 0;
        }

        @Override
        public Slice get(int i) {
            return this.slices[i];
        }

        @Override
        public boolean selects(Clustering clustering) {
            for (int i = 0; i < this.slices.length; ++i) {
                Slice slice = this.slices[i];
                if (this.comparator.compare((ClusteringPrefix)clustering, slice.start()) < 0) {
                    return false;
                }
                if (this.comparator.compare((ClusteringPrefix)clustering, slice.end()) > 0) continue;
                return true;
            }
            return false;
        }

        @Override
        public InOrderTester inOrderTester(boolean reversed) {
            return reversed ? new InReverseOrderTester() : new InForwardOrderTester();
        }

        @Override
        public Slices forPaging(ClusteringComparator comparator, Clustering lastReturned, boolean inclusive, boolean reversed) {
            return reversed ? this.forReversePaging(comparator, lastReturned, inclusive) : this.forForwardPaging(comparator, lastReturned, inclusive);
        }

        private Slices forForwardPaging(ClusteringComparator comparator, Clustering lastReturned, boolean inclusive) {
            for (int i = 0; i < this.slices.length; ++i) {
                Slice slice = this.slices[i];
                Slice newSlice = slice.forPaging(comparator, lastReturned, inclusive, false);
                if (newSlice == null) continue;
                if (slice == newSlice && i == 0) {
                    return this;
                }
                ArrayBackedSlices newSlices = new ArrayBackedSlices(comparator, Arrays.copyOfRange(this.slices, i, this.slices.length));
                newSlices.slices[0] = newSlice;
                return newSlices;
            }
            return NONE;
        }

        private Slices forReversePaging(ClusteringComparator comparator, Clustering lastReturned, boolean inclusive) {
            for (int i = this.slices.length - 1; i >= 0; --i) {
                Slice slice = this.slices[i];
                Slice newSlice = slice.forPaging(comparator, lastReturned, inclusive, true);
                if (newSlice == null) continue;
                if (slice == newSlice && i == this.slices.length - 1) {
                    return this;
                }
                ArrayBackedSlices newSlices = new ArrayBackedSlices(comparator, Arrays.copyOfRange(this.slices, 0, i + 1));
                newSlices.slices[i] = newSlice;
                return newSlices;
            }
            return NONE;
        }

        @Override
        public boolean intersects(List<ByteBuffer> minClusteringValues, List<ByteBuffer> maxClusteringValues) {
            for (Slice slice : this) {
                if (!slice.intersects(this.comparator, minClusteringValues, maxClusteringValues)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<Slice> iterator() {
            return Iterators.forArray((Object[])this.slices);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (int i = 0; i < this.slices.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.slices[i].toString(this.comparator));
            }
            return sb.append("}").toString();
        }

        @Override
        public String toCQLString(TableMetadata metadata) {
            StringBuilder sb = new StringBuilder();
            int clusteringSize = metadata.clusteringColumns().size();
            ArrayList columnComponents = new ArrayList(clusteringSize);
            for (int i = 0; i < clusteringSize; ++i) {
                ArrayList<ComponentOfSlice> perSlice = new ArrayList<ComponentOfSlice>();
                columnComponents.add(perSlice);
                for (int j = 0; j < this.slices.length; ++j) {
                    ComponentOfSlice c = ComponentOfSlice.fromSlice(i, this.slices[j]);
                    if (c == null) continue;
                    perSlice.add(c);
                }
            }
            boolean needAnd = false;
            for (int i = 0; i < clusteringSize; ++i) {
                ColumnMetadata column = (ColumnMetadata)metadata.clusteringColumns().get(i);
                List componentInfo = (List)columnComponents.get(i);
                if (componentInfo.isEmpty()) break;
                ComponentOfSlice first = (ComponentOfSlice)componentInfo.get(0);
                if (first.isEQ()) {
                    int j;
                    if (needAnd) {
                        sb.append(" AND ");
                    }
                    needAnd = true;
                    sb.append(column.name);
                    LinkedHashSet<ByteBuffer> values = new LinkedHashSet<ByteBuffer>();
                    for (j = 0; j < componentInfo.size(); ++j) {
                        values.add(((ComponentOfSlice)componentInfo.get((int)j)).startValue);
                    }
                    if (values.size() == 1) {
                        sb.append(" = ").append(column.type.getString(first.startValue));
                        continue;
                    }
                    sb.append(" IN (");
                    j = 0;
                    for (ByteBuffer value : values) {
                        sb.append(j++ == 0 ? "" : ", ").append(column.type.getString(value));
                    }
                    sb.append(")");
                    continue;
                }
                if (first.startValue != null) {
                    if (needAnd) {
                        sb.append(" AND ");
                    }
                    needAnd = true;
                    sb.append(column.name).append(first.startInclusive ? " >= " : " > ").append(column.type.getString(first.startValue));
                }
                if (first.endValue == null) continue;
                if (needAnd) {
                    sb.append(" AND ");
                }
                needAnd = true;
                sb.append(column.name).append(first.endInclusive ? " <= " : " < ").append(column.type.getString(first.endValue));
            }
            return sb.toString();
        }

        private static class ComponentOfSlice {
            public final boolean startInclusive;
            public final ByteBuffer startValue;
            public final boolean endInclusive;
            public final ByteBuffer endValue;

            private ComponentOfSlice(boolean startInclusive, ByteBuffer startValue, boolean endInclusive, ByteBuffer endValue) {
                this.startInclusive = startInclusive;
                this.startValue = startValue;
                this.endInclusive = endInclusive;
                this.endValue = endValue;
            }

            public static ComponentOfSlice fromSlice(int component, Slice slice) {
                ClusteringBound start = slice.start();
                ClusteringBound end = slice.end();
                if (component >= start.size() && component >= end.size()) {
                    return null;
                }
                boolean startInclusive = true;
                boolean endInclusive = true;
                ByteBuffer startValue = null;
                ByteBuffer endValue = null;
                if (component < start.size()) {
                    startInclusive = start.isInclusive();
                    startValue = start.get(component);
                }
                if (component < end.size()) {
                    endInclusive = end.isInclusive();
                    endValue = end.get(component);
                }
                return new ComponentOfSlice(startInclusive, startValue, endInclusive, endValue);
            }

            public boolean isEQ() {
                return Objects.equals(this.startValue, this.endValue);
            }
        }

        private class InReverseOrderTester
        implements InOrderTester {
            private int idx;
            private boolean inSlice;

            public InReverseOrderTester() {
                this.idx = ArrayBackedSlices.this.slices.length - 1;
            }

            @Override
            public boolean includes(Clustering value) {
                while (this.idx >= 0) {
                    if (!this.inSlice) {
                        int cmp = ArrayBackedSlices.this.comparator.compare(ArrayBackedSlices.this.slices[this.idx].end(), (ClusteringPrefix)value);
                        if (cmp > 0) {
                            return false;
                        }
                        this.inSlice = true;
                        if (cmp == 0) {
                            return true;
                        }
                    }
                    if (ArrayBackedSlices.this.comparator.compare(ArrayBackedSlices.this.slices[this.idx].start(), (ClusteringPrefix)value) <= 0) {
                        return true;
                    }
                    --this.idx;
                    this.inSlice = false;
                }
                return false;
            }

            @Override
            public boolean isDone() {
                return this.idx < 0;
            }
        }

        private class InForwardOrderTester
        implements InOrderTester {
            private int idx;
            private boolean inSlice;

            private InForwardOrderTester() {
            }

            @Override
            public boolean includes(Clustering value) {
                while (this.idx < ArrayBackedSlices.this.slices.length) {
                    if (!this.inSlice) {
                        int cmp = ArrayBackedSlices.this.comparator.compare((ClusteringPrefix)value, ArrayBackedSlices.this.slices[this.idx].start());
                        if (cmp < 0) {
                            return false;
                        }
                        this.inSlice = true;
                        if (cmp == 0) {
                            return true;
                        }
                    }
                    if (ArrayBackedSlices.this.comparator.compare((ClusteringPrefix)value, ArrayBackedSlices.this.slices[this.idx].end()) <= 0) {
                        return true;
                    }
                    ++this.idx;
                    this.inSlice = false;
                }
                return false;
            }

            @Override
            public boolean isDone() {
                return this.idx >= ArrayBackedSlices.this.slices.length;
            }
        }
    }

    public static class Serializer {
        public void serialize(Slices slices, DataOutputPlus out, int version) throws IOException {
            int size = slices.size();
            out.writeUnsignedVInt(size);
            if (size == 0) {
                return;
            }
            List<AbstractType<?>> types = slices == ALL ? Collections.emptyList() : ((ArrayBackedSlices)slices).comparator.subtypes();
            for (Slice slice : slices) {
                Slice.serializer.serialize(slice, out, version, types);
            }
        }

        public long serializedSize(Slices slices, int version) {
            long size = TypeSizes.sizeofUnsignedVInt(slices.size());
            if (slices.size() == 0) {
                return size;
            }
            List<AbstractType<?>> types = slices instanceof SelectAllSlices ? Collections.emptyList() : ((ArrayBackedSlices)slices).comparator.subtypes();
            for (Slice slice : slices) {
                size += Slice.serializer.serializedSize(slice, version, types);
            }
            return size;
        }

        public Slices deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            int size = (int)in.readUnsignedVInt();
            if (size == 0) {
                return NONE;
            }
            Slice[] slices = new Slice[size];
            for (int i = 0; i < size; ++i) {
                slices[i] = Slice.serializer.deserialize(in, version, metadata.comparator.subtypes());
            }
            if (size == 1 && slices[0].start() == ClusteringBound.BOTTOM && slices[0].end() == ClusteringBound.TOP) {
                return ALL;
            }
            return new ArrayBackedSlices(metadata.comparator, slices);
        }
    }

    public static class Builder {
        private final ClusteringComparator comparator;
        private final List<Slice> slices;
        private boolean needsNormalizing;

        public Builder(ClusteringComparator comparator) {
            this.comparator = comparator;
            this.slices = new ArrayList<Slice>();
        }

        public Builder(ClusteringComparator comparator, int initialSize) {
            this.comparator = comparator;
            this.slices = new ArrayList<Slice>(initialSize);
        }

        public Builder add(ClusteringBound start, ClusteringBound end) {
            return this.add(Slice.make(start, end));
        }

        public Builder add(Slice slice) {
            Preconditions.checkArgument((!slice.isEmpty(this.comparator) ? 1 : 0) != 0);
            if (this.slices.size() > 0 && this.comparator.compare(this.slices.get(this.slices.size() - 1).end(), slice.start()) > 0) {
                this.needsNormalizing = true;
            }
            this.slices.add(slice);
            return this;
        }

        public Builder addAll(Slices slices) {
            for (Slice slice : slices) {
                this.add(slice);
            }
            return this;
        }

        public int size() {
            return this.slices.size();
        }

        public Slices build() {
            if (this.slices.isEmpty()) {
                return NONE;
            }
            if (this.slices.size() == 1 && this.slices.get(0) == Slice.ALL) {
                return ALL;
            }
            List<Slice> normalized = this.needsNormalizing ? this.normalize(this.slices) : this.slices;
            return new ArrayBackedSlices(this.comparator, normalized.toArray(new Slice[normalized.size()]));
        }

        private List<Slice> normalize(List<Slice> slices) {
            if (slices.size() <= 1) {
                return slices;
            }
            Collections.sort(slices, new Comparator<Slice>(){

                @Override
                public int compare(Slice s1, Slice s2) {
                    int c = comparator.compare(s1.start(), s2.start());
                    if (c != 0) {
                        return c;
                    }
                    return comparator.compare(s1.end(), s2.end());
                }
            });
            ArrayList<Slice> slicesCopy = new ArrayList<Slice>(slices.size());
            Slice last = slices.get(0);
            for (int i = 1; i < slices.size(); ++i) {
                Slice s2 = slices.get(i);
                boolean includesStart = last.includes(this.comparator, s2.start());
                boolean includesFinish = last.includes(this.comparator, s2.end());
                if (includesStart && includesFinish) continue;
                if (!includesStart && !includesFinish) {
                    slicesCopy.add(last);
                    last = s2;
                    continue;
                }
                if (includesStart) {
                    last = Slice.make(last.start(), s2.end());
                    continue;
                }
                assert (!includesFinish);
            }
            slicesCopy.add(last);
            return slicesCopy;
        }
    }

    public static interface InOrderTester {
        public boolean includes(Clustering var1);

        public boolean isDone();
    }
}

