/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.Digest;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.UnknownColumnException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.BTreeRemoval;
import org.apache.cassandra.utils.btree.BTreeSearchIterator;
import org.apache.cassandra.utils.btree.UpdateFunction;

public class Columns
extends AbstractCollection<ColumnMetadata>
implements Collection<ColumnMetadata> {
    public static final Serializer serializer = new Serializer();
    public static final Columns NONE = new Columns(BTree.empty(), 0);
    private static final ColumnMetadata FIRST_COMPLEX_STATIC = new ColumnMetadata("", "", ColumnIdentifier.getInterned(ByteBufferUtil.EMPTY_BYTE_BUFFER, UTF8Type.instance), SetType.getInstance(UTF8Type.instance, true), -1, ColumnMetadata.Kind.STATIC);
    private static final ColumnMetadata FIRST_COMPLEX_REGULAR = new ColumnMetadata("", "", ColumnIdentifier.getInterned(ByteBufferUtil.EMPTY_BYTE_BUFFER, UTF8Type.instance), SetType.getInstance(UTF8Type.instance, true), -1, ColumnMetadata.Kind.REGULAR);
    private final Object[] columns;
    private final int complexIdx;

    private Columns(Object[] columns, int complexIdx) {
        assert (complexIdx <= BTree.size(columns));
        this.columns = columns;
        this.complexIdx = complexIdx;
    }

    private Columns(Object[] columns) {
        this(columns, Columns.findFirstComplexIdx(columns));
    }

    public static Columns of(ColumnMetadata c) {
        return new Columns(BTree.singleton(c), c.isComplex() ? 0 : 1);
    }

    public static Columns from(Collection<ColumnMetadata> s) {
        Object[] tree = BTree.builder(Comparator.naturalOrder()).addAll(s).build();
        return new Columns(tree, Columns.findFirstComplexIdx(tree));
    }

    private static int findFirstComplexIdx(Object[] tree) {
        if (BTree.isEmpty(tree)) {
            return 0;
        }
        int size = BTree.size(tree);
        ColumnMetadata last = (ColumnMetadata)BTree.findByIndex(tree, size - 1);
        return last.isSimple() ? size : BTree.ceilIndex(tree, Comparator.naturalOrder(), last.isStatic() ? FIRST_COMPLEX_STATIC : FIRST_COMPLEX_REGULAR);
    }

    @Override
    public boolean isEmpty() {
        return BTree.isEmpty(this.columns);
    }

    public int simpleColumnCount() {
        return this.complexIdx;
    }

    public int complexColumnCount() {
        return BTree.size(this.columns) - this.complexIdx;
    }

    @Override
    public int size() {
        return BTree.size(this.columns);
    }

    public boolean hasSimple() {
        return this.complexIdx > 0;
    }

    public boolean hasComplex() {
        return this.complexIdx < BTree.size(this.columns);
    }

    public ColumnMetadata getSimple(int i) {
        return (ColumnMetadata)BTree.findByIndex(this.columns, i);
    }

    public ColumnMetadata getComplex(int i) {
        return (ColumnMetadata)BTree.findByIndex(this.columns, this.complexIdx + i);
    }

    public int simpleIdx(ColumnMetadata c) {
        return BTree.findIndex(this.columns, Comparator.naturalOrder(), c);
    }

    public int complexIdx(ColumnMetadata c) {
        return BTree.findIndex(this.columns, Comparator.naturalOrder(), c) - this.complexIdx;
    }

    public boolean contains(ColumnMetadata c) {
        return BTree.findIndex(this.columns, Comparator.naturalOrder(), c) >= 0;
    }

    public Columns mergeTo(Columns other) {
        if (this == other || other == NONE) {
            return this;
        }
        if (this == NONE) {
            return other;
        }
        Object[] tree = BTree.merge(this.columns, other.columns, Comparator.naturalOrder(), UpdateFunction.noOp());
        if (tree == this.columns) {
            return this;
        }
        if (tree == other.columns) {
            return other;
        }
        return new Columns(tree, Columns.findFirstComplexIdx(tree));
    }

    @Override
    public boolean containsAll(Collection<?> other) {
        if (other == this) {
            return true;
        }
        if (other.size() > this.size()) {
            return false;
        }
        BTreeSearchIterator iter = BTree.slice(this.columns, Comparator.naturalOrder(), BTree.Dir.ASC);
        for (Object def : other) {
            if (iter.next((ColumnMetadata)def) != null) continue;
            return false;
        }
        return true;
    }

    public Iterator<ColumnMetadata> simpleColumns() {
        return BTree.iterator(this.columns, 0, this.complexIdx - 1, BTree.Dir.ASC);
    }

    public Iterator<ColumnMetadata> complexColumns() {
        return BTree.iterator(this.columns, this.complexIdx, BTree.size(this.columns) - 1, BTree.Dir.ASC);
    }

    public BTreeSearchIterator<ColumnMetadata, ColumnMetadata> iterator() {
        return BTree.slice(this.columns, Comparator.naturalOrder(), BTree.Dir.ASC);
    }

    public Iterator<ColumnMetadata> selectOrderIterator() {
        return Iterators.mergeSorted((Iterable)ImmutableList.of(this.simpleColumns(), this.complexColumns()), (s, c) -> {
            assert (!s.kind.isPrimaryKeyKind());
            return s.name.bytes.compareTo(c.name.bytes);
        });
    }

    public Columns without(ColumnMetadata column) {
        if (!this.contains(column)) {
            return this;
        }
        Object[] newColumns = BTreeRemoval.remove(this.columns, Comparator.naturalOrder(), column);
        return new Columns(newColumns);
    }

    public Predicate<ColumnMetadata> inOrderInclusionTester() {
        BTreeSearchIterator iter = BTree.slice(this.columns, Comparator.naturalOrder(), BTree.Dir.ASC);
        return column -> iter.next(column) != null;
    }

    public void digest(Digest digest) {
        for (ColumnMetadata c : this) {
            digest.update(c.name.bytes);
        }
    }

    public void apply(Consumer<ColumnMetadata> function, boolean reversed) {
        BTree.apply(this.columns, function, reversed);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Columns)) {
            return false;
        }
        Columns that = (Columns)other;
        return this.complexIdx == that.complexIdx && BTree.equals(this.columns, that.columns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.complexIdx, BTree.hashCode(this.columns));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (ColumnMetadata def : this) {
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(def.name);
        }
        return sb.append("]").toString();
    }

    public static class Serializer {
        public void serialize(Columns columns, DataOutputPlus out) throws IOException {
            out.writeUnsignedVInt(columns.size());
            for (ColumnMetadata column : columns) {
                ByteBufferUtil.writeWithVIntLength(column.name.bytes, out);
            }
        }

        public long serializedSize(Columns columns) {
            long size = TypeSizes.sizeofUnsignedVInt(columns.size());
            for (ColumnMetadata column : columns) {
                size += (long)ByteBufferUtil.serializedSizeWithVIntLength(column.name.bytes);
            }
            return size;
        }

        public Columns deserialize(DataInputPlus in, TableMetadata metadata) throws IOException {
            int length = (int)in.readUnsignedVInt();
            BTree.Builder builder = BTree.builder(Comparator.naturalOrder());
            builder.auto(false);
            for (int i = 0; i < length; ++i) {
                ByteBuffer name = ByteBufferUtil.readWithVIntLength(in);
                ColumnMetadata column = metadata.getColumn(name);
                if (column == null && (column = metadata.getDroppedColumn(name)) == null) {
                    throw new UnknownColumnException("Unknown column " + UTF8Type.instance.getString(name) + " during deserialization");
                }
                builder.add(column);
            }
            return new Columns(builder.build());
        }

        public void serializeSubset(Collection<ColumnMetadata> columns, Columns superset, DataOutputPlus out) throws IOException {
            int supersetCount;
            int columnCount = columns.size();
            if (columnCount == (supersetCount = superset.size())) {
                out.writeUnsignedVInt(0L);
            } else if (supersetCount < 64) {
                out.writeUnsignedVInt(Serializer.encodeBitmap(columns, superset, supersetCount));
            } else {
                this.serializeLargeSubset(columns, columnCount, superset, supersetCount, out);
            }
        }

        public long serializedSubsetSize(Collection<ColumnMetadata> columns, Columns superset) {
            int supersetCount;
            int columnCount = columns.size();
            if (columnCount == (supersetCount = superset.size())) {
                return TypeSizes.sizeofUnsignedVInt(0L);
            }
            if (supersetCount < 64) {
                return TypeSizes.sizeofUnsignedVInt(Serializer.encodeBitmap(columns, superset, supersetCount));
            }
            return this.serializeLargeSubsetSize(columns, columnCount, superset, supersetCount);
        }

        public Columns deserializeSubset(Columns superset, DataInputPlus in) throws IOException {
            long encoded = in.readUnsignedVInt();
            if (encoded == 0L) {
                return superset;
            }
            if (superset.size() >= 64) {
                return this.deserializeLargeSubset(in, superset, (int)encoded);
            }
            BTree.Builder builder = BTree.builder(Comparator.naturalOrder());
            int firstComplexIdx = 0;
            for (ColumnMetadata column : superset) {
                if ((encoded & 1L) == 0L) {
                    builder.add(column);
                    if (column.isSimple()) {
                        ++firstComplexIdx;
                    }
                }
                encoded >>>= 1;
            }
            if (encoded != 0L) {
                throw new IOException("Invalid Columns subset bytes; too many bits set:" + Long.toBinaryString(encoded));
            }
            return new Columns(builder.build(), firstComplexIdx);
        }

        private static long encodeBitmap(Collection<ColumnMetadata> columns, Columns superset, int supersetCount) {
            long bitmap = 0L;
            Iterator iter = superset.iterator();
            int expectIndex = 0;
            for (ColumnMetadata column : columns) {
                if (iter.next(column) == null) {
                    throw new IllegalStateException(columns + " is not a subset of " + superset);
                }
                int currentIndex = iter.indexOfCurrent();
                int count = currentIndex - expectIndex;
                bitmap |= (1L << count) - 1L << expectIndex;
                expectIndex = currentIndex + 1;
            }
            int count = supersetCount - expectIndex;
            return bitmap |= (1L << count) - 1L << expectIndex;
        }

        private void serializeLargeSubset(Collection<ColumnMetadata> columns, int columnCount, Columns superset, int supersetCount, DataOutputPlus out) throws IOException {
            out.writeUnsignedVInt(supersetCount - columnCount);
            Iterator iter = superset.iterator();
            if (columnCount < supersetCount / 2) {
                for (ColumnMetadata column : columns) {
                    if (iter.next(column) == null) {
                        throw new IllegalStateException();
                    }
                    out.writeUnsignedVInt(iter.indexOfCurrent());
                }
            } else {
                int prev = -1;
                for (ColumnMetadata column : columns) {
                    if (iter.next(column) == null) {
                        throw new IllegalStateException();
                    }
                    int cur = iter.indexOfCurrent();
                    while (++prev != cur) {
                        out.writeUnsignedVInt(prev);
                    }
                }
                while (++prev != supersetCount) {
                    out.writeUnsignedVInt(prev);
                }
            }
        }

        private Columns deserializeLargeSubset(DataInputPlus in, Columns superset, int delta) throws IOException {
            int supersetCount = superset.size();
            int columnCount = supersetCount - delta;
            BTree.Builder builder = BTree.builder(Comparator.naturalOrder());
            if (columnCount < supersetCount / 2) {
                for (int i = 0; i < columnCount; ++i) {
                    int idx = (int)in.readUnsignedVInt();
                    builder.add(BTree.findByIndex(superset.columns, idx));
                }
            } else {
                Iterator iter = superset.iterator();
                int idx = 0;
                int skipped = 0;
                while (true) {
                    int nextMissingIndex;
                    int n = nextMissingIndex = skipped < delta ? (int)in.readUnsignedVInt() : supersetCount;
                    while (idx < nextMissingIndex) {
                        ColumnMetadata def = (ColumnMetadata)iter.next();
                        builder.add(def);
                        ++idx;
                    }
                    if (idx == supersetCount) break;
                    iter.next();
                    ++idx;
                    ++skipped;
                }
            }
            return new Columns(builder.build());
        }

        private int serializeLargeSubsetSize(Collection<ColumnMetadata> columns, int columnCount, Columns superset, int supersetCount) {
            int size = TypeSizes.sizeofUnsignedVInt(supersetCount - columnCount);
            Iterator iter = superset.iterator();
            if (columnCount < supersetCount / 2) {
                for (ColumnMetadata column : columns) {
                    if (iter.next(column) == null) {
                        throw new IllegalStateException();
                    }
                    size += TypeSizes.sizeofUnsignedVInt(iter.indexOfCurrent());
                }
            } else {
                int prev = -1;
                for (ColumnMetadata column : columns) {
                    if (iter.next(column) == null) {
                        throw new IllegalStateException();
                    }
                    int cur = iter.indexOfCurrent();
                    while (++prev != cur) {
                        size += TypeSizes.sizeofUnsignedVInt(prev);
                    }
                }
                while (++prev != supersetCount) {
                    size += TypeSizes.sizeofUnsignedVInt(prev);
                }
            }
            return size;
        }
    }
}

