/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.ClusteringBoundOrBoundary;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class ClusteringBound
extends ClusteringBoundOrBoundary {
    public static final ClusteringBound BOTTOM = new ClusteringBound(ClusteringPrefix.Kind.INCL_START_BOUND, EMPTY_VALUES_ARRAY);
    public static final ClusteringBound TOP = new ClusteringBound(ClusteringPrefix.Kind.INCL_END_BOUND, EMPTY_VALUES_ARRAY);

    protected ClusteringBound(ClusteringPrefix.Kind kind, ByteBuffer[] values) {
        super(kind, values);
    }

    @Override
    public ClusteringPrefix minimize() {
        if (!ByteBufferUtil.canMinimize(this.values)) {
            return this;
        }
        return new ClusteringBound(this.kind, ByteBufferUtil.minimizeBuffers(this.values));
    }

    public static ClusteringBound create(ClusteringPrefix.Kind kind, ByteBuffer[] values) {
        assert (!kind.isBoundary());
        return new ClusteringBound(kind, values);
    }

    public static ClusteringPrefix.Kind boundKind(boolean isStart, boolean isInclusive) {
        return isStart ? (isInclusive ? ClusteringPrefix.Kind.INCL_START_BOUND : ClusteringPrefix.Kind.EXCL_START_BOUND) : (isInclusive ? ClusteringPrefix.Kind.INCL_END_BOUND : ClusteringPrefix.Kind.EXCL_END_BOUND);
    }

    public static ClusteringBound inclusiveStartOf(ByteBuffer ... values) {
        return ClusteringBound.create(ClusteringPrefix.Kind.INCL_START_BOUND, values);
    }

    public static ClusteringBound inclusiveEndOf(ByteBuffer ... values) {
        return ClusteringBound.create(ClusteringPrefix.Kind.INCL_END_BOUND, values);
    }

    public static ClusteringBound exclusiveStartOf(ByteBuffer ... values) {
        return ClusteringBound.create(ClusteringPrefix.Kind.EXCL_START_BOUND, values);
    }

    public static ClusteringBound exclusiveEndOf(ByteBuffer ... values) {
        return ClusteringBound.create(ClusteringPrefix.Kind.EXCL_END_BOUND, values);
    }

    public static ClusteringBound inclusiveStartOf(ClusteringPrefix prefix) {
        ByteBuffer[] values = new ByteBuffer[prefix.size()];
        for (int i = 0; i < prefix.size(); ++i) {
            values[i] = prefix.get(i);
        }
        return ClusteringBound.inclusiveStartOf(values);
    }

    public static ClusteringBound exclusiveStartOf(ClusteringPrefix prefix) {
        ByteBuffer[] values = new ByteBuffer[prefix.size()];
        for (int i = 0; i < prefix.size(); ++i) {
            values[i] = prefix.get(i);
        }
        return ClusteringBound.exclusiveStartOf(values);
    }

    public static ClusteringBound inclusiveEndOf(ClusteringPrefix prefix) {
        ByteBuffer[] values = new ByteBuffer[prefix.size()];
        for (int i = 0; i < prefix.size(); ++i) {
            values[i] = prefix.get(i);
        }
        return ClusteringBound.inclusiveEndOf(values);
    }

    public static ClusteringBound create(ClusteringComparator comparator, boolean isStart, boolean isInclusive, Object ... values) {
        CBuilder builder = CBuilder.create(comparator);
        for (Object val : values) {
            if (val instanceof ByteBuffer) {
                builder.add((ByteBuffer)val);
                continue;
            }
            builder.add(val);
        }
        return builder.buildBound(isStart, isInclusive);
    }

    @Override
    public ClusteringBound invert() {
        return ClusteringBound.create(this.kind().invert(), this.values);
    }

    @Override
    public ClusteringBound copy(AbstractAllocator allocator) {
        return (ClusteringBound)super.copy(allocator);
    }

    public boolean isStart() {
        return this.kind().isStart();
    }

    public boolean isEnd() {
        return !this.isStart();
    }

    public boolean isInclusive() {
        return this.kind == ClusteringPrefix.Kind.INCL_START_BOUND || this.kind == ClusteringPrefix.Kind.INCL_END_BOUND;
    }

    public boolean isExclusive() {
        return this.kind == ClusteringPrefix.Kind.EXCL_START_BOUND || this.kind == ClusteringPrefix.Kind.EXCL_END_BOUND;
    }

    int compareTo(ClusteringComparator comparator, List<ByteBuffer> sstableBound) {
        for (int i = 0; i < sstableBound.size(); ++i) {
            if (i >= this.size()) {
                return this.isStart() ? -1 : 1;
            }
            int cmp = comparator.compareComponent(i, this.get(i), sstableBound.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        if (this.size() > sstableBound.size()) {
            return this.isStart() ? -1 : 1;
        }
        return this.isInclusive() ? 0 : (this.isStart() ? 1 : -1);
    }
}

