/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.audit;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireOut;
import org.apache.cassandra.audit.AuditLogEntry;
import org.apache.cassandra.audit.BinLogAuditLogger;
import org.apache.cassandra.audit.IAuditLogger;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.binlog.BinLog;
import org.apache.cassandra.utils.concurrent.WeightedQueue;
import org.github.jamm.MemoryLayoutSpecification;

public class FullQueryLogger
extends BinLogAuditLogger
implements IAuditLogger {
    public static final long CURRENT_VERSION = 0L;
    public static final String PROTOCOL_VERSION = "protocol-version";
    public static final String QUERY_OPTIONS = "query-options";
    public static final String QUERY_START_TIME = "query-start-time";
    public static final String GENERATED_TIMESTAMP = "generated-timestamp";
    public static final String GENERATED_NOW_IN_SECONDS = "generated-now-in-seconds";
    public static final String KEYSPACE = "keyspace";
    public static final String BATCH = "batch";
    public static final String SINGLE_QUERY = "single-query";
    public static final String QUERY = "query";
    public static final String BATCH_TYPE = "batch-type";
    public static final String QUERIES = "queries";
    public static final String VALUES = "values";
    private static final int EMPTY_BYTEBUFFER_SIZE = Ints.checkedCast((long)ObjectSizes.sizeOnHeapExcludingData(ByteBuffer.allocate(0)));
    private static final int EMPTY_LIST_SIZE = Ints.checkedCast((long)ObjectSizes.measureDeep(new ArrayList(0)));
    private static final int EMPTY_BYTEBUF_SIZE;
    private static final int OBJECT_HEADER_SIZE;
    private static final int OBJECT_REFERENCE_SIZE;

    @Override
    public void log(AuditLogEntry entry) {
        this.logQuery(entry.getOperation(), entry.getOptions(), entry.getState(), entry.getTimestamp());
    }

    void logBatch(BatchStatement.Type type, List<String> queries, List<List<ByteBuffer>> values, QueryOptions queryOptions, QueryState queryState, long batchTimeMillis) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type was null");
        Preconditions.checkNotNull(queries, (Object)"queries was null");
        Preconditions.checkNotNull(values, (Object)"value was null");
        Preconditions.checkNotNull((Object)queryOptions, (Object)"queryOptions was null");
        Preconditions.checkNotNull((Object)queryState, (Object)"queryState was null");
        Preconditions.checkArgument((batchTimeMillis > 0L ? 1 : 0) != 0, (Object)"batchTimeMillis must be > 0");
        BinLog binLog = this.binLog;
        if (binLog == null) {
            return;
        }
        Batch wrappedBatch = new Batch(type, queries, values, queryOptions, queryState, batchTimeMillis);
        this.logRecord(wrappedBatch, binLog);
    }

    void logQuery(String query, QueryOptions queryOptions, QueryState queryState, long queryTimeMillis) {
        Preconditions.checkNotNull((Object)query, (Object)"query was null");
        Preconditions.checkNotNull((Object)queryOptions, (Object)"queryOptions was null");
        Preconditions.checkNotNull((Object)queryState, (Object)"queryState was null");
        Preconditions.checkArgument((queryTimeMillis > 0L ? 1 : 0) != 0, (Object)"queryTimeMillis must be > 0");
        BinLog binLog = this.binLog;
        if (binLog == null) {
            return;
        }
        Query wrappedQuery = new Query(query, queryOptions, queryState, queryTimeMillis);
        this.logRecord(wrappedQuery, binLog);
    }

    static {
        OBJECT_HEADER_SIZE = MemoryLayoutSpecification.SPEC.getObjectHeaderSize();
        OBJECT_REFERENCE_SIZE = MemoryLayoutSpecification.SPEC.getReferenceSize();
        ByteBuf buf = CBUtil.allocator.buffer(0, 0);
        try {
            EMPTY_BYTEBUF_SIZE = Ints.checkedCast((long)ObjectSizes.measure(buf));
        }
        finally {
            buf.release();
        }
    }

    private static abstract class AbstractLogEntry
    extends BinLog.ReleaseableWriteMarshallable
    implements WeightedQueue.Weighable {
        private final long queryStartTime;
        private final int protocolVersion;
        private final ByteBuf queryOptionsBuffer;
        private final long generatedTimestamp;
        private final int generatedNowInSeconds;
        @Nullable
        private final String keyspace;

        AbstractLogEntry(QueryOptions queryOptions, QueryState queryState, long queryStartTime) {
            this.queryStartTime = queryStartTime;
            this.protocolVersion = queryOptions.getProtocolVersion().asInt();
            int optionsSize = QueryOptions.codec.encodedSize(queryOptions, queryOptions.getProtocolVersion());
            this.queryOptionsBuffer = CBUtil.allocator.buffer(optionsSize, optionsSize);
            this.generatedTimestamp = queryState.generatedTimestamp();
            this.generatedNowInSeconds = queryState.generatedNowInSeconds();
            this.keyspace = queryState.getClientState().getRawKeyspace();
            try {
                QueryOptions.codec.encode(queryOptions, this.queryOptionsBuffer, queryOptions.getProtocolVersion());
            }
            catch (Throwable e) {
                this.queryOptionsBuffer.release();
                throw e;
            }
        }

        @Override
        protected long version() {
            return 0L;
        }

        @Override
        public void writeMarshallablePayload(WireOut wire) {
            wire.write((CharSequence)FullQueryLogger.QUERY_START_TIME).int64(this.queryStartTime);
            wire.write((CharSequence)FullQueryLogger.PROTOCOL_VERSION).int32(this.protocolVersion);
            wire.write((CharSequence)FullQueryLogger.QUERY_OPTIONS).bytes(BytesStore.wrap((ByteBuffer)this.queryOptionsBuffer.nioBuffer()));
            wire.write((CharSequence)FullQueryLogger.GENERATED_TIMESTAMP).int64(this.generatedTimestamp);
            wire.write((CharSequence)FullQueryLogger.GENERATED_NOW_IN_SECONDS).int32(this.generatedNowInSeconds);
            wire.write((CharSequence)FullQueryLogger.KEYSPACE).text(this.keyspace);
        }

        @Override
        public void release() {
            this.queryOptionsBuffer.release();
        }

        @Override
        public int weight() {
            return OBJECT_HEADER_SIZE + 8 + 4 + EMPTY_BYTEBUF_SIZE + this.queryOptionsBuffer.capacity() + 8 + 4 + (this.keyspace != null ? Ints.checkedCast((long)ObjectSizes.sizeOf(this.keyspace)) : OBJECT_REFERENCE_SIZE);
        }
    }

    public static class Batch
    extends AbstractLogEntry {
        private final int weight;
        private final BatchStatement.Type batchType;
        private final List<String> queries;
        private final List<List<ByteBuffer>> values;

        public Batch(BatchStatement.Type batchType, List<String> queries, List<List<ByteBuffer>> values, QueryOptions queryOptions, QueryState queryState, long batchTimeMillis) {
            super(queryOptions, queryState, batchTimeMillis);
            this.queries = queries;
            this.values = values;
            this.batchType = batchType;
            int weight = super.weight();
            weight += 4 + 2 * EMPTY_LIST_SIZE + OBJECT_REFERENCE_SIZE;
            for (String string : queries) {
                weight = (int)((long)weight + ObjectSizes.sizeOf(string));
            }
            for (List list : values) {
                weight += EMPTY_LIST_SIZE;
                for (ByteBuffer value : list) {
                    weight += EMPTY_BYTEBUFFER_SIZE + value.capacity();
                }
            }
            this.weight = weight;
        }

        @Override
        protected String type() {
            return FullQueryLogger.BATCH;
        }

        @Override
        public void writeMarshallablePayload(WireOut wire) {
            super.writeMarshallablePayload(wire);
            wire.write((CharSequence)FullQueryLogger.BATCH_TYPE).text(this.batchType.name());
            ValueOut valueOut = wire.write((CharSequence)FullQueryLogger.QUERIES);
            valueOut.int32(this.queries.size());
            for (String string : this.queries) {
                valueOut.text(string);
            }
            valueOut = wire.write((CharSequence)FullQueryLogger.VALUES);
            valueOut.int32(this.values.size());
            for (List list : this.values) {
                valueOut.int32(list.size());
                for (ByteBuffer value : list) {
                    valueOut.bytes(BytesStore.wrap((ByteBuffer)value));
                }
            }
        }

        @Override
        public int weight() {
            return this.weight;
        }
    }

    public static class Query
    extends AbstractLogEntry {
        private final String query;

        public Query(String query, QueryOptions queryOptions, QueryState queryState, long queryStartTime) {
            super(queryOptions, queryState, queryStartTime);
            this.query = query;
        }

        @Override
        protected String type() {
            return FullQueryLogger.SINGLE_QUERY;
        }

        @Override
        public void writeMarshallablePayload(WireOut wire) {
            super.writeMarshallablePayload(wire);
            wire.write((CharSequence)FullQueryLogger.QUERY).text(this.query);
        }

        @Override
        public int weight() {
            return Ints.checkedCast((long)ObjectSizes.sizeOf(this.query)) + super.weight();
        }
    }
}

