/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.frame.compress;

import java.io.IOException;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.apache.cassandra.transport.frame.compress.Compressor;

public class LZ4Compressor
implements Compressor {
    public static final LZ4Compressor INSTANCE = new LZ4Compressor();
    private final net.jpountz.lz4.LZ4Compressor compressor;
    private final LZ4FastDecompressor decompressor;

    private LZ4Compressor() {
        LZ4Factory lz4Factory = LZ4Factory.fastestInstance();
        this.compressor = lz4Factory.fastCompressor();
        this.decompressor = lz4Factory.fastDecompressor();
    }

    @Override
    public int maxCompressedLength(int length) {
        return this.compressor.maxCompressedLength(length);
    }

    @Override
    public int compress(byte[] src, int srcOffset, int length, byte[] dest, int destOffset) throws IOException {
        try {
            return this.compressor.compress(src, srcOffset, length, dest, destOffset);
        }
        catch (Throwable t) {
            throw new IOException("Error caught during LZ4 compression", t);
        }
    }

    @Override
    public byte[] decompress(byte[] src, int offset, int length, int expectedDecompressedLength) throws IOException {
        try {
            return this.decompressor.decompress(src, offset, expectedDecompressedLength);
        }
        catch (Throwable t) {
            throw new IOException("Error caught during LZ4 decompression", t);
        }
    }
}

