/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tracing;

import io.netty.util.concurrent.FastThreadLocal;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.concurrent.ExecutorLocal;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.ParamType;
import org.apache.cassandra.tracing.ExpiredTraceState;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.tracing.TracingImpl;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Tracing
implements ExecutorLocal<TraceState> {
    public static final IVersionedSerializer<TraceType> traceTypeSerializer = new IVersionedSerializer<TraceType>(){

        @Override
        public void serialize(TraceType traceType, DataOutputPlus out, int version) throws IOException {
            out.write((byte)traceType.ordinal());
        }

        @Override
        public TraceType deserialize(DataInputPlus in, int version) throws IOException {
            return TraceType.deserialize(in.readByte());
        }

        @Override
        public long serializedSize(TraceType traceType, int version) {
            return 1L;
        }
    };
    protected static final Logger logger = LoggerFactory.getLogger(Tracing.class);
    private final InetAddressAndPort localAddress = FBUtilities.getLocalAddressAndPort();
    private final FastThreadLocal<TraceState> state = new FastThreadLocal();
    protected final ConcurrentMap<UUID, TraceState> sessions = new ConcurrentHashMap<UUID, TraceState>();
    public static final Tracing instance;

    public UUID getSessionId() {
        assert (Tracing.isTracing());
        return ((TraceState)this.state.get()).sessionId;
    }

    public TraceType getTraceType() {
        assert (Tracing.isTracing());
        return ((TraceState)this.state.get()).traceType;
    }

    public int getTTL() {
        assert (Tracing.isTracing());
        return ((TraceState)this.state.get()).ttl;
    }

    public static boolean isTracing() {
        return instance.get() != null;
    }

    public UUID newSession(Map<String, ByteBuffer> customPayload) {
        return this.newSession((UUID)TimeUUIDType.instance.compose(ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes())), TraceType.QUERY, customPayload);
    }

    public UUID newSession(TraceType traceType) {
        return this.newSession((UUID)TimeUUIDType.instance.compose(ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes())), traceType, Collections.EMPTY_MAP);
    }

    public UUID newSession(UUID sessionId, Map<String, ByteBuffer> customPayload) {
        return this.newSession(sessionId, TraceType.QUERY, customPayload);
    }

    protected UUID newSession(UUID sessionId, TraceType traceType, Map<String, ByteBuffer> customPayload) {
        assert (this.get() == null);
        TraceState ts = this.newTraceState(this.localAddress, sessionId, traceType);
        this.set(ts);
        this.sessions.put(sessionId, ts);
        return sessionId;
    }

    public void doneWithNonLocalSession(TraceState state) {
        if (state.releaseReference() == 0) {
            this.sessions.remove(state.sessionId);
        }
    }

    public void stopSession() {
        TraceState state = this.get();
        if (state == null) {
            logger.trace("request complete");
        } else {
            this.stopSessionImpl();
            state.stop();
            this.sessions.remove(state.sessionId);
            this.set(null);
        }
    }

    protected abstract void stopSessionImpl();

    @Override
    public TraceState get() {
        return (TraceState)this.state.get();
    }

    public TraceState get(UUID sessionId) {
        return (TraceState)this.sessions.get(sessionId);
    }

    @Override
    public void set(TraceState tls) {
        this.state.set((Object)tls);
    }

    public TraceState begin(String request, Map<String, String> parameters) {
        return this.begin(request, null, parameters);
    }

    public abstract TraceState begin(String var1, InetAddress var2, Map<String, String> var3);

    public TraceState initializeFromMessage(Message.Header header) {
        UUID sessionId = header.traceSession();
        if (sessionId == null) {
            return null;
        }
        TraceState ts = this.get(sessionId);
        if (ts != null && ts.acquireReference()) {
            return ts;
        }
        TraceType traceType = header.traceType();
        if (header.verb.isResponse()) {
            return new ExpiredTraceState(this.newTraceState(header.from, sessionId, traceType));
        }
        ts = this.newTraceState(header.from, sessionId, traceType);
        this.sessions.put(sessionId, ts);
        return ts;
    }

    public void traceOutgoingMessage(Message<?> message, InetAddressAndPort sendTo) {
        try {
            UUID sessionId = message.traceSession();
            if (sessionId == null) {
                return;
            }
            String logMessage = String.format("Sending %s message to %s", new Object[]{message.verb(), sendTo});
            TraceState state = this.get(sessionId);
            if (state == null) {
                TraceType traceType = message.traceType();
                this.trace(ByteBuffer.wrap(UUIDGen.decompose(sessionId)), logMessage, traceType.getTTL());
            } else {
                state.trace(logMessage);
                if (message.verb().isResponse()) {
                    this.doneWithNonLocalSession(state);
                }
            }
        }
        catch (Exception e) {
            logger.warn("failed to capture the tracing info for an outbound message to {}, ignoring", (Object)sendTo, (Object)e);
        }
    }

    public Map<ParamType, Object> addTraceHeaders(Map<ParamType, Object> addToMutable) {
        assert (Tracing.isTracing());
        addToMutable.put(ParamType.TRACE_SESSION, instance.getSessionId());
        addToMutable.put(ParamType.TRACE_TYPE, (Object)instance.getTraceType());
        return addToMutable;
    }

    protected abstract TraceState newTraceState(InetAddressAndPort var1, UUID var2, TraceType var3);

    public static void traceRepair(String format, Object ... args) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, args);
    }

    public static void trace(String message) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(message);
    }

    public static void trace(String format, Object arg) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, arg);
    }

    public static void trace(String format, Object arg1, Object arg2) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, arg1, arg2);
    }

    public static void trace(String format, Object ... args) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, args);
    }

    public abstract void trace(ByteBuffer var1, String var2, int var3);

    static {
        Tracing tracing = null;
        String customTracingClass = System.getProperty("cassandra.custom_tracing_class");
        if (null != customTracingClass) {
            try {
                tracing = (Tracing)FBUtilities.construct(customTracingClass, "Tracing");
                logger.info("Using {} as tracing queries (as requested with -Dcassandra.custom_tracing_class)", (Object)customTracingClass);
            }
            catch (Exception e) {
                JVMStabilityInspector.inspectThrowable(e);
                logger.error(String.format("Cannot use class %s for tracing, ignoring by defaulting to normal tracing", customTracingClass), (Throwable)e);
            }
        }
        instance = null != tracing ? tracing : new TracingImpl();
    }

    public static enum TraceType {
        NONE,
        QUERY,
        REPAIR;

        private static final TraceType[] ALL_VALUES;
        private static final int[] TTLS;

        public static TraceType deserialize(byte b) {
            if (b < 0 || ALL_VALUES.length <= b) {
                return NONE;
            }
            return ALL_VALUES[b];
        }

        public static byte serialize(TraceType value) {
            return (byte)value.ordinal();
        }

        public int getTTL() {
            return TTLS[this.ordinal()];
        }

        static {
            ALL_VALUES = TraceType.values();
            TTLS = new int[]{DatabaseDescriptor.getTracetypeQueryTTL(), DatabaseDescriptor.getTracetypeQueryTTL(), DatabaseDescriptor.getTracetypeRepairTTL()};
        }
    }
}

