/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.collect.LinkedHashMultimap;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.HostStat;
import org.apache.cassandra.tools.nodetool.HostStatWithPort;
import org.apache.cassandra.tools.nodetool.SetHostStat;
import org.apache.cassandra.tools.nodetool.SetHostStatWithPort;

@Command(name="ring", description="Print information about the token ring")
public class Ring
extends NodeTool.NodeToolCmd {
    @Arguments(description="Specify a keyspace for accurate ownership information (topology awareness)")
    private String keyspace = null;
    @Option(title="resolve_ip", name={"-r", "--resolve-ip"}, description="Show node domain names instead of IPs")
    private boolean resolveIp = false;

    @Override
    public void execute(NodeProbe probe) {
        block14: {
            try {
                Map<InetAddress, Float> ownerships;
                Map<String, String> tokensToEndpoints = probe.getTokenToEndpointMap(this.printPort);
                LinkedHashMultimap endpointsToTokens = LinkedHashMultimap.create();
                boolean haveVnodes = false;
                for (Map.Entry<String, String> entry : tokensToEndpoints.entrySet()) {
                    haveVnodes |= endpointsToTokens.containsKey((Object)entry.getValue());
                    endpointsToTokens.put((Object)entry.getValue(), (Object)entry.getKey());
                }
                int maxAddressLength = Collections.max(endpointsToTokens.keys(), new Comparator<String>(){

                    @Override
                    public int compare(String first, String second) {
                        return Integer.compare(first.length(), second.length());
                    }
                }).length();
                String formatPlaceholder = "%%-%ds  %%-12s%%-7s%%-8s%%-16s%%-20s%%-44s%%n";
                String format = String.format(formatPlaceholder, maxAddressLength);
                StringBuilder errors = new StringBuilder();
                boolean showEffectiveOwnership = true;
                if (this.printPort) {
                    Map<String, Float> ownerships2;
                    try {
                        ownerships2 = probe.effectiveOwnershipWithPort(this.keyspace);
                    }
                    catch (IllegalStateException ex) {
                        ownerships2 = probe.getOwnershipWithPort();
                        errors.append("Note: ").append(ex.getMessage()).append("%n");
                        showEffectiveOwnership = false;
                    }
                    catch (IllegalArgumentException ex) {
                        System.out.printf("%nError: %s%n", ex.getMessage());
                        return;
                    }
                    System.out.println();
                    for (Map.Entry<String, SetHostStatWithPort> entry : NodeTool.getOwnershipByDcWithPort(probe, this.resolveIp, tokensToEndpoints, ownerships2).entrySet()) {
                        this.printDc(probe, format, entry.getKey(), (LinkedHashMultimap<String, String>)endpointsToTokens, entry.getValue(), showEffectiveOwnership);
                    }
                    if (haveVnodes) {
                        System.out.println("  Warning: \"nodetool ring\" is used to output all the tokens of a node.");
                        System.out.println("  To view status related info of a node use \"nodetool status\" instead.\n");
                    }
                    System.out.printf("%n  " + errors.toString(), new Object[0]);
                    break block14;
                }
                try {
                    ownerships = probe.effectiveOwnership(this.keyspace);
                }
                catch (IllegalStateException ex) {
                    ownerships = probe.getOwnership();
                    errors.append("Note: ").append(ex.getMessage()).append("%n");
                    showEffectiveOwnership = false;
                }
                catch (IllegalArgumentException ex) {
                    System.out.printf("%nError: %s%n", ex.getMessage());
                    return;
                }
                System.out.println();
                for (Map.Entry<String, SetHostStat> entry : NodeTool.getOwnershipByDc(probe, this.resolveIp, tokensToEndpoints, ownerships).entrySet()) {
                    this.printDc(probe, format, entry.getKey(), (LinkedHashMultimap<String, String>)endpointsToTokens, entry.getValue(), showEffectiveOwnership);
                }
                if (haveVnodes) {
                    System.out.println("  Warning: \"nodetool ring\" is used to output all the tokens of a node.");
                    System.out.println("  To view status related info of a node use \"nodetool status\" instead.\n");
                }
                System.out.printf("%n  " + errors.toString(), new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    private void printDc(NodeProbe probe, String format, String dc, LinkedHashMultimap<String, String> endpointsToTokens, SetHostStat hoststats, boolean showEffectiveOwnership) {
        List<String> liveNodes = probe.getLiveNodes(false);
        List<String> deadNodes = probe.getUnreachableNodes(false);
        List<String> joiningNodes = probe.getJoiningNodes(false);
        List<String> leavingNodes = probe.getLeavingNodes(false);
        List<String> movingNodes = probe.getMovingNodes(false);
        Map<String, String> loadMap = probe.getLoadMap(false);
        System.out.println("Datacenter: " + dc);
        System.out.println("==========");
        ArrayList tokens = new ArrayList();
        String lastToken = "";
        for (HostStat stat : hoststats) {
            tokens.addAll(endpointsToTokens.get((Object)stat.endpoint.getHostAddress()));
            lastToken = (String)tokens.get(tokens.size() - 1);
        }
        System.out.printf(format, "Address", "Rack", "Status", "State", "Load", "Owns", "Token");
        if (hoststats.size() > 1) {
            System.out.printf(format, "", "", "", "", "", "", lastToken);
        } else {
            System.out.println();
        }
        for (HostStat stat : hoststats) {
            String rack;
            String endpoint = stat.endpoint.getHostAddress();
            try {
                rack = probe.getEndpointSnitchInfoProxy().getRack(endpoint);
            }
            catch (UnknownHostException e) {
                rack = "Unknown";
            }
            String status = liveNodes.contains(endpoint) ? "Up" : (deadNodes.contains(endpoint) ? "Down" : "?");
            String state = "Normal";
            if (joiningNodes.contains(endpoint)) {
                state = "Joining";
            } else if (leavingNodes.contains(endpoint)) {
                state = "Leaving";
            } else if (movingNodes.contains(endpoint)) {
                state = "Moving";
            }
            String load = loadMap.containsKey(endpoint) ? loadMap.get(endpoint) : "?";
            String owns = stat.owns != null && showEffectiveOwnership ? new DecimalFormat("##0.00%").format(stat.owns) : "?";
            System.out.printf(format, stat.ipOrDns(), rack, status, state, load, owns, stat.token);
        }
        System.out.println();
    }

    private void printDc(NodeProbe probe, String format, String dc, LinkedHashMultimap<String, String> endpointsToTokens, SetHostStatWithPort hoststats, boolean showEffectiveOwnership) {
        List<String> liveNodes = probe.getLiveNodes(true);
        List<String> deadNodes = probe.getUnreachableNodes(true);
        List<String> joiningNodes = probe.getJoiningNodes(true);
        List<String> leavingNodes = probe.getLeavingNodes(true);
        List<String> movingNodes = probe.getMovingNodes(true);
        Map<String, String> loadMap = probe.getLoadMap(true);
        System.out.println("Datacenter: " + dc);
        System.out.println("==========");
        ArrayList tokens = new ArrayList();
        String lastToken = "";
        for (HostStatWithPort stat : hoststats) {
            tokens.addAll(endpointsToTokens.get((Object)stat.endpoint.toString()));
            lastToken = (String)tokens.get(tokens.size() - 1);
        }
        System.out.printf(format, "Address", "Rack", "Status", "State", "Load", "Owns", "Token");
        if (hoststats.size() > 1) {
            System.out.printf(format, "", "", "", "", "", "", lastToken);
        } else {
            System.out.println();
        }
        for (HostStatWithPort stat : hoststats) {
            String rack;
            String endpoint = stat.endpoint.toString();
            try {
                rack = probe.getEndpointSnitchInfoProxy().getRack(endpoint);
            }
            catch (UnknownHostException e) {
                rack = "Unknown";
            }
            String status = liveNodes.contains(endpoint) ? "Up" : (deadNodes.contains(endpoint) ? "Down" : "?");
            String state = "Normal";
            if (joiningNodes.contains(endpoint)) {
                state = "Joining";
            } else if (leavingNodes.contains(endpoint)) {
                state = "Leaving";
            } else if (movingNodes.contains(endpoint)) {
                state = "Moving";
            }
            String load = loadMap.containsKey(endpoint) ? loadMap.get(endpoint) : "?";
            String owns = stat.owns != null && showEffectiveOwnership ? new DecimalFormat("##0.00%").format(stat.owns) : "?";
            System.out.printf(format, stat.ipOrDns(), rack, status, state, load, owns, stat.token);
        }
        System.out.println();
    }
}

