/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.columniterator.SSTableIterator;
import org.apache.cassandra.db.columniterator.SSTableReversedIterator;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableReadsListener;
import org.apache.cassandra.io.sstable.format.big.BigTableScanner;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigTableReader
extends SSTableReader {
    private static final Logger logger = LoggerFactory.getLogger(BigTableReader.class);

    BigTableReader(Descriptor desc, Set<Component> components, TableMetadataRef metadata, Long maxDataAge, StatsMetadata sstableMetadata, SSTableReader.OpenReason openReason, SerializationHeader header) {
        super(desc, components, metadata, maxDataAge, sstableMetadata, openReason, header);
    }

    @Override
    public UnfilteredRowIterator iterator(DecoratedKey key, Slices slices, ColumnFilter selectedColumns, boolean reversed, SSTableReadsListener listener) {
        RowIndexEntry rie = this.getPosition((PartitionPosition)key, SSTableReader.Operator.EQ, listener);
        return this.iterator(null, key, rie, slices, selectedColumns, reversed);
    }

    @Override
    public UnfilteredRowIterator iterator(FileDataInput file, DecoratedKey key, RowIndexEntry indexEntry, Slices slices, ColumnFilter selectedColumns, boolean reversed) {
        if (indexEntry == null) {
            return UnfilteredRowIterators.noRowsIterator(this.metadata(), key, Rows.EMPTY_STATIC_ROW, DeletionTime.LIVE, reversed);
        }
        return reversed ? new SSTableReversedIterator(this, file, key, indexEntry, slices, selectedColumns, this.ifile) : new SSTableIterator(this, file, key, indexEntry, slices, selectedColumns, this.ifile);
    }

    @Override
    public ISSTableScanner getScanner(ColumnFilter columns, DataRange dataRange, SSTableReadsListener listener) {
        return BigTableScanner.getScanner(this, columns, dataRange, listener);
    }

    @Override
    public ISSTableScanner getScanner(Iterator<AbstractBounds<PartitionPosition>> boundsIterator) {
        return BigTableScanner.getScanner((SSTableReader)this, boundsIterator);
    }

    @Override
    public ISSTableScanner getScanner() {
        return BigTableScanner.getScanner(this);
    }

    @Override
    public ISSTableScanner getScanner(Collection<Range<Token>> ranges) {
        if (ranges != null) {
            return BigTableScanner.getScanner((SSTableReader)this, ranges);
        }
        return this.getScanner();
    }

    @Override
    public UnfilteredRowIterator simpleIterator(FileDataInput dfile, DecoratedKey key, RowIndexEntry position, boolean tombstoneOnly) {
        return SSTableIdentityIterator.create(this, dfile, position, key, tombstoneOnly);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected RowIndexEntry getPosition(PartitionPosition key, SSTableReader.Operator op, boolean updateCacheAndStats, boolean permitMatchPastLast, SSTableReadsListener listener) {
        DecoratedKey decoratedKey;
        RowIndexEntry cachedPosition;
        if (op == SSTableReader.Operator.EQ) {
            assert (key instanceof DecoratedKey);
            if (!this.bf.isPresent((DecoratedKey)key)) {
                listener.onSSTableSkipped(this, SSTableReadsListener.SkippingReason.BLOOM_FILTER);
                Tracing.trace("Bloom filter allows skipping sstable {}", (Object)this.descriptor.generation);
                return null;
            }
        }
        if ((op == SSTableReader.Operator.EQ || op == SSTableReader.Operator.GE) && key instanceof DecoratedKey && (cachedPosition = this.getCachedPosition(decoratedKey = (DecoratedKey)key, updateCacheAndStats)) != null) {
            listener.onSSTableSelected(this, cachedPosition, SSTableReadsListener.SelectionReason.KEY_CACHE_HIT);
            Tracing.trace("Key cache hit for sstable {}", (Object)this.descriptor.generation);
            return cachedPosition;
        }
        boolean skip = false;
        if (key.compareTo(this.first) < 0) {
            if (op == SSTableReader.Operator.EQ) {
                skip = true;
            } else {
                key = this.first;
            }
            op = SSTableReader.Operator.EQ;
        } else {
            int l = this.last.compareTo(key);
            boolean bl = skip = l <= 0 && (l < 0 || !permitMatchPastLast && op == SSTableReader.Operator.GT);
        }
        if (skip) {
            if (op == SSTableReader.Operator.EQ && updateCacheAndStats) {
                this.bloomFilterTracker.addFalsePositive();
            }
            listener.onSSTableSkipped(this, SSTableReadsListener.SkippingReason.MIN_MAX_KEYS);
            Tracing.trace("Check against min and max keys allows skipping sstable {}", (Object)this.descriptor.generation);
            return null;
        }
        int binarySearchResult = this.indexSummary.binarySearch(key);
        long sampledPosition = BigTableReader.getIndexScanPositionFromBinarySearchResult(binarySearchResult, this.indexSummary);
        int sampledIndex = BigTableReader.getIndexSummaryIndexFromBinarySearchResult(binarySearchResult);
        int effectiveInterval = this.indexSummary.getEffectiveIndexIntervalAfterIndex(sampledIndex);
        if (this.ifile == null) {
            return null;
        }
        int i = 0;
        String path = null;
        try (FileDataInput in = this.ifile.createReader(sampledPosition);){
            path = in.getPath();
            while (!in.isEOF()) {
                boolean opSatisfied;
                boolean exactMatch;
                ByteBuffer indexKey = ByteBufferUtil.readWithShortLength(in);
                if (op == SSTableReader.Operator.EQ && ++i <= effectiveInterval) {
                    opSatisfied = exactMatch = indexKey.equals(((DecoratedKey)key).getKey());
                } else {
                    DecoratedKey indexDecoratedKey = this.decorateKey(indexKey);
                    int comparison = indexDecoratedKey.compareTo(key);
                    int v = op.apply(comparison);
                    opSatisfied = v == 0;
                    boolean bl = exactMatch = comparison == 0;
                    if (v < 0) {
                        listener.onSSTableSkipped(this, SSTableReadsListener.SkippingReason.PARTITION_INDEX_LOOKUP);
                        Tracing.trace("Partition index lookup allows skipping sstable {}", (Object)this.descriptor.generation);
                        RowIndexEntry rowIndexEntry = null;
                        return rowIndexEntry;
                    }
                }
                if (opSatisfied) {
                    RowIndexEntry indexEntry = this.rowIndexEntrySerializer.deserialize(in, in.getFilePointer());
                    if (exactMatch && updateCacheAndStats) {
                        assert (key instanceof DecoratedKey);
                        DecoratedKey decoratedKey2 = (DecoratedKey)key;
                        if (logger.isTraceEnabled()) {
                            try (FileDataInput fdi = this.dfile.createReader(indexEntry.position);){
                                DecoratedKey keyInDisk = this.decorateKey(ByteBufferUtil.readWithShortLength(fdi));
                                if (!keyInDisk.equals(key)) {
                                    throw new AssertionError((Object)String.format("%s != %s in %s", keyInDisk, key, fdi.getPath()));
                                }
                            }
                        }
                        this.cacheKey(decoratedKey2, indexEntry);
                    }
                    if (op == SSTableReader.Operator.EQ && updateCacheAndStats) {
                        this.bloomFilterTracker.addTruePositive();
                    }
                    listener.onSSTableSelected(this, indexEntry, SSTableReadsListener.SelectionReason.INDEX_ENTRY_FOUND);
                    Tracing.trace("Partition index with {} entries found for sstable {}", (Object)indexEntry.columnsIndexCount(), (Object)this.descriptor.generation);
                    RowIndexEntry rowIndexEntry = indexEntry;
                    return rowIndexEntry;
                }
                RowIndexEntry.Serializer.skip(in, this.descriptor.version);
            }
        }
        catch (IOException e) {
            this.markSuspect();
            throw new CorruptSSTableException((Throwable)e, path);
        }
        if (op == SSTableReader.Operator.EQ && updateCacheAndStats) {
            this.bloomFilterTracker.addFalsePositive();
        }
        listener.onSSTableSkipped(this, SSTableReadsListener.SkippingReason.INDEX_ENTRY_NOT_FOUND);
        Tracing.trace("Partition index lookup complete (bloom filter false positive) for sstable {}", (Object)this.descriptor.generation);
        return null;
    }
}

