/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.db.virtual.VirtualKeyspace;
import org.apache.cassandra.db.virtual.VirtualKeyspaceRegistry;
import org.apache.cassandra.db.virtual.VirtualTable;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.TableMetadata;

public final class VirtualSchemaKeyspace
extends VirtualKeyspace {
    private static final String NAME = "system_virtual_schema";
    public static final VirtualSchemaKeyspace instance = new VirtualSchemaKeyspace();

    private VirtualSchemaKeyspace() {
        super(NAME, (Collection<VirtualTable>)ImmutableList.of((Object)new VirtualKeyspaces(NAME), (Object)new VirtualTables(NAME), (Object)new VirtualColumns(NAME)));
    }

    private static final class VirtualColumns
    extends AbstractVirtualTable {
        private static final String KEYSPACE_NAME = "keyspace_name";
        private static final String TABLE_NAME = "table_name";
        private static final String COLUMN_NAME = "column_name";
        private static final String CLUSTERING_ORDER = "clustering_order";
        private static final String COLUMN_NAME_BYTES = "column_name_bytes";
        private static final String KIND = "kind";
        private static final String POSITION = "position";
        private static final String TYPE = "type";

        private VirtualColumns(String keyspace) {
            super(TableMetadata.builder(keyspace, "columns").comment("virtual column definitions").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(UTF8Type.instance)).addPartitionKeyColumn(KEYSPACE_NAME, (AbstractType)UTF8Type.instance).addClusteringColumn(TABLE_NAME, (AbstractType)UTF8Type.instance).addClusteringColumn(COLUMN_NAME, (AbstractType)UTF8Type.instance).addRegularColumn(CLUSTERING_ORDER, (AbstractType)UTF8Type.instance).addRegularColumn(COLUMN_NAME_BYTES, (AbstractType)BytesType.instance).addRegularColumn(KIND, (AbstractType)UTF8Type.instance).addRegularColumn(POSITION, (AbstractType)Int32Type.instance).addRegularColumn(TYPE, (AbstractType)UTF8Type.instance).build());
        }

        @Override
        public AbstractVirtualTable.DataSet data() {
            SimpleDataSet result = new SimpleDataSet(this.metadata());
            for (KeyspaceMetadata keyspace : VirtualKeyspaceRegistry.instance.virtualKeyspacesMetadata()) {
                for (TableMetadata table : keyspace.tables) {
                    for (ColumnMetadata column : table.columns()) {
                        result.row(column.ksName, column.cfName, column.name.toString()).column(CLUSTERING_ORDER, column.clusteringOrder().toString().toLowerCase()).column(COLUMN_NAME_BYTES, column.name.bytes).column(KIND, column.kind.toString().toLowerCase()).column(POSITION, column.position()).column(TYPE, column.type.asCQL3Type().toString());
                    }
                }
            }
            return result;
        }
    }

    private static final class VirtualTables
    extends AbstractVirtualTable {
        private static final String KEYSPACE_NAME = "keyspace_name";
        private static final String TABLE_NAME = "table_name";
        private static final String COMMENT = "comment";

        private VirtualTables(String keyspace) {
            super(TableMetadata.builder(keyspace, "tables").comment("virtual table definitions").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(UTF8Type.instance)).addPartitionKeyColumn(KEYSPACE_NAME, (AbstractType)UTF8Type.instance).addClusteringColumn(TABLE_NAME, (AbstractType)UTF8Type.instance).addRegularColumn(COMMENT, (AbstractType)UTF8Type.instance).build());
        }

        @Override
        public AbstractVirtualTable.DataSet data() {
            SimpleDataSet result = new SimpleDataSet(this.metadata());
            for (KeyspaceMetadata keyspace : VirtualKeyspaceRegistry.instance.virtualKeyspacesMetadata()) {
                for (TableMetadata table : keyspace.tables) {
                    result.row(table.keyspace, table.name).column(COMMENT, table.params.comment);
                }
            }
            return result;
        }
    }

    private static final class VirtualKeyspaces
    extends AbstractVirtualTable {
        private static final String KEYSPACE_NAME = "keyspace_name";

        private VirtualKeyspaces(String keyspace) {
            super(TableMetadata.builder(keyspace, "keyspaces").comment("virtual keyspace definitions").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(UTF8Type.instance)).addPartitionKeyColumn(KEYSPACE_NAME, (AbstractType)UTF8Type.instance).build());
        }

        @Override
        public AbstractVirtualTable.DataSet data() {
            SimpleDataSet result = new SimpleDataSet(this.metadata());
            for (KeyspaceMetadata keyspace : VirtualKeyspaceRegistry.instance.virtualKeyspacesMetadata()) {
                result.row(keyspace.name);
            }
            return result;
        }
    }
}

