/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.EmptyType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.DroppedColumn;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.utils.ByteBufferUtil;

public class TableCQLHelper {
    private static final Pattern singleQuotePattern = Pattern.compile("'");

    public static List<String> dumpReCreateStatements(TableMetadata metadata) {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(TableCQLHelper.getUserTypesAsCQL(metadata));
        l.add(TableCQLHelper.getTableMetadataAsCQL(metadata, true));
        l.addAll(TableCQLHelper.getDroppedColumnsAsCQL(metadata));
        l.addAll(TableCQLHelper.getIndexesAsCQL(metadata));
        return l;
    }

    private static List<ColumnMetadata> getClusteringColumns(TableMetadata metadata) {
        ArrayList<ColumnMetadata> cds = new ArrayList<ColumnMetadata>(metadata.clusteringColumns().size());
        if (!metadata.isStaticCompactTable()) {
            for (ColumnMetadata cd : metadata.clusteringColumns()) {
                cds.add(cd);
            }
        }
        return cds;
    }

    private static List<ColumnMetadata> getPartitionColumns(TableMetadata metadata) {
        ArrayList<ColumnMetadata> cds;
        block4: {
            block3: {
                cds = new ArrayList<ColumnMetadata>(metadata.regularAndStaticColumns().size());
                for (ColumnMetadata cd : metadata.staticColumns()) {
                    cds.add(cd);
                }
                if (!metadata.isDense()) break block3;
                for (ColumnMetadata cd : metadata.regularColumns()) {
                    if (cd.type.equals(EmptyType.instance)) continue;
                    cds.add(cd);
                }
                break block4;
            }
            if (metadata.isStaticCompactTable()) break block4;
            for (ColumnMetadata cd : metadata.regularColumns()) {
                cds.add(cd);
            }
        }
        return cds;
    }

    @VisibleForTesting
    public static String getTableMetadataAsCQL(TableMetadata metadata, boolean includeDroppedColumns) {
        StringBuilder sb = new StringBuilder();
        if (!TableCQLHelper.isCqlCompatible(metadata)) {
            sb.append(String.format("/*\nWarning: Table %s omitted because it has constructs not compatible with CQL (was created via legacy API).\n", metadata.toString()));
            sb.append("\nApproximate structure, for reference:");
            sb.append("\n(this should not be used to reproduce this schema)\n\n");
        }
        sb.append("CREATE TABLE IF NOT EXISTS ");
        sb.append(metadata.toString()).append(" (");
        ImmutableList<ColumnMetadata> partitionKeyColumns = metadata.partitionKeyColumns();
        List<ColumnMetadata> clusteringColumns = TableCQLHelper.getClusteringColumns(metadata);
        List<ColumnMetadata> partitionColumns = TableCQLHelper.getPartitionColumns(metadata);
        Consumer<StringBuilder> cdCommaAppender = TableCQLHelper.commaAppender("\n\t");
        sb.append("\n\t");
        for (ColumnMetadata cfd : partitionKeyColumns) {
            cdCommaAppender.accept(sb);
            sb.append(TableCQLHelper.toCQL(cfd));
            if (partitionKeyColumns.size() != 1 || clusteringColumns.size() != 0) continue;
            sb.append(" PRIMARY KEY");
        }
        for (ColumnMetadata cfd : clusteringColumns) {
            cdCommaAppender.accept(sb);
            sb.append(TableCQLHelper.toCQL(cfd));
        }
        for (ColumnMetadata cfd : partitionColumns) {
            cdCommaAppender.accept(sb);
            sb.append(TableCQLHelper.toCQL(cfd, metadata.isStaticCompactTable()));
        }
        if (includeDroppedColumns) {
            for (Object entry : metadata.droppedColumns.entrySet()) {
                if (metadata.getColumn((ByteBuffer)entry.getKey()) != null) continue;
                DroppedColumn droppedColumn = (DroppedColumn)entry.getValue();
                cdCommaAppender.accept(sb);
                sb.append(droppedColumn.column.name.toCQLString());
                sb.append(' ');
                sb.append(droppedColumn.column.type.asCQL3Type().toString());
            }
        }
        if (clusteringColumns.size() > 0 || partitionKeyColumns.size() > 1) {
            sb.append(",\n\tPRIMARY KEY (");
            if (partitionKeyColumns.size() > 1) {
                sb.append("(");
                UnmodifiableIterator pkCommaAppender = TableCQLHelper.commaAppender(" ");
                for (ColumnMetadata cfd : partitionKeyColumns) {
                    pkCommaAppender.accept(sb);
                    sb.append(cfd.name.toCQLString());
                }
                sb.append(")");
            } else {
                sb.append(((ColumnMetadata)partitionKeyColumns.get((int)0)).name.toCQLString());
            }
            for (ColumnMetadata cfd : metadata.clusteringColumns()) {
                sb.append(", ").append(cfd.name.toCQLString());
            }
            sb.append(')');
        }
        sb.append(")\n\t");
        sb.append("WITH ");
        sb.append("ID = ").append(metadata.id).append("\n\tAND ");
        if (metadata.isCompactTable()) {
            sb.append("COMPACT STORAGE\n\tAND ");
        }
        if (clusteringColumns.size() > 0) {
            sb.append("CLUSTERING ORDER BY (");
            Consumer<StringBuilder> cOrderCommaAppender = TableCQLHelper.commaAppender(" ");
            for (ColumnMetadata cd : clusteringColumns) {
                cOrderCommaAppender.accept(sb);
                sb.append(cd.name.toCQLString()).append(' ').append(cd.clusteringOrder().toString());
            }
            sb.append(")\n\tAND ");
        }
        sb.append(TableCQLHelper.toCQL(metadata.params));
        sb.append(";");
        if (!TableCQLHelper.isCqlCompatible(metadata)) {
            sb.append("\n*/");
        }
        return sb.toString();
    }

    @VisibleForTesting
    public static List<String> getUserTypesAsCQL(TableMetadata metadata) {
        ArrayList<AbstractType> types = new ArrayList<AbstractType>();
        HashSet<AbstractType> typeSet = new HashSet<AbstractType>();
        for (ColumnMetadata cd : Iterables.concat(metadata.partitionKeyColumns(), metadata.clusteringColumns(), (Iterable)metadata.regularAndStaticColumns())) {
            AbstractType type = cd.type;
            if (!type.isUDT()) continue;
            TableCQLHelper.resolveUserType((UserType)type, typeSet, types);
        }
        ArrayList<String> typeStrings = new ArrayList<String>(types.size());
        for (AbstractType type : types) {
            typeStrings.add(TableCQLHelper.toCQL((UserType)type));
        }
        return typeStrings;
    }

    @VisibleForTesting
    public static List<String> getDroppedColumnsAsCQL(TableMetadata metadata) {
        ArrayList<String> droppedColumns = new ArrayList<String>();
        for (Map.Entry entry : metadata.droppedColumns.entrySet()) {
            DroppedColumn column = (DroppedColumn)entry.getValue();
            droppedColumns.add(TableCQLHelper.toCQLDrop(metadata, column));
            if (metadata.getColumn((ByteBuffer)entry.getKey()) == null) continue;
            droppedColumns.add(TableCQLHelper.toCQLAdd(metadata, metadata.getColumn((ByteBuffer)entry.getKey())));
        }
        return droppedColumns;
    }

    @VisibleForTesting
    public static List<String> getIndexesAsCQL(TableMetadata metadata) {
        ArrayList<String> indexes = new ArrayList<String>(metadata.indexes.size());
        for (IndexMetadata indexMetadata : metadata.indexes) {
            indexes.add(TableCQLHelper.toCQL(metadata, indexMetadata));
        }
        return indexes;
    }

    private static String toCQL(TableMetadata baseTable, IndexMetadata indexMetadata) {
        if (indexMetadata.isCustom()) {
            HashMap options = new HashMap();
            indexMetadata.options.forEach((k, v) -> {
                if (!k.equals("target") && !k.equals("class_name")) {
                    options.put(k, v);
                }
            });
            return String.format("CREATE CUSTOM INDEX %s ON %s (%s) USING '%s'%s;", indexMetadata.toCQLString(), baseTable.toString(), indexMetadata.options.get("target"), indexMetadata.options.get("class_name"), options.isEmpty() ? "" : " WITH OPTIONS " + TableCQLHelper.toCQL(options));
        }
        return String.format("CREATE INDEX %s ON %s (%s);", indexMetadata.toCQLString(), baseTable.toString(), indexMetadata.options.get("target"));
    }

    private static String toCQL(UserType userType) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TYPE ").append(userType.toCQLString()).append(" (");
        Consumer<StringBuilder> commaAppender = TableCQLHelper.commaAppender(" ");
        for (int i = 0; i < userType.size(); ++i) {
            commaAppender.accept(sb);
            sb.append(String.format("%s %s", userType.fieldNameAsString(i), userType.fieldType(i).asCQL3Type()));
        }
        sb.append(");");
        return sb.toString();
    }

    private static String toCQL(TableParams tableParams) {
        StringBuilder builder = new StringBuilder();
        builder.append("bloom_filter_fp_chance = ").append(tableParams.bloomFilterFpChance);
        builder.append("\n\tAND crc_check_chance = ").append(tableParams.crcCheckChance);
        builder.append("\n\tAND default_time_to_live = ").append(tableParams.defaultTimeToLive);
        builder.append("\n\tAND gc_grace_seconds = ").append(tableParams.gcGraceSeconds);
        builder.append("\n\tAND min_index_interval = ").append(tableParams.minIndexInterval);
        builder.append("\n\tAND max_index_interval = ").append(tableParams.maxIndexInterval);
        builder.append("\n\tAND memtable_flush_period_in_ms = ").append(tableParams.memtableFlushPeriodInMs);
        builder.append("\n\tAND speculative_retry = '").append(tableParams.speculativeRetry).append("'");
        builder.append("\n\tAND additional_write_policy = '").append(tableParams.additionalWritePolicy).append("'");
        builder.append("\n\tAND comment = ").append(TableCQLHelper.singleQuote(tableParams.comment));
        builder.append("\n\tAND caching = ").append(TableCQLHelper.toCQL(tableParams.caching.asMap()));
        builder.append("\n\tAND compaction = ").append(TableCQLHelper.toCQL(tableParams.compaction.asMap()));
        builder.append("\n\tAND compression = ").append(TableCQLHelper.toCQL(tableParams.compression.asMap()));
        builder.append("\n\tAND cdc = ").append(tableParams.cdc);
        builder.append("\n\tAND extensions = { ");
        for (Map.Entry entry : tableParams.extensions.entrySet()) {
            builder.append(TableCQLHelper.singleQuote((String)entry.getKey()));
            builder.append(": ");
            builder.append("0x").append(ByteBufferUtil.bytesToHex((ByteBuffer)entry.getValue()));
        }
        builder.append(" }");
        return builder.toString();
    }

    private static String toCQL(Map<?, ?> map) {
        StringBuilder builder = new StringBuilder("{ ");
        boolean isFirst = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append(TableCQLHelper.singleQuote(entry.getKey().toString()));
            builder.append(": ");
            builder.append(TableCQLHelper.singleQuote(entry.getValue().toString()));
        }
        builder.append(" }");
        return builder.toString();
    }

    private static String toCQL(ColumnMetadata cd) {
        return TableCQLHelper.toCQL(cd, false);
    }

    private static String toCQL(ColumnMetadata cd, boolean isStaticCompactTable) {
        return String.format("%s %s%s", cd.name.toCQLString(), cd.type.asCQL3Type().toString(), cd.isStatic() && !isStaticCompactTable ? " static" : "");
    }

    private static String toCQLAdd(TableMetadata table, ColumnMetadata cd) {
        return String.format("ALTER TABLE %s ADD %s %s%s;", table.toString(), cd.name.toCQLString(), cd.type.asCQL3Type().toString(), cd.isStatic() ? " static" : "");
    }

    private static String toCQLDrop(TableMetadata table, DroppedColumn droppedColumn) {
        return String.format("ALTER TABLE %s DROP %s USING TIMESTAMP %s;", table.toString(), droppedColumn.column.name.toCQLString(), droppedColumn.droppedTime);
    }

    private static void resolveUserType(UserType type, Set<AbstractType> typeSet, List<AbstractType> types) {
        for (AbstractType<?> subType : type.fieldTypes()) {
            if (typeSet.contains(subType) || !subType.isUDT()) continue;
            TableCQLHelper.resolveUserType((UserType)subType, typeSet, types);
        }
        if (!typeSet.contains(type)) {
            typeSet.add(type);
            types.add(type);
        }
    }

    private static String singleQuote(String s) {
        return String.format("'%s'", singleQuotePattern.matcher(s).replaceAll("''"));
    }

    private static Consumer<StringBuilder> commaAppender(final String afterComma) {
        final AtomicBoolean isFirst = new AtomicBoolean(true);
        return new Consumer<StringBuilder>(){

            @Override
            public void accept(StringBuilder stringBuilder) {
                if (!isFirst.getAndSet(false)) {
                    stringBuilder.append(',').append(afterComma);
                }
            }
        };
    }

    public static boolean isCqlCompatible(TableMetadata metaData) {
        if (metaData.isSuper()) {
            return false;
        }
        return !metaData.isCompactTable() || metaData.regularColumns().size() <= 1 || metaData.clusteringColumns().size() < 1;
    }
}

